#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/mman.h>
#include <string.h>
#include <unistd.h>

typedef unsigned char BYTE;
typedef unsigned short int WORD;

int main(int argc,char **argv)
{
    FILE *output;
    
	int fd1=open("transdic",O_RDONLY);
    if(fd1==-1)
    {
        fprintf(stderr,"Input File transdic not found\r\n");
        return -2;
    }
	// get length of dicfile.
	struct stat stStat1;
	if(fstat(fd1,&stStat1)!=0)
	{
        fprintf(stderr,"Input File transdic error\r\n");
        close(fd1);
        return -3;
    }

	// mmap the file to memory
	caddr_t pFileMem1=(caddr_t)mmap((caddr_t)0,stStat1.st_size,
		PROT_READ | PROT_WRITE,MAP_PRIVATE,fd1,0);
	if(pFileMem1==MAP_FAILED)
	{
        fprintf(stderr,"mmap error !");
		return(-5);
    }

    int fd2=open("yblib",O_RDONLY);
    if(fd2==-1)
    {
        fprintf(stderr,"Input File yblib not found\r\n");
        close(fd2);
        return -2;
    }
	// get length of dicfile.
	struct stat stStat2;
	if(fstat(fd2,&stStat2)!=0)
	{
        fprintf(stderr,"Input File yblib error\r\n");
        close(fd1);
        close(fd2);
        return -3;
    }

	// mmap the file to memory
	caddr_t pFileMem2=(caddr_t)mmap((caddr_t)0,stStat2.st_size,
		PROT_READ | PROT_WRITE,MAP_PRIVATE,fd2,0);
	if(pFileMem2==MAP_FAILED)
	{
        fprintf(stderr,"mmap error !");
		return(-6);
    }
    
    if (!(output = fopen("trans.dic", "wb")))
    {
        fprintf(stderr,"Unable to open outfile\r\n");
        close(fd1);
        close(fd2);
        return -2;
    }

    // begin to read items.
	caddr_t p1=pFileMem1;
    caddr_t p2=pFileMem2;
    
    BYTE fakebuf = '\0';
    int iResult;
    unsigned int ItemCount=0;
    
	while( (p1<pFileMem1+stStat1.st_size) || (p2<pFileMem2+stStat2.st_size) )
	{
        ItemCount++;
        if ( p1>=pFileMem1+stStat1.st_size ) // file1 end
            iResult = 1;
        else if ( p2>=pFileMem2+stStat2.st_size ) // file2 end
            iResult = -1;
        else iResult = strcasecmp(p1,p2);
        
        if ( iResult == 0 )     // equal
        {
            fwrite(p1,sizeof(BYTE),strlen(p1)+1,output);  //english words
            p1+=strlen(p1)+1;       //p1 now point to chinese
            fwrite(p1,sizeof(BYTE),strlen(p1)+1,output);  //chinese meaning
            p1+=strlen(p1)+1;
            p2+=strlen(p2)+1;       //skip english words in 2ed file
            fwrite(p2,sizeof(BYTE),strlen(p2)+1,output);  //mark
            p2+=strlen(p2)+1;
        }
        else if ( iResult < 0 )     //no mark
        {
            fwrite(p1,sizeof(BYTE),strlen(p1)+1,output);  //english words
            p1+=strlen(p1)+1;       //p1 now point to chinese
            fwrite(p1,sizeof(BYTE),strlen(p1)+1,output);  //chinese meaning
            p1+=strlen(p1)+1;
            fwrite(&fakebuf,sizeof(BYTE),1,output);        //fake mark
        }
        else                        //no chinese
        {
            fwrite(p2,sizeof(BYTE),strlen(p2)+1,output);  //english words
            p2+=strlen(p2)+1;       //p2 now point to mark
            fwrite(&fakebuf,sizeof(BYTE),1,output);        //fake chinese
            fwrite(p2,sizeof(BYTE),strlen(p2)+1,output);  //mark
            p2+=strlen(p2)+1;                             //next
        }
    }
    
    fwrite(&ItemCount,sizeof(int),1,output);
    int style = (0<<24) + (0<<16) + (1<<8) + 4;
    fwrite(&style,sizeof(int),1,output);

	close(fd1);
    close(fd2);
    fclose(output);    
    return 0;
}
