#ifndef _OPERA_TRAYICON_H
#define _OPERA_TRAYICON_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>

#define SYSTEM_TRAY_REQUEST_DOCK    0
#define SYSTEM_TRAY_BEGIN_MESSAGE   1
#define SYSTEM_TRAY_CANCEL_MESSAGE  2

#define TRAYICON_MESSAGE_TYPE   "_TRAYICON_MESSAGE_TYPE"
#define TRAYICON_DOCKED     0L
#define TRAYICON_UNDOCKED   1L
#define TRAYICON_LBUTTON    2L
#define TRAYICON_RBUTTON    3L
#define TRAYICON_PRESENT    4L

class TrayIcon {
public:
    TrayIcon();
    ~TrayIcon();
    void Init(Display * display, Window window);
    bool Install(Pixmap icon, Pixmap iconmask, const char * name);
    void UpdateIcon(Pixmap icon, Pixmap iconmask);
    bool bEventFilter(XEvent * pEvent);
    bool bSendBalloonMessage(const char * message, int timeout);
/*    Remove();
    UpdateIcon();
    UpdateTooltip();
    RegisterCallback();*/
private:
    Display * m_display;
    Window m_window;
    Window m_traywindow;
    Window m_systraywindow;
    enum _traystyle {
        NotValid,
        StandardSpec,
        KDE
    } m_traystyle;
    
    bool is_kde_wm(void);
    bool SysTrayPresent(void);
    bool SendTrayMessage(long MessageType,long ,long );
    void vCreateTrayWindow(void);
    void vDestroyTrayWindow(void);
    
    // standard protocol
    Atom _NET_SYSTEM_TRAY_OPCODE_Atom;
    Atom _NET_SYSTEM_TRAY_Sn_Atom;  // KDE 3, Gnome 2
    Atom MANAGER_Atom;
    Atom _NET_SYSTEM_TRAY_MESSAGE_DATA_Atom;
    // kde protocol
    Atom KWM_DOCKWINDOW_Atom;   // KDE 1, Gnome 1
    Atom _KDE_NET_SYSTEM_TRAY_WINDOW_FOR_Atom;  // KDE 2,3
    // my message
    Atom TRAYICON_MESSAGE_TYPE_Atom;
};

#endif //   _OPERA_TRAYICON_H
