/* 
    Writer : Opera Wang
    E-Mail : wangvisual@sohu.com
    BBS ID : wangvisual@smth or opera@ƯˮƼ
    License: GPL
*/

#include "ocr.h"
#include <stdio.h>
#include <X11/Xatom.h>
#ifdef OCR_DEBUG
#include <sys/time.h>
#endif

#define MINWIDTH 16
#define MINHEIGHT 8

OCR::OCR()
{
    m_display = NULL;
    ImageBuffer = NULL;
    iWindowWidth = 256;
    iWindowHeight = 72;
}

OCR::~OCR()
{
    if ( ImageBuffer )
        delete [] ImageBuffer;
}

bool OCR::bInit(Display * display)
{
    assert(display);
    if (!display)
        return false;
    m_display = display;
    if ( !ImageBuffer )
        ImageBuffer = new char [iWindowWidth*iWindowHeight*3];
    
    // get OCR data
}

/* Find a window with WM_STATE, else return win itself, as per ICCCM */
Window OCR::wGetTopLevelWindow( Window win )
{
    Atom WM_STATE;
    Atom type = None;
    int format;
    unsigned long nitems, after;
    unsigned char *data;
    Window inf, root, parent;
    Window *children;
    unsigned int nchildren;

    WM_STATE = XInternAtom( m_display, "WM_STATE", True );
    if ( !WM_STATE )
        return win;

    inf = win;
    while ( true )
    {
        if ( XGetWindowProperty( m_display, inf, WM_STATE, 0, 0, False, AnyPropertyType,
                                 &type, &format, &nitems, &after, &data ) != Success )
            return win;
        XFree( data );
        if ( type )
        {
            printf( "Find it %d\n", inf );
            return inf;
        }
        if ( !XQueryTree( m_display, inf, &root, &parent, &children, &nchildren ) )
            return win;
        if ( children )
            XFree( ( char * ) children );
        inf = parent;
        if ( inf == root )
            return win;
    }
    return win;                 // dummy
}

bool OCR::bGetImageAtMouse()
{
    Window rootwindow,childwindow,toplevelwindow;
    int winx,winy;
    unsigned int buttons;
    XQueryPointer(m_display,DefaultRootWindow(m_display),&rootwindow,
        &childwindow,&rootx,&rooty,&winx,&winy,&buttons);
    toplevelwindow = wGetTopLevelWindow(childwindow);
    
    // Get the root's attributes, including colormap, depth and visual.
    // This is overwritten if a child window is processed
    XWindowAttributes xwar,xwat;
    if ( !XGetWindowAttributes( m_display, rootwindow, &xwar ) )
        return false;
    if ( !XGetWindowAttributes( m_display, toplevelwindow, &xwat ) )
        return false;

    int x2,y2;
    xrect.x = rootx - iWindowWidth/2;
    x2 = rootx + iWindowWidth/2 - 1;
    xrect.y = rooty - iWindowHeight/2;
    y2 = rooty + iWindowHeight/2 -1;
    int hScreen  = DefaultScreen(m_display);
    dwidth = DisplayWidth(m_display, hScreen);
    dheight = DisplayHeight(m_display, hScreen);
    if ( xrect.x < 0 )
        xrect.x = 0;
    if ( xrect.x < xwat.x )
        xrect.x = xwat.x;
    if ( xrect.y < 0 )
        xrect.y = 0;
    if ( xrect.y < xwat.y )
        xrect.y = xwat.y;
    if ( x2 > dwidth )
        x2 = dwidth;
    if ( x2 > xwat.width+xwat.x )
        x2 = xwat.width+xwat.x;
    if ( y2 > dheight )
        y2 = dheight;
    if ( y2 > xwat.height+xwat.y )
        y2 = xwat.height+xwat.y;
    xrect.width = x2 - xrect.x + 1;
    xrect.height = y2 - xrect.y + 1;
    
    if ( xrect.width < MINWIDTH )
        return false;
    if ( xrect.height < MINHEIGHT )
        return false;

    XImage *ximage;
    ximage = XGetImage( m_display, toplevelwindow,
                        xrect->x, xrect->y, xrect->width, xrect->height, AllPlanes,
                        xwat.depth == 1 ? XYPixmap : ZPixmap );
    
    // Copy to ImageBuffer
    switch ( xwat.visual->c_class )
    {
    case StaticColor:
    case StaticGray:
    case GrayScale:
    case PseudoColor:
        {
            int ncolors = xwat.visual->map_entries;
            int x,y,i;
            XColor *colors;
            unsigned long pixel;

            colors = ( XColor * ) XtMalloc( ncolors * sizeof( XColor ) );
            for ( i = 0; i < ncolors; ++i )
                colors[i].pixel = i;
            XQueryColors( m_display, xwat.colormap, colors, ncolors );
            for ( i = 0; i < ncolors; ++i )
            {
                colors[i].red = colors[i].red / 257;
                colors[i].green = colors[i].green / 257;
                colors[i].blue = colors[i].blue / 257;
            }
            i = 0;
            for ( y = 0; y < xrect.height; ++y )
                for ( x = 0; x < xrect.width; ++x )
                {
                    pixel = XGetPixel( ximage, x, y );
                    ImageBuffer[i++] = (unsigned char)colors[pixel].red;
                    ImageBuffer[i++] = (unsigned char)colors[pixel].green;
                    ImageBuffer[i++] = (unsigned char)colors[pixel].blue;
                }
            XtFree( ( char * ) colors );
        }
        break;
    case DirectColor:
    case TrueColor:
        {
            unsigned long rm, gm, bm;
            int rs, gs, bs;
            int r, g, b, i;
            unsigned long pixel;
            rm = xwat.visual->red_mask;
            gm = xwat.visual->green_mask;
            bm = xwat.visual->blue_mask;

            rs = highbit( rm ) - 7;
            gs = highbit( gm ) - 7;
            bs = highbit( bm ) - 7;
            rm = rs > 0 ? ( rm >> rs ) : ( rm << -rs );
            gm = gs > 0 ? ( gm >> gs ) : ( gm << -gs );
            bm = bs > 0 ? ( bm >> bs ) : ( bm << -bs );

            i = 0;
            for ( y = 0; y < xrect.height; ++y )
                for ( x = 0; x < xrect.width; ++x )
                {
                    pixel = XGetPixel( ximage, x, y );

                    r = rs > 0 ? pixel >> rs : pixel << -rs;
                    g = gs > 0 ? pixel >> gs : pixel << -gs;
                    b = bs > 0 ? pixel >> bs : pixel << -bs;
                    ImageBuffer[i++] = (unsigned char)(r & rm);
                    ImageBuffer[i++] = (unsigned char)(g & gm);
                    ImageBuffer[i++] = (unsigned char)(b & bm);
                }
            }
        break;
    }
    XDestroyImage(ximage);ximage = NULL;
    // Delete Background color
}

char * OCR::sSimpleGetWord()
{
    
}

char * OCR::sGetPossibleWords()
{
#ifdef OCR_DEBUG
    timeval start;
    gettimeofday(&start,NULL);
#endif
    assert(m_display);
    if (!m_display)
        return NULL;
    if ( !bGetImageAtMouse() )
        return NULL;
    
#ifdef OCR_DEBUG
    timeval end;
    gettimeofday(&end,NULL);
    long seconds, mseconds;
    seconds = end.tv_sec - start.tv_sec;
    mseconds = end.tv_usec - start._tv_usec;
    if ( mseconds < 0 )
    {
        mseconds = 1000 - mseconds;
        seconds --;
    }
    printf("GetAllPossibleWords use %ld.%0ld seconds\n",seconds,mseconds);
#endif
}

// EOF
