#ifndef OPERA_LIBS_H
#define OPERA_LIBS_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifndef HAVE_SNPRINTF
#   if ( defined __sun__ || defined HAVE_SUN_OS || defined __sparc )
#       include <sys/auxv.h>
#       ifndef AT_SUN_EXECNAME
#           define NO_SNPRINTF 1
#       endif
#   endif
#endif

typedef unsigned short int WORD;
typedef unsigned char BYTE;

#define MAX_STR_LEN 256

#define LIB_TYPE_RESERVED '\0'
#define LIB_TYPE_WORD '\1'
#define LIB_TYPE_MEANING '\2'
#define LIB_TYPE_MARK '\3'
#define LIB_WORD_ENGLISH '\0'
#define LIB_WORD_GB '\1'
#define LIB_WORD_BIG5 '\2'
#define LIB_WORD_PY '\3'
#define LIB_MEANING_ENGLISH '\0'
#define LIB_MEANING_GB '\1'
#define LIB_MEANING_BIG5 '\2'
//#define LIB_MEANING_CHINESE_AND_ENGLISH '\3'
#define LIB_MARK_NOMARK '\0'
#define LIB_MARK_PY '\3'
#define LIB_MARK_YB '\4'
#define LIB_SEARCH_TYPE_INDEX '\0'
#define LIB_SEARCH_TYPE_MEANING '\1'
#define LIST_WORD '\0'
#define LIST_MEANING '\1'
#define INVALID_INDEX -100
#define SEARCH_INDEX_UP -1
#define SEARCH_INDEX_DOWN 1
#define STRING_TYPE_ASCII 0
#define STRING_TYPE_CHINESE 1
#define STRING_TYPE_CHINESE_GB 2
#define STRING_TYPE_CHINESE_BIG5 3
#define STRING_TYPE_PY 4
#define STRING_TYPE_UNKNOWN 5

#define NOTFOUND_S (const char *)"[ ûз! ]"
#define RULE_ERR_S (const char *)"[ ! ]"

// In HP_UX , MAP_FAILED is not defined. msa add 1999.9.26
#ifndef MAP_FAILED
#define MAP_FAILED    ((void*)-1)
#endif
//=============================================================================
/* 
  MyString is a string class. It doesn't alloce memory itsself to store data.
  It just has a pointer to point the string.That is unlike CString.
  If you use CString instead of MyString,every CString instance will alloce
memory and copy string into itsself,it will very slow when there are a large
number of instances.
  In this programme,the word library file is mapped into memory,and MyString
instances point to the strings stored in the memory block.No need to alloce 
memory and copy strings. 
*/

class ConvertTable
{
private:
        WORD iListCount;
        WORD * List;
public:
        ConvertTable();
        ~ConvertTable();
        bool Init(const char * TabFileName);
        int iConvert(BYTE cHigh,BYTE cLow,WORD &output);
};

class MapTable
{
private:
        FILE * file;
        bool vMap(BYTE ch1,BYTE ch2,WORD &output);
public:
        MapTable();
        ~MapTable();
        bool Init(const char * TabFileName);
        void vMapString(BYTE *sString);
};

class MyString
{
private:
    char *sContent;
    friend int operator==(const MyString &oLItem,const MyString &oRItem);
    friend int operator<(const MyString &oLItem,const MyString &oRItem);
public:
    MyString();
    MyString(char *str);
    char *data() const { return(sContent); }
    int operator==(const char *sString);
    int operator<(const char *sString);
};

//=============================================================================
class WordItem
{
private:
    MyString msWord;
    MyString msMeaning;
    MyString msMark;
    friend int operator==(const WordItem &oLItem,const WordItem &oRItem);
    friend int operator<(const WordItem &oLItem,const WordItem &oRItem);
public:
    WordItem(char *sNewWord,char *sNewMeaning,char *sNewMark);
    int operator==(const char* sItem);
    int operator<(const char* sItem);
    const char *sGetMeaning() const;
    const char *sGetWord() const;
    const char *sGetMark() const;
};

//=============================================================================
int operator==(const WordItem &oLItem,const WordItem &oRItem);
int operator<(const WordItem &oLItem,const WordItem &oRItem);

//=============================================================================
class Lib
{
private:
    // common
    int iVersion;
    char * sDictName;
    int m_iPriority;
    WordItem ** aWordLib;
    unsigned int iLength;   // number of words
    char * pFileMem;        // version 1 => memmap , version 2 => alloced memory
    // version 1        
    long iFileSize;
    // version 2
        
    bool bGetVersion1Lib(const char *sDictionaryFile);
    bool bGetVersion2Lib(const char *sDictionaryFile);
public:
    Lib();
    ~Lib();
    bool bGetLib(const char *sDictionaryFile);// read dictionary file.
    bool bLookup(const char* sWord,int *pIndex,int iSimularDirection,int iStringType);
    bool bLookupWithRule(const MSARegExp& rule,int* aIndex,int iBuffLen);
    class WordItem &GetWordItem(int i);
    inline int length() { return(iLength); }
    unsigned char cIndex,cWord,cMeaning,cMark;  // need change here :-)
    bool bLookupWithMeaning(const char * sWord,int * aiIndexes, int iLen);
    inline const char * sGetDictName(void);
    inline int iGetPriority(void);
};

//============================================================================
class Libs
{
private:
    int m_iTotalLibs;
    Lib ** oLib;
    bool bMakeRule(const char* sWord,char* sRuleString,int iLength);
//    char sLibsMask[MAX_STR_LEN];
    void vLoadDir(const char * path);
    static int compare(const void *p1, const void *p2);
public:
    Libs();
    ~Libs();
    bool bGetWordsWithRule(const char* sWord,int* aiIndexes,int iLen,int iLib,char * sErrorMessage);
    bool bSimpleGetWord(const char* sWord,int& iWordIndex,int iLib,int iSimularDirection,int iStringType);
    const WordItem* poGetWordItem(int iIndex,int iLib);
    const WordItem* poGetNextWordItem(int * iCurrent,BYTE * cType);
    const WordItem* poGetPreWordItem(int * iCurrent,BYTE * cType);
    int iGetLibs(void);
    int iLength(int iLib);
    bool bIsOKForSearch(const int iLib,const int iType,const BYTE cSearch_Type);
    const BYTE cGetLibType(const int iLib,const BYTE cIndex) const;
    bool bGetWordsWithMeaning(const char * sWord,int * aiIndexes, int iLen, int iLib);
    const char * sGetLibName(int iLib);
    int iGetTotalLibs(void);
};

inline unsigned char mytoupper(unsigned char c);
inline bool bIsVowel(char inputchar);
int mystrcmp_ignorecase(const char *s1,const char *s2);

#endif  // OPERA_LIBS_H
