#! /usr/bin/env perl
# /usr/bin/env and /bin/env both exist on solairs, but only /usr/bin/env exists on linux.

# This is the config util for stardic, written by Opera (wangvisual AT sohu.com).
# It read/write/create .stardic in home directory.
use strict;
use IO::File;
use File::Basename;
require Tk or die "ERROR! GUI mode requires Perl/Tk\n";
require Tk::Checkbutton;
require Tk::Radiobutton;

# info mode?
my $showinfo = 0;
while ( $_=$ARGV[0] )
{
    shift;
    last if /^--$/;
    if (/^-i/i) { $showinfo = 1;last }  
}

# get config file name
my $homedir = $ENV{HOME};
die "ERROR! Unable to determine user home directory!\nSetup HOME env first!\n" if not $homedir;
my $filename = "$homedir/.stardic";

# Setting variable's default value
my %setup;
$setup{ScanClipBoard} = 1;
$setup{MinimizeAtStart} = 0;
$setup{UseChineseFT} = 0;
$setup{FloatShowLevel} = 1;
$setup{MaxFuzzyDistance}=3;

my $setupbg = 1;
my $setup_pathentry = "";

my $file;
if ( -e $filename )
{
    $file = new IO::File "$filename", O_RDWR or die "Unable to open $filename ($!)";
    my $line;
    my $name;
    my $value;
    while ( $line = <$file> )
    {
        chomp $line;
        $line =~ s/\ +$//;
        ( $name, $value ) = split "=", $line;
        $setup{$name} = $value;
    }
    #BackgroundPixmapFile=>setupbg
    if (defined $setup{BackgroundPixmapFile})
    {
        $setupbg = ($setup{BackgroundPixmapFile} eq "")?0:2;
        $setup_pathentry = $setup{BackgroundPixmapFile};
    }
    close $file;
}

my $top = new MainWindow;

$SIG{INT} = sub { print STDERR "Catch signal SIGINT, exiting...\n"; &exitconfig };

$top->title( "Config Util for StarDic" );                     #set mainwindow title
$top->resizable( 0, 0 );                                      #lock mainwindow size
$top->protocol( WM_DELETE_WINDOW => \&exitconfig );           #override mainwindow close button
$top->Label( -text => "Config Util for StarDic", -foreground => '#0000ff')->grid( -row => 0, -columnspan =>2, -sticky => 'nswe' );

my $basic_frame =       $top->Frame( -relief      => 'ridge',
                                     -borderwidth => 2
                                   );
my $language_frame =    $top->Frame( -relief      => 'ridge',
                                     -borderwidth => 2
                                   );
my $fuzzy_frame =       $top->Frame( -relief      => 'ridge',
                                     -borderwidth => 2
                                   );
my $floatwin_frame =    $top->Frame( -relief      => 'ridge',
                                     -borderwidth => 2
                                   );
my $dictionary_frame =  $top->Frame( -relief      => 'ridge',
                                     -borderwidth => 2
                                   );
my $bgpic_frame =       $top->Frame( -relief      => 'ridge',
                                     -borderwidth => 2
                                   );
my $button_frame =      $top->Frame( -relief      => 'ridge',
                                     -borderwidth => 2
                                   );

$basic_frame->grid( -row => 1, -column => 0, -sticky => 'nsew' );
$language_frame->grid( -row => 1, -column => 1, -sticky => 'nswe' );
$fuzzy_frame->grid( -row => 2, -column => 0, -columnspan =>2, -sticky => 'nswe' );
$floatwin_frame->grid( -row => 3, -column => 0, -columnspan =>2, -sticky => 'nswe' );
$dictionary_frame->grid( -row => 4, -column => 0, -columnspan =>2, -sticky => 'nswe' );
$bgpic_frame->grid( -row => 5, -column => 0, -columnspan =>2, -sticky => 'nswe' );
$button_frame->grid( -row => 6, -column => 0, -columnspan =>2, -sticky => 'nswe' );

$basic_frame->Label( -text => 'Basic Option', -foreground => '#ff0055' )->grid(-sticky => 'we');
$basic_frame->Checkbutton( -text        => 'Scan Selection',
                           -offvalue    => 0,
                           -onvalue     => 1,
                           -variable    => \$setup{ScanClipBoard}
                         )->grid( -sticky => 'w');
$basic_frame->Checkbutton( -text        => 'Minimize When Startup',
                           -offvalue    => 0,
                           -onvalue     => 1,
                           -variable    => \$setup{MinimizeAtStart}
                         )->grid( -sticky => 'w');

$language_frame->Label( -text => 'Language Option', -foreground => '#ff0055' )->grid(-sticky => 'we');
$language_frame->Radiobutton( -variable => \$setup{UseChineseFT},
                              -text        => "Simplified Chinese",
                              -value       => 0
                            )->grid( -sticky => 'w');
$language_frame->Radiobutton( -variable => \$setup{UseChineseFT},
                              -text        => "Traditional Chinese",
                              -value       => 1
                            )->grid( -sticky => 'w');

$fuzzy_frame->Label( -text => 'Fuzzy find option', -foreground => '#ff0055' )->grid(-row => 0, -column => 0, -columnspan => 3, -sticky => 'we');
$fuzzy_frame->Label( -text => 'Only match words which contain less than ')->grid(-row => 1, -column => 0, -sticky => 'we');
$fuzzy_frame->Entry( -textvariable => \$setup{MaxFuzzyDistance},
                     -width        => 2,
                   )->grid( -row => 1, -column => 1, -sticky => 'w' );
$fuzzy_frame->Label( -text => ' errors.')->grid( -row => 1, -column => 2, -sticky => 'we');

$floatwin_frame->Label( -text => 'Float window showing method', -foreground => '#ff0055' )->grid(-sticky => 'we');
$floatwin_frame->Label( -text => "   Normal Condition\t   Press Alt Key\t   Press Alt+Shift", -foreground => '#550055' )->grid(-sticky => 'w');
my @FloatShowLevel_string;
push @FloatShowLevel_string,     "All dictionay   \tFirst dictionary\tFirst dictionary";
push @FloatShowLevel_string, "First dictionary\tAll dictionay   \tFirst dictionary";
push @FloatShowLevel_string, "Hide            \tAll dictionay   \tFirst dictionary";
push @FloatShowLevel_string, "Hide            \tFirst dictionary\tAll dictionay";
my $count = 0;
foreach my $instance ( @FloatShowLevel_string )
{
    $floatwin_frame->Radiobutton( -variable    => \$setup{FloatShowLevel},
                       -text        => $instance,
                       -value       => $count
                     )->grid( -sticky => 'w' );
                     $count++;
};

$dictionary_frame->Label( -text => 'Set the priority (less first, 0 disable)', -foreground => '#ff0055' )->grid( -columnspan => 2, -sticky => 'we' );
my @Dictionaries_string;
push @Dictionaries_string, "Original stardic English->Chinese dic, 51227 words";
push @Dictionaries_string, "xdict English->Chinese dic, 177849 words";
push @Dictionaries_string, "cdict5 English->Chinese dic, 57540 words with example sentences";
push @Dictionaries_string, "CEDICT Chinese->English dic, 21429 words";
push @Dictionaries_string, "CEDICT Diacritic->Chinese dic, 21429 words";
push @Dictionaries_string, "xdict Chinese->English dic, 161008 words";
push @Dictionaries_string, "Acronyms English->English dic, 138 words";

my @DictName = ( 'trans.dic', 'xdict.dic', 'cdict.dic', 'cedictgb.dic', 'cedictpygb.dic', 'xdict_ce.dic', 'acronyms.dic' );

$count = 0;
foreach my $dic_instance ( @Dictionaries_string)
{
    $setup{$DictName[$count]} = $count*10+10 if ( ! defined $setup{$DictName[$count]} );
    $dictionary_frame->Entry( -textvariable    => \$setup{$DictName[$count]},
                       -width        => 4
                     )->grid( -row => $count+1, -column => 0, -sticky => 'w' );
    $dictionary_frame->Label( -text => $dic_instance)->grid( -row => $count+1, -column => 1, -sticky => 'w' );
    $count++;
};

$bgpic_frame->Label( -text => 'Select the Background picture', -foreground => '#ff0055' )->grid( -columnspan => 3, -sticky => 'we');
$bgpic_frame->Radiobutton( -variable    => \$setupbg,
                           -text        => "None",
                           -command     => \&disablepathentry,
                           -value       => 0
                         )->grid( -column => 0, -sticky => 'w' );
$bgpic_frame->Radiobutton( -variable => \$setupbg,
                           -text        => "Automatic selelect",
                           -command     => \&disablepathentry,
                           -value       => 1
                         )->grid( -column => 0, -sticky => 'w' );
$bgpic_frame->Radiobutton( -variable => \$setupbg,
                           -text        => "Manual selelect",
                           -command     => \&enablepathentry,
                           -value       => 2
                         )->grid( -column => 0, -sticky => 'w' );
                         
my $pathentry = $bgpic_frame->Entry( -textvariable => \$setup_pathentry,
                     -width        => 32,
                     -state => ($setupbg==2)?'normal':'disabled'
                   )->grid( -row => 3, -column => 1, -sticky => 'w' );

my $BGpic_Button = $bgpic_frame->Button( -command     => [ \&getbgfilename ],
                                         -text     => "Browse...",
                                         -state => ($setupbg==2)?'normal':'disabled'
                                       )->grid( -row =>3, -column => 2, -sticky => 'w' );
                                       
$button_frame->Button( -command     => \&save_and_exit,
                       -text     => "OK",
                     )->grid( -row => 0, -column => 0, -sticky => 'w', -padx => 50, -pady => 5 );
$button_frame->Button( -command     => \&exitconfig,
                       -text     => "Cancel",
                     )->grid( -row => 0, -column => 1, -sticky => 'w', -padx => 50, -pady => 5 );

&Tk::MainLoop;

sub save_and_exit
{
    &saveconfig;
    &exitconfig;
}

sub exitconfig
{
    if ($showinfo)
    {
        require Tk::Dialog;
        my $msgbox = $top->Dialog( -title => 'Note',
                                   -text  => "If you want start this util,\ntry \"$0\"",
                                   -buttons => [ 'OK' ]
                                 );
        $msgbox->Show;
    }
    $top->destroy;
    exit;
}

sub disablepathentry
{
    $pathentry->configure( -state => 'disabled' );
    $BGpic_Button->configure( -state => 'disabled' );
}

sub enablepathentry
{
    $pathentry->configure( -state => 'normal' );
    $BGpic_Button->configure( -state => 'normal' );
}

sub saveconfig
{
    #setupbg=>BackgroundPixmapFile
    if ($setupbg==0) # none
    {
        $setup{BackgroundPixmapFile} = '';
    }
    elsif ($setupbg==1)  # auto
    {
        undef $setup{BackgroundPixmapFile};
    }
    else
    {
        $setup{BackgroundPixmapFile} = $setup_pathentry;
    }
    
    if ( -e $filename )
    {
        $file = new IO::File "$filename", O_TRUNC|O_RDWR or die "Unable to truncate $filename ($!)";
    }
    else
    {
        $file = new IO::File "$filename", O_CREAT|O_RDWR or die "Unable to create $filename ($!)";
    }
    foreach my $config_name ( keys %setup)
    {
        print $file "$config_name=$setup{$config_name}     \n" if (defined $setup{$config_name});
    }
    close $file;
}

sub getbgfilename
{
    #$setup_pathentry=>initdir;
    my $basename = "";
    my $dirname ="";
    $dirname = qx/pwd/;
    chomp $dirname;
    if ( $setup_pathentry != "")
    {
        $basename = basename($setup_pathentry);
        $dirname = dirname($setup_pathentry);
    }
    my $filename = $top->getOpenFile( -filetypes        =>
                                           [[ 'Gif Pictures', [ '.gif', '.GIF' ]],
                                            [ 'Xpm Pictures', [ '.xpm', '.XPM' ]],
                                            [ 'All Files',          '*',        ]],
                                      -initialfile      => $basename,
                                      -initialdir       => $dirname,
                                      -title            => 'Select background file...' );
    if ( defined $filename )
    {
        $setup_pathentry = $filename;
    }
}
