#include "nameserver.h"
#include "s2s.h"
#include "debug.h"


void NameServer::resolve(const char *name)
{
	OutPacket out;
	out << name;

	sendPacket(out, NULL, 0);
}

void NameServer::onPacketReceived(const char *data, int n)
{
	InPacket in(data, n);

	ICQ_STR name;
	in >> name;
	uint32 ip = in.read32();

	Server *s = s2s.getServer(name.text);
	if (!s) {
		ICQ_LOG("No server %s\n", name.text);
		return;
	}

	s->onResolved(ip);
}
