#ifndef __LINQ_USERINFO_DLG_H__
#define __LINQ_USERINFO_DLG_H__

#include "LinqWindow.h"
#include "udpsession.h"

#include <gtk/gtk.h>

struct UserInfoDlgWidgets {
friend class UserInfoDlg;

public:
	GtkWidget *window;

private:
	GtkWidget *refresh_button[4];

	GtkWidget *name_entry;
	GtkWidget *nick_entry;
	
	GtkWidget *intro_textview;

	GtkWidget *old_passwd_entry;
	GtkWidget *new_passwd_entry_1, *new_passwd_entry_2;
	GtkWidget *auth_radio_1, *auth_radio_2, *auth_radio_3;

};

class UserInfoDlg : public LinqWindow
{
public:
	UserInfoDlg(const gchar *name);
	~UserInfoDlg();
	void show(CONTACT_INFO &c);
	void show(USER_INFO &user);	

	gboolean onPreChangePasswordReply(uint16 sequence, const char *token);

	UserInfoDlgWidgets *widgets;
	const gchar *getName() { return name.c_str(); }
private:	
	std::string name;
	static GList *get_list_by_str(gchar *str);

	void createWindow(gboolean is_myself);
	void setInfo(CONTACT_INFO &c);
	void setInfo(USER_INFO &user);
	
	void getInfo(USER_INFO &user);

	GtkWidget *createLeftVbox(gboolean is_myself, gint index);
	GtkWidget *createPageBasic(gboolean is_myself);
	GtkWidget *createPageContact(gboolean is_myself);
	GtkWidget *createPageDetail(gboolean is_myself);
	GtkWidget *createPageMyinfo(gboolean is_myself);
		
	static gboolean on_window_deleteevent(GtkWidget * widget, GdkEvent * event, UserInfoDlg *oUserInfoDlg);
	static void on_change_passwd_checkbutton_toggled(GtkToggleButton *button, UserInfoDlg *oUserInfoDlg);
	static void on_change_button_clicked(GtkWidget * widget, UserInfoDlg *oUserInfoDlg);
	static void on_refresh_button_clicked(GtkWidget * widget, UserInfoDlg *oUserInfoDlg);
	static void on_close_button_clicked(GtkWidget * widget, UserInfoDlg *oUserInfoDlg);
};

#endif
