#include "config.h"
#include "UserInfoDlg.h"
#include "LinqMain.h"
#include "intl.h"

#include "string.h"

UserInfoDlg::UserInfoDlg(const gchar *username) : LinqWindow(WIN_VIEW_DETAIL)
{
	widgets = NULL;
	name = username;
}

UserInfoDlg::~UserInfoDlg()
{
	if (widgets) {
		gtk_widget_destroy(widgets->window);
		delete widgets;
	}
}

void UserInfoDlg::show(CONTACT_INFO &c)
{
	if (widgets) {
		setInfo(c);
		gtk_window_present(GTK_WINDOW(widgets->window));
	}
	else {
		createWindow(false);
		setInfo(c);
		gtk_widget_show_all(widgets->window);
	}
}

void UserInfoDlg::show(USER_INFO &user)
{
	if (widgets) {
		setInfo(user);
		gtk_window_present(GTK_WINDOW(widgets->window));
	}
	else {
		createWindow(true);
		setInfo(user);
		gtk_widget_show_all(widgets->window);
	}
}

void UserInfoDlg::createWindow(gboolean is_myself)
{
	widgets = new UserInfoDlgWidgets;
	
	widgets->window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	
	g_signal_connect (G_OBJECT (widgets->window), "delete_event", G_CALLBACK(on_window_deleteevent), this);
	gtk_window_set_resizable (GTK_WINDOW (widgets->window), FALSE);
	if (is_myself)
		gtk_window_set_title (GTK_WINDOW (widgets->window), _("View my information"));
	else
		gtk_window_set_title (GTK_WINDOW (widgets->window), _("View contact's information"));
	gtk_container_set_border_width (GTK_CONTAINER (widgets->window), 5);

	GtkWidget *notebook;
	notebook= gtk_notebook_new();
	gtk_container_add (GTK_CONTAINER (widgets->window), notebook);
	
	GtkWidget *label;	
	label = gtk_label_new (_("Basic information"));
	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), createPageBasic (is_myself), label);

	label = gtk_label_new (_("Contact method"));
	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), createPageContact (is_myself), label);

	label = gtk_label_new (_("Detail information"));
	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), createPageDetail (is_myself), label);

	if (is_myself)
	{
		label = gtk_label_new (_("Network safety"));
		gtk_notebook_append_page (GTK_NOTEBOOK (notebook), createPageMyinfo (is_myself), label);
	}
}

void UserInfoDlg::setInfo(CONTACT_INFO &c)
{
	gtk_widget_set_sensitive(widgets->refresh_button[0],TRUE);
	gtk_widget_set_sensitive(widgets->refresh_button[1],TRUE);
	gtk_widget_set_sensitive(widgets->refresh_button[2],TRUE);

	if (c.name)
		gtk_entry_set_text(GTK_ENTRY(widgets->name_entry), c.name);
	else
		gtk_entry_set_text(GTK_ENTRY(widgets->name_entry), linqMain->myInfo.name.c_str());
	gtk_entry_set_text(GTK_ENTRY(widgets->nick_entry), c.nick);
}

void UserInfoDlg::setInfo(USER_INFO &user)
{
	setInfo((CONTACT_INFO &)user);
	
	gtk_widget_set_sensitive(widgets->refresh_button[3],TRUE);
	
	if (user.auth == AUTH_ACCEPTED)
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widgets->auth_radio_1), true);
	else if (user.auth == AUTH_REQUEST)
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widgets->auth_radio_2), true);
	else // AUTH_REJECTED
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widgets->auth_radio_3), true);
}

GList *UserInfoDlg::get_list_by_str(gchar *str)
{
	GList *cbitems = NULL;
	gchar *a,*b;
	b = str;
	a = strchr(str,'\n');
	while (a)
	{
		*a = '\0';
		cbitems = g_list_append (cbitems, b);
		b = a+1;
		a = strchr(b,'\n');
	}
	cbitems = g_list_append (cbitems, b);
	return cbitems;
}

GtkWidget *UserInfoDlg::createLeftVbox(gboolean is_myself, gint index)
{
	GtkWidget *vbox1;
	GtkWidget *button;
	
	vbox1 = gtk_vbox_new(FALSE, 0);
	button = gtk_button_new_with_label(_("Close"));
	g_signal_connect (G_OBJECT (button), "clicked", G_CALLBACK(on_close_button_clicked), this);
	gtk_box_pack_end(GTK_BOX(vbox1),button,FALSE,FALSE,2);
	button = gtk_button_new_with_label(_("Refresh"));
	widgets->refresh_button[index] = button;
	//g_object_set_data(G_OBJECT(button),"user_data", (gpointer)updateinfo); //used by info_window_refresh().
	g_signal_connect (G_OBJECT (button), "clicked", G_CALLBACK(on_refresh_button_clicked), this);
	gtk_box_pack_end(GTK_BOX(vbox1),button,FALSE,FALSE,0);
	if (is_myself)
	{
		button = gtk_button_new_with_label(_("Change"));
		//g_object_set_data(G_OBJECT(button), "user_data", (gpointer)updateinfo);
		g_signal_connect (G_OBJECT (button), "clicked", G_CALLBACK(on_change_button_clicked), this);
	}
	else
	{
		button = gtk_button_new_with_label(_("Remarks"));
	}
	gtk_box_pack_end(GTK_BOX(vbox1),button,FALSE,FALSE,2);
	return vbox1;
}

GtkWidget *UserInfoDlg::createPageBasic(gboolean is_myself)
{
	GtkWidget *hbox;	
	hbox = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),createLeftVbox(is_myself,0),FALSE,FALSE,3);
	GtkWidget *frame;
	frame = gtk_frame_new(_("Basic information"));
	gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
	gtk_box_pack_start(GTK_BOX(hbox),frame,TRUE,TRUE,0);
	GtkWidget *table;
	table = gtk_table_new(7,4,FALSE);
	gtk_container_set_border_width (GTK_CONTAINER (table), 5);
	gtk_container_add (GTK_CONTAINER (frame), table);
	GtkWidget *label;
	label = gtk_label_new(_("Head icon:"));
	gtk_misc_set_alignment (GTK_MISC (label), 0, .5);
	gtk_table_attach(GTK_TABLE(table),label,0,1,0,1,GTK_FILL, (GtkAttachOptions)(GTK_FILL | GTK_EXPAND),0,0);
	GdkPixbuf *pixbuf;
	pixbuf = linqMain->skin->linq.face[0];
	GtkWidget *pixmap;
	pixmap = gtk_image_new_from_pixbuf(pixbuf);
	if (is_myself)
	{
		GtkWidget *event_box;
		//g_object_set_data(G_OBJECT(updateinfo->face),"user_data",GINT_TO_POINTER((gint)info->face));	
		event_box = gtk_event_box_new();
		/*g_signal_connect (G_OBJECT (event_box), "button_press_event",
			    G_CALLBACK(on_window_change_face), updateinfo);*/
		gtk_container_add(GTK_CONTAINER(event_box),pixmap);
		gtk_table_attach(GTK_TABLE(table),event_box,0,1,1,3,GTK_FILL,(GtkAttachOptions)(GTK_FILL | GTK_EXPAND),0,0);
	}
	else
	{
		gtk_table_attach(GTK_TABLE(table),pixmap,0,1,1,3,GTK_FILL,(GtkAttachOptions)(GTK_FILL | GTK_EXPAND),0,0);
	}
	label = gtk_label_new(_("User name:"));
	gtk_misc_set_alignment (GTK_MISC (label), 1, .5);
	gtk_table_attach(GTK_TABLE(table),label,1,2,1,2,GTK_FILL,(GtkAttachOptions)(GTK_FILL | GTK_EXPAND),0,0);
	label = gtk_label_new(_("User nick:"));
	gtk_misc_set_alignment (GTK_MISC (label), 1, .5);
	gtk_table_attach(GTK_TABLE(table),label,1,2,2,3,GTK_FILL,(GtkAttachOptions)(GTK_FILL | GTK_EXPAND),0,0);
	widgets->name_entry = gtk_entry_new();
	//gtk_entry_set_text(GTK_ENTRY(entry),msg);
	gtk_widget_set_size_request (widgets->name_entry, 120, -1);
	gtk_table_attach(GTK_TABLE(table),widgets->name_entry,2,4,1,2,GTK_FILL,(GtkAttachOptions)(GTK_FILL | GTK_EXPAND),2,0);
	widgets->nick_entry = gtk_entry_new();	
	//gtk_entry_set_text(GTK_ENTRY(entry),str);
	gtk_widget_set_size_request (widgets->nick_entry, 120, -1);
	gtk_table_attach(GTK_TABLE(table),widgets->nick_entry,2,4,2,3,GTK_FILL,(GtkAttachOptions)(GTK_FILL | GTK_EXPAND),2,2);
	label = gtk_label_new(_("Country/Region"));
	gtk_misc_set_alignment (GTK_MISC (label), 0, .5);
	gtk_table_attach(GTK_TABLE(table),label,0,2,3,4,GTK_FILL,(GtkAttachOptions)(GTK_FILL | GTK_EXPAND),2,0);
	label = gtk_label_new(_("Age"));
	gtk_misc_set_alignment (GTK_MISC (label), 0, .5);
	gtk_table_attach(GTK_TABLE(table),label,2,3,3,4,GTK_FILL,(GtkAttachOptions)(GTK_FILL | GTK_EXPAND),2,0);
	label = gtk_label_new(_("Gender"));
	gtk_misc_set_alignment (GTK_MISC (label), 0, .5);
	gtk_table_attach(GTK_TABLE(table),label,3,4,3,4,GTK_FILL,(GtkAttachOptions)(GTK_FILL | GTK_EXPAND),2,0);
	GtkWidget *combo;
	combo = gtk_combo_new();
	gchar *cbitems_str;
	cbitems_str = g_strdup(_("America\nBelgium\nChina\nEngland\nFrance\nGermany\nJapan"));
	GList *cbitems = NULL;
	cbitems = get_list_by_str(cbitems_str);
	gtk_combo_set_popdown_strings (GTK_COMBO (combo), cbitems);
	g_list_free(cbitems);
	cbitems = NULL;
	g_free(cbitems_str);
	//gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry),str);
	gtk_widget_set_size_request (combo, 150, -1);
	gtk_table_attach(GTK_TABLE(table),combo,0,2,4,5,GTK_FILL,(GtkAttachOptions)(GTK_FILL | GTK_EXPAND),2,0);
	GtkWidget *entry;
	entry = gtk_entry_new();
	//gtk_entry_set_text(GTK_ENTRY(entry),msg);
	gtk_widget_set_size_request (entry, 40, -1);
	gtk_table_attach(GTK_TABLE(table),entry,2,3,4,5,GTK_FILL,(GtkAttachOptions)(GTK_FILL | GTK_EXPAND),2,0);
	combo = gtk_combo_new();
	cbitems = g_list_append (NULL, (gpointer)"-");
	cbitems = g_list_append (cbitems, _("Male"));
	cbitems = g_list_append (cbitems, _("Female"));
	gtk_combo_set_popdown_strings (GTK_COMBO (combo), cbitems);
	g_list_free(cbitems);
	cbitems = NULL;
	gtk_widget_set_size_request (combo, 60, -1);
	//gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry),myicq_get_gender_str(info->gender));
	gtk_editable_set_editable(GTK_EDITABLE(GTK_COMBO(combo)->entry),FALSE);
	gtk_table_attach(GTK_TABLE(table),combo,3,4,4,5,GTK_FILL,(GtkAttachOptions)(GTK_FILL | GTK_EXPAND),2,0);
	label = gtk_label_new(_("Province"));
	gtk_misc_set_alignment (GTK_MISC (label), 0, .5);
	gtk_table_attach(GTK_TABLE(table),label,0,2,5,6,GTK_FILL,(GtkAttachOptions)(GTK_FILL | GTK_EXPAND),2,2);
	label = gtk_label_new(_("City"));
	gtk_misc_set_alignment (GTK_MISC (label), 0, .5);
	gtk_table_attach(GTK_TABLE(table),label,2,4,5,6,GTK_FILL,(GtkAttachOptions)(GTK_FILL | GTK_EXPAND),2,2);
	combo = gtk_combo_new();
	cbitems_str = g_strdup(_("province\nlist"));
	cbitems = get_list_by_str(cbitems_str);
	gtk_combo_set_popdown_strings (GTK_COMBO (combo), cbitems);
	g_list_free(cbitems);
	cbitems = NULL;
	g_free(cbitems_str);
	//gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry),str);
	gtk_widget_set_size_request (combo, 150, -1);
	gtk_table_attach(GTK_TABLE(table),combo,0,2,6,7,GTK_FILL,(GtkAttachOptions)(GTK_FILL | GTK_EXPAND),2,0);
	entry = gtk_entry_new();
	gtk_widget_set_size_request (entry, 120, -1);
	//gtk_entry_set_text(GTK_ENTRY(entry),str);
	gtk_table_attach(GTK_TABLE(table),entry,2,4,6,7,GTK_FILL,(GtkAttachOptions)(GTK_FILL | GTK_EXPAND),2,0);
	return hbox;
}

GtkWidget *UserInfoDlg::createPageContact(gboolean is_myself)
{
	GtkWidget *hbox;
	hbox = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),createLeftVbox(is_myself,1),FALSE,FALSE,3);
	GtkWidget *vbox1;
	vbox1 = gtk_vbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),vbox1,TRUE,TRUE,0);
	GtkWidget *frame;
	frame = gtk_frame_new(_("Connection method"));
	gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
	gtk_box_pack_start(GTK_BOX(vbox1),frame,TRUE,TRUE,0);
	GtkWidget *table;
	table = gtk_table_new(2,4,FALSE);
	gtk_container_set_border_width (GTK_CONTAINER (table), 5);
	gtk_container_add (GTK_CONTAINER (frame), table);
	GtkWidget *label;
	label = gtk_label_new(_("Email:"));
	gtk_misc_set_alignment (GTK_MISC (label), 0, .5);
	gtk_table_attach(GTK_TABLE(table),label,0,1,0,1,GTK_FILL,(GtkAttachOptions)(GTK_FILL | GTK_EXPAND),0,0);
	label = gtk_label_new(_("Address:"));
	gtk_misc_set_alignment (GTK_MISC (label), 0, .5);
	gtk_table_attach(GTK_TABLE(table),label,0,1,1,2,GTK_FILL,(GtkAttachOptions)(GTK_FILL | GTK_EXPAND),0,0);
	label = gtk_label_new(_("Zip Code:"));
	gtk_misc_set_alignment (GTK_MISC (label), 0, .5);
	gtk_table_attach(GTK_TABLE(table),label,0,1,2,3,GTK_FILL,(GtkAttachOptions)(GTK_FILL | GTK_EXPAND),0,0);
	label = gtk_label_new(_("Telphone:"));
	gtk_misc_set_alignment (GTK_MISC (label), 0, .5);
	gtk_table_attach(GTK_TABLE(table),label,0,1,3,4,GTK_FILL,(GtkAttachOptions)(GTK_FILL | GTK_EXPAND),0,0);

	GtkWidget *entry;
	entry = gtk_entry_new();
	//gtk_entry_set_text(GTK_ENTRY(entry),str);
	gtk_table_attach(GTK_TABLE(table),entry,1,2,0,1,GTK_FILL,(GtkAttachOptions)(GTK_FILL | GTK_EXPAND),0,0);
	entry = gtk_entry_new();
	//gtk_entry_set_text(GTK_ENTRY(entry),str);
	gtk_table_attach(GTK_TABLE(table),entry,1,2,1,2,GTK_FILL,(GtkAttachOptions)(GTK_FILL | GTK_EXPAND),0,2);
	entry = gtk_entry_new();
	//gtk_entry_set_text(GTK_ENTRY(entry),str);
	gtk_table_attach(GTK_TABLE(table),entry,1,2,2,3,(GtkAttachOptions)(GTK_FILL | GTK_EXPAND),(GtkAttachOptions)(GTK_FILL | GTK_EXPAND),0,0);
	entry = gtk_entry_new();
	//gtk_entry_set_text(GTK_ENTRY(entry),str);
	gtk_table_attach(GTK_TABLE(table),entry,1,2,3,4,(GtkAttachOptions)(GTK_FILL | GTK_EXPAND),(GtkAttachOptions)(GTK_FILL | GTK_EXPAND),0,2);

	frame = gtk_frame_new(_("These information"));
	gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
	gtk_widget_set_sensitive(frame,FALSE);
	gtk_box_pack_start(GTK_BOX(vbox1),frame,FALSE,FALSE,0);
	
	GtkWidget *hbox1;
	hbox1 = gtk_hbox_new(FALSE,5);
	gtk_container_add (GTK_CONTAINER (frame), hbox1);
	GtkWidget *radio;
	radio = gtk_radio_button_new_with_label(NULL,_("complete open"));
	gtk_box_pack_start(GTK_BOX(hbox1),radio,FALSE,FALSE,0);
	radio = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON(radio),_("only friends can see"));
	gtk_box_pack_start(GTK_BOX(hbox1),radio,FALSE,FALSE,0);
	radio = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON(radio),_("complte close"));
	gtk_box_pack_start(GTK_BOX(hbox1),radio,FALSE,FALSE,0);	

	return hbox;
}

GtkWidget *UserInfoDlg::createPageDetail(gboolean is_myself)
{
	GtkWidget *hbox;
	hbox = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),createLeftVbox(is_myself,2),FALSE,FALSE,3);
	GtkWidget *frame;
	frame = gtk_frame_new(_("Detail information"));
	gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
	gtk_box_pack_start(GTK_BOX(hbox),frame,TRUE,TRUE,0);
	GtkWidget *table;
	table = gtk_table_new(8,2,FALSE);
	gtk_container_set_border_width (GTK_CONTAINER (table), 5);
	gtk_container_add (GTK_CONTAINER (frame), table);
	GtkWidget *label;
	label = gtk_label_new(_("Real name"));
	gtk_misc_set_alignment (GTK_MISC (label), 0, .5);
	gtk_table_attach(GTK_TABLE(table),label,0,1,0,1,GTK_FILL,(GtkAttachOptions)(GTK_FILL | GTK_EXPAND),2,2);
	label = gtk_label_new(_("Blood type"));
	gtk_misc_set_alignment (GTK_MISC (label), 0, .5);
	gtk_table_attach(GTK_TABLE(table),label,1,2,0,1,GTK_FILL,(GtkAttachOptions)(GTK_FILL | GTK_EXPAND),2,2);
	label = gtk_label_new(_("College"));
	gtk_misc_set_alignment (GTK_MISC (label), 0, .5);
	gtk_table_attach(GTK_TABLE(table),label,0,1,2,3,GTK_FILL,(GtkAttachOptions)(GTK_FILL | GTK_EXPAND),2,2);
	label = gtk_label_new(_("Occupation"));
	gtk_misc_set_alignment (GTK_MISC (label), 0, .5);
	gtk_table_attach(GTK_TABLE(table),label,1,2,2,3,GTK_FILL,(GtkAttachOptions)(GTK_FILL | GTK_EXPAND),2,2);
	label = gtk_label_new(_("Home page:"));
	gtk_misc_set_alignment (GTK_MISC (label), 0, .5);
	gtk_table_attach(GTK_TABLE(table),label,0,2,4,5,GTK_FILL,(GtkAttachOptions)(GTK_FILL | GTK_EXPAND),2,2);
	label = gtk_label_new(_("Self-Introduce:"));
	gtk_misc_set_alignment (GTK_MISC (label), 0, .5);
	gtk_table_attach(GTK_TABLE(table),label,0,2,6,7,GTK_FILL,(GtkAttachOptions)(GTK_FILL | GTK_EXPAND),2,2);

	GtkWidget *entry;
	entry = gtk_entry_new();
	//gtk_entry_set_text(GTK_ENTRY(entry),str);
	gtk_table_attach(GTK_TABLE(table),entry,0,1,1,2,GTK_FILL,(GtkAttachOptions)(GTK_FILL | GTK_EXPAND),2,0);
	entry = gtk_entry_new();
	//gtk_entry_set_text(GTK_ENTRY(entry),str);
	gtk_table_attach(GTK_TABLE(table),entry,0,1,3,4,GTK_FILL,(GtkAttachOptions)(GTK_FILL | GTK_EXPAND),2,2);
	entry = gtk_entry_new();
	//gtk_entry_set_text(GTK_ENTRY(entry),str);
	gtk_table_attach(GTK_TABLE(table),entry,0,2,5,6,GTK_FILL,(GtkAttachOptions)(GTK_FILL | GTK_EXPAND),2,0);

	GtkWidget *combo;
	combo = gtk_combo_new();
	GList *cbitems = NULL;
	cbitems = g_list_append (cbitems, (gpointer)"-");
	cbitems = g_list_append (cbitems, (gpointer)"A");
	cbitems = g_list_append (cbitems, (gpointer)"B");
	cbitems = g_list_append (cbitems, (gpointer)"O");
	cbitems = g_list_append (cbitems, (gpointer)"AB");
	cbitems = g_list_append (cbitems, _("Else"));
	gtk_combo_set_popdown_strings (GTK_COMBO (combo), cbitems);
	g_list_free(cbitems);
	//gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry),myicq_get_blood_str(info->blood));
	gtk_widget_set_size_request (combo, 90, -1);
	gtk_editable_set_editable(GTK_EDITABLE(GTK_COMBO(combo)->entry),FALSE);
	gtk_table_attach(GTK_TABLE(table),combo,1,2,1,2,GTK_FILL,(GtkAttachOptions)(GTK_FILL | GTK_EXPAND),2,0);
	combo = gtk_combo_new();
	gchar *cbitems_str;
	cbitems_str = g_strdup(_("occupation\nlist"));
	cbitems = get_list_by_str(cbitems_str);
	gtk_combo_set_popdown_strings (GTK_COMBO (combo), cbitems);
	g_list_free(cbitems);
	cbitems = NULL;
	g_free(cbitems_str);
	//gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry),str);
	gtk_widget_set_size_request (combo, 90, -1);
	gtk_table_attach(GTK_TABLE(table),combo,1,2,3,4,GTK_FILL,(GtkAttachOptions)(GTK_FILL | GTK_EXPAND),2,0);
	
	widgets->intro_textview = gtk_text_view_new();
	gtk_widget_set_size_request (widgets->intro_textview, -1, 50);
	//gtk_text_buffer_set_text(gtk_text_view_get_buffer(GTK_TEXT_VIEW(text)),str,-1);

	GtkWidget *scrolled_window;
	scrolled_window = gtk_scrolled_window_new(NULL,NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
					GTK_POLICY_AUTOMATIC,
					GTK_POLICY_AUTOMATIC);
	gtk_container_add(GTK_CONTAINER(scrolled_window),widgets->intro_textview);
	gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (scrolled_window), GTK_SHADOW_IN);
	gtk_text_view_set_left_margin (GTK_TEXT_VIEW (widgets->intro_textview), 2);
	gtk_text_view_set_right_margin (GTK_TEXT_VIEW (widgets->intro_textview), 2);
	
	gtk_table_attach(GTK_TABLE(table),scrolled_window,0,2,7,8,GTK_FILL,(GtkAttachOptions)(GTK_FILL | GTK_EXPAND),2,0);
	return hbox;
}

void UserInfoDlg::on_change_passwd_checkbutton_toggled(GtkToggleButton *button, UserInfoDlg *oUserInfoDlg)
{
	if (gtk_toggle_button_get_active (button))
	{
		gtk_widget_set_sensitive(oUserInfoDlg->widgets->old_passwd_entry,TRUE);
		gtk_widget_set_sensitive(oUserInfoDlg->widgets->new_passwd_entry_1,TRUE);
		gtk_widget_set_sensitive(oUserInfoDlg->widgets->new_passwd_entry_2,TRUE);
	}
	else
	{
		gtk_widget_set_sensitive(oUserInfoDlg->widgets->old_passwd_entry,FALSE);
		gtk_widget_set_sensitive(oUserInfoDlg->widgets->new_passwd_entry_1,FALSE);
		gtk_widget_set_sensitive(oUserInfoDlg->widgets->new_passwd_entry_2,FALSE);
	}
}

GtkWidget *UserInfoDlg::createPageMyinfo(gboolean is_myself)
{
	GtkWidget *hbox;
	hbox = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),createLeftVbox(is_myself,3),FALSE,FALSE,3);
	GtkWidget *vbox1;
	vbox1 = gtk_vbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),vbox1,TRUE,TRUE,0);
	GtkWidget *check_button;
	check_button = gtk_check_button_new_with_label(_("i want to make my personal detail information securately"));
	gtk_box_pack_start(GTK_BOX(vbox1),check_button,FALSE,FALSE,5);
	gtk_widget_set_sensitive(check_button,FALSE);
	GtkWidget *frame;
	frame = gtk_frame_new(_("Change password"));
	gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
	gtk_box_pack_start(GTK_BOX(vbox1),frame,FALSE,FALSE,0);
	GtkWidget *table;
	table = gtk_table_new(2,4,FALSE);
	gtk_container_set_border_width (GTK_CONTAINER (table), 5);
	gtk_container_add (GTK_CONTAINER (frame), table);
	GtkWidget *label;
	label = gtk_label_new(_("Old password:"));
	gtk_misc_set_alignment (GTK_MISC (label), 0, .5);
	gtk_table_attach(GTK_TABLE(table),label,1,2,0,1,GTK_FILL,(GtkAttachOptions)(GTK_FILL | GTK_EXPAND),2,2);
	label = gtk_label_new(_("New password:"));
	gtk_misc_set_alignment (GTK_MISC (label), 0, .5);
	gtk_table_attach(GTK_TABLE(table),label,0,1,2,3,GTK_FILL,(GtkAttachOptions)(GTK_FILL | GTK_EXPAND),2,2);
	label = gtk_label_new(_("Password confirm:"));
	gtk_misc_set_alignment (GTK_MISC (label), 0, .5);
	gtk_table_attach(GTK_TABLE(table),label,1,2,2,3,GTK_FILL,(GtkAttachOptions)(GTK_FILL | GTK_EXPAND),2,2);

	check_button = gtk_check_button_new_with_label(_("Change password"));
	g_signal_connect (G_OBJECT (check_button), "toggled", G_CALLBACK (on_change_passwd_checkbutton_toggled), this);   			   
	gtk_table_attach(GTK_TABLE(table),check_button,0,1,1,2,GTK_FILL,(GtkAttachOptions)(GTK_FILL | GTK_EXPAND),2,0);

	widgets->old_passwd_entry = gtk_entry_new();
	gtk_entry_set_visibility(GTK_ENTRY(widgets->old_passwd_entry),FALSE);
	gtk_widget_set_sensitive(widgets->old_passwd_entry,FALSE);
	gtk_widget_set_size_request (widgets->old_passwd_entry, 120, -1);
	gtk_table_attach(GTK_TABLE(table),widgets->old_passwd_entry,1,2,1,2,GTK_FILL,(GtkAttachOptions)(GTK_FILL | GTK_EXPAND),2,0);
	widgets->new_passwd_entry_1 = gtk_entry_new();
	gtk_entry_set_visibility(GTK_ENTRY(widgets->new_passwd_entry_1),FALSE);
	gtk_widget_set_sensitive(widgets->new_passwd_entry_1,FALSE);
	gtk_widget_set_size_request (widgets->new_passwd_entry_1, 120, -1);
	gtk_table_attach(GTK_TABLE(table),widgets->new_passwd_entry_1,0,1,3,4,GTK_FILL,(GtkAttachOptions)(GTK_FILL | GTK_EXPAND),2,2);
	widgets->new_passwd_entry_2 = gtk_entry_new();
	gtk_entry_set_visibility(GTK_ENTRY(widgets->new_passwd_entry_2),FALSE);
	gtk_widget_set_sensitive(widgets->new_passwd_entry_2,FALSE);
	gtk_widget_set_size_request (widgets->new_passwd_entry_2, 120, -1);
	gtk_table_attach(GTK_TABLE(table),widgets->new_passwd_entry_2,1,2,3,4,GTK_FILL,(GtkAttachOptions)(GTK_FILL | GTK_EXPAND),2,0);

	frame = gtk_frame_new(_("Authorization"));
	gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
	gtk_box_pack_start(GTK_BOX(vbox1),frame,FALSE,FALSE,0);
	
	GtkWidget *vbox2;
	vbox2 = gtk_vbox_new(FALSE,1);
	gtk_container_add (GTK_CONTAINER (frame), vbox2);
	widgets->auth_radio_1 = gtk_radio_button_new_with_label(NULL,_("anyone can add me to their contact lists"));
	gtk_box_pack_start(GTK_BOX(vbox2),widgets->auth_radio_1,FALSE,FALSE,0);
	widgets->auth_radio_2 = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON(widgets->auth_radio_1),_("authorization is required"));
	/*if (info->auth == 1)
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radio),TRUE);*/
	gtk_box_pack_start(GTK_BOX(vbox2),widgets->auth_radio_2,FALSE,FALSE,0);
	widgets->auth_radio_3 = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON(widgets->auth_radio_2),_("none can add me to their contact lists"));
	/*if (info->auth == 2)
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radio),TRUE);*/
	gtk_box_pack_start(GTK_BOX(vbox2),widgets->auth_radio_3,FALSE,FALSE,0);	

	return hbox;
}

gboolean UserInfoDlg::on_window_deleteevent(GtkWidget * widget, GdkEvent * event, UserInfoDlg *oUserInfoDlg)
{
	delete oUserInfoDlg;
	return true;
}

void UserInfoDlg::getInfo(USER_INFO &user)
{
	//user.name  //needn't set.
	user.nick = gtk_entry_get_text(GTK_ENTRY(widgets->nick_entry));

	GtkTextIter start, end;
	gtk_text_buffer_get_bounds(gtk_text_view_get_buffer(GTK_TEXT_VIEW(widgets->intro_textview)),&start,&end);
	user.intro = gtk_text_buffer_get_text(gtk_text_view_get_buffer(GTK_TEXT_VIEW(widgets->intro_textview)),&start,&end,FALSE);
}

void UserInfoDlg::on_change_button_clicked(GtkWidget * widget, UserInfoDlg *oUserInfoDlg)
{
	USER_INFO info;
	oUserInfoDlg->getInfo(info);
	linqMain->getUDPSession()->updateUserInfo(info);
	g_free((gchar *)(info.intro));
	
	delete oUserInfoDlg;
}

void UserInfoDlg::on_refresh_button_clicked(GtkWidget * widget, UserInfoDlg *oUserInfoDlg)
{
	if (g_ascii_strcasecmp(oUserInfoDlg->name.c_str(), linqMain->myInfo.name.c_str())) {
		linqMain->getUDPSession()->getContactInfo(oUserInfoDlg->name.c_str());
	}
	else {
		linqMain->getUDPSession()->getUserInfo();
		gtk_widget_set_sensitive(oUserInfoDlg->widgets->refresh_button[3], FALSE);
	}

	gtk_widget_set_sensitive(oUserInfoDlg->widgets->refresh_button[0], FALSE);
	gtk_widget_set_sensitive(oUserInfoDlg->widgets->refresh_button[1], FALSE);
	gtk_widget_set_sensitive(oUserInfoDlg->widgets->refresh_button[2], FALSE);	
}

void UserInfoDlg::on_close_button_clicked(GtkWidget * widget, UserInfoDlg *oUserInfoDlg)
{
	delete oUserInfoDlg;
}

gboolean UserInfoDlg::onPreChangePasswordReply(uint16 sequence, const char *token)
{
	return false;
}
