#include "config.h"
#include "RegWizard.h"
#include "LinqMain.h"
#include "LinqUsers.h"
#include "sha.h"
#include "intl.h"

#include <sys/stat.h>

#ifdef G_OS_WIN32
#include <dir.h>  // for mkdir()
#endif

RegWizard::RegWizard() : LinqWindow(WIN_REG_WIZARD)
{
	window = NULL;
	waiting_preLogin = false;
	UserInfo_received = false;
	ContactList_received = false;
}

RegWizard::~RegWizard()
{
	if (window)
		gtk_widget_destroy(window);
}

void RegWizard::Show(const gchar *user, const gchar *passwd)
{
	if (window) {
		gtk_window_present(GTK_WINDOW(window));
		return;
	}
	
	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_container_set_border_width(GTK_CONTAINER(window),2);
	gtk_window_set_default_size (GTK_WINDOW(window), 200, 160);
	gtk_window_set_title(GTK_WINDOW(window),_("LinQ Register wizard"));
	gtk_window_set_icon(GTK_WINDOW (window), linqMain->skin->linq.icon);
	gtk_window_set_position (GTK_WINDOW (window), GTK_WIN_POS_CENTER);
	g_signal_connect (G_OBJECT (window), "delete_event", G_CALLBACK (on_delete_event), this);
	
	GtkWidget *vbox;
	vbox = gtk_vbox_new(false,0);
	gtk_container_add (GTK_CONTAINER (window), vbox);
	
	notebook = gtk_notebook_new();
	gtk_notebook_set_show_tabs(GTK_NOTEBOOK(notebook),FALSE);
	gtk_notebook_set_show_border(GTK_NOTEBOOK(notebook),FALSE);
	create_nb_choose(user, passwd);
	create_nb_basic_info();
	create_nb_contact_info();
	create_nb_detail_info();
	create_nb_network_info();
	create_nb_register_result();
	
	gtk_box_pack_start(GTK_BOX(vbox), notebook,false,false,10);
	GtkWidget *separator = gtk_hseparator_new ();
	gtk_box_pack_start (GTK_BOX (vbox), separator, FALSE, TRUE, 10);
					
	GtkWidget *hbox;
	hbox = gtk_hbox_new(FALSE,10);
	gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, TRUE, 10);
	back_button = gtk_button_new_with_label(_("< Back"));
	gtk_widget_set_sensitive(back_button,false);
	gtk_box_pack_start(GTK_BOX(hbox),back_button,false,false,0);
	g_signal_connect (G_OBJECT (back_button), "clicked", G_CALLBACK(on_back_clicked), this);

	next_button = gtk_button_new_with_label(_("Next >"));
	gtk_box_pack_start(GTK_BOX(hbox),next_button,false,false,0);
	g_signal_connect (G_OBJECT (next_button), "clicked", G_CALLBACK(on_next_clicked), this);

	cancel_button = gtk_button_new_with_label(_("Cancel"));
	gtk_box_pack_start(GTK_BOX(hbox),cancel_button,false,false,0);
	g_signal_connect (G_OBJECT (cancel_button), "clicked", G_CALLBACK(on_cancel_clicked), this);
	
	gtk_notebook_set_current_page (GTK_NOTEBOOK (notebook), NB_CHOOSE);
	nb_current_page = NB_CHOOSE;
	
	gtk_widget_show_all(window);
}

void RegWizard::on_nb_choose_exist_user_radio_toggled(GtkToggleButton *button, RegWizard *oRegWizard)
{
	gboolean sentive = gtk_toggle_button_get_active(button);
	gtk_widget_set_sensitive(oRegWizard->nb_choose_exist_user_table, sentive);
	if (sentive)
		gtk_widget_grab_focus(oRegWizard->nb_choose_user_entry);
}

void RegWizard::on_nb_choose_user_entry_activate(GtkEntry *entry, RegWizard *oRegWizard)
{
	gtk_widget_grab_focus(oRegWizard->nb_choose_password_entry);
}

void RegWizard::on_nb_choose_password_entry_activate(GtkEntry *entry, RegWizard *oRegWizard)
{
	oRegWizard->on_next_clicked(oRegWizard->next_button, oRegWizard);
}

void RegWizard::create_nb_choose(const gchar *user, const gchar *passwd)
{
	GtkWidget *frame;
	frame = gtk_frame_new("Register user");
	GtkWidget *vbox;
	vbox = gtk_vbox_new(false,0);
	gtk_container_add(GTK_CONTAINER(frame),vbox);		
	nb_choose_new_user_radio = gtk_radio_button_new_with_label(NULL,_("Regster new LinQ user"));	
	gtk_box_pack_start(GTK_BOX(vbox),nb_choose_new_user_radio,FALSE,FALSE,0);
	GtkWidget *separator = gtk_hseparator_new ();
	gtk_box_pack_start (GTK_BOX (vbox), separator, FALSE, TRUE, 10);
	GtkWidget *radio;
	radio = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON (nb_choose_new_user_radio),_("Use Exist LinQ user"));
	g_signal_connect(G_OBJECT(radio),"toggled", G_CALLBACK(on_nb_choose_exist_user_radio_toggled), this);
	gtk_box_pack_start(GTK_BOX(vbox),radio,FALSE,FALSE,0);
	nb_choose_exist_user_table = gtk_table_new(2,2, false);
	gtk_widget_set_sensitive(nb_choose_exist_user_table, false);
	gtk_box_pack_start(GTK_BOX(vbox),nb_choose_exist_user_table,FALSE,FALSE,0);
	GtkWidget *label;
	label = gtk_label_new("User name:");
	gtk_table_attach_defaults(GTK_TABLE(nb_choose_exist_user_table), label, 0, 1, 0, 1);	
	nb_choose_user_entry = gtk_entry_new();
	g_signal_connect (G_OBJECT (nb_choose_user_entry), "activate", G_CALLBACK (on_nb_choose_user_entry_activate), this);
	gtk_table_attach_defaults(GTK_TABLE(nb_choose_exist_user_table), nb_choose_user_entry, 1, 2, 0, 1);
	label = gtk_label_new("Password:");
	gtk_table_attach_defaults(GTK_TABLE(nb_choose_exist_user_table), label, 0, 1, 1, 2);	
	nb_choose_password_entry = gtk_entry_new();
	g_signal_connect (G_OBJECT (nb_choose_password_entry), "activate", G_CALLBACK (on_nb_choose_password_entry_activate), this);
	gtk_entry_set_visibility(GTK_ENTRY(nb_choose_password_entry), false);
	gtk_table_attach_defaults(GTK_TABLE(nb_choose_exist_user_table), nb_choose_password_entry, 1, 2, 1, 2);
	
	if (user) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radio), true);
		gtk_entry_set_text(GTK_ENTRY(nb_choose_user_entry), user);
		if (passwd)
			gtk_entry_set_text(GTK_ENTRY(nb_choose_password_entry), passwd);
	}
	
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook),frame,NULL);
}

void RegWizard::create_nb_basic_info()
{
	GtkWidget *vbox;
	vbox = gtk_vbox_new(false,0);
	GtkWidget *frame;
	frame = gtk_frame_new(_("Account"));	
	gtk_box_pack_start(GTK_BOX(vbox),frame,false,false,0);
	GtkWidget *table;
	table = gtk_table_new(3,2,false);
	gtk_container_add(GTK_CONTAINER(frame),table);
	GtkWidget *label;
	label = gtk_label_new("Account:");
	gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 0, 1);
	nb_basic_account_entry = gtk_entry_new();
	gtk_table_attach_defaults(GTK_TABLE(table), nb_basic_account_entry, 1, 2, 0, 1);
	label = gtk_label_new("Password:");
	gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 1, 2);
	nb_basic_passwd_1_entry = gtk_entry_new();
	gtk_entry_set_visibility(GTK_ENTRY(nb_basic_passwd_1_entry), false);
	gtk_table_attach_defaults(GTK_TABLE(table), nb_basic_passwd_1_entry, 1, 2, 1, 2);
	label = gtk_label_new("Password(again):");
	gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 2, 3);
	nb_basic_passwd_2_entry = gtk_entry_new();
	gtk_entry_set_visibility(GTK_ENTRY(nb_basic_passwd_2_entry), false);
	gtk_table_attach_defaults(GTK_TABLE(table), nb_basic_passwd_2_entry, 1, 2, 2, 3);

	frame = gtk_frame_new(_("Basic information"));
	gtk_box_pack_start(GTK_BOX(vbox),frame,false,false,0);
	table = gtk_table_new(5, 2, false);
	gtk_container_add(GTK_CONTAINER(frame), table);
	label = gtk_label_new("Nick name");
	gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 0, 1);
	nb_basic_nickname_entry = gtk_entry_new();
	gtk_table_attach_defaults(GTK_TABLE(table), nb_basic_nickname_entry, 1, 2, 0, 1);
	label = gtk_label_new("Gender");
	gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 1, 2);	
	nb_basic_gender_optionmenu = gtk_option_menu_new();
	GtkWidget *menu = gtk_menu_new();
	GtkWidget *menuitem;	
	menuitem = gtk_menu_item_new_with_mnemonic(_("_Unspecified"));
	gtk_menu_shell_append(GTK_MENU_SHELL(menu), menuitem);
	menuitem = gtk_menu_item_new_with_mnemonic(_("_Male"));
	gtk_menu_shell_append(GTK_MENU_SHELL(menu), menuitem);
	menuitem = gtk_menu_item_new_with_mnemonic(_("_Female"));
	gtk_menu_shell_append(GTK_MENU_SHELL(menu), menuitem);
	gtk_option_menu_set_menu(GTK_OPTION_MENU(nb_basic_gender_optionmenu), menu);
	gtk_table_attach_defaults(GTK_TABLE(table), nb_basic_gender_optionmenu, 1, 2, 1, 2);
	label = gtk_label_new("Birth");
	gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 2, 3);
	GtkWidget *hbox;
	hbox = gtk_hbox_new(false, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), hbox, 1, 2, 2, 3);
	nb_basic_birth_year_entry = gtk_entry_new();
	gtk_entry_set_width_chars(GTK_ENTRY(nb_basic_birth_year_entry), 4);
	gtk_box_pack_start(GTK_BOX(hbox),nb_basic_birth_year_entry,false,false,0);
	nb_basic_birth_month_entry = gtk_entry_new();
	gtk_entry_set_width_chars(GTK_ENTRY(nb_basic_birth_month_entry), 2);
	gtk_box_pack_start(GTK_BOX(hbox),nb_basic_birth_month_entry,false,false,0);
	nb_basic_birth_date_entry = gtk_entry_new();
	gtk_entry_set_width_chars(GTK_ENTRY(nb_basic_birth_date_entry), 2);
	gtk_box_pack_start(GTK_BOX(hbox),nb_basic_birth_date_entry,false,false,0);	
	label = gtk_label_new("Country");
	gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 3, 4);
	nb_basic_country_entry = gtk_entry_new();
	gtk_table_attach_defaults(GTK_TABLE(table), nb_basic_country_entry, 1, 2, 3, 4);
	label = gtk_label_new("City");
	gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 4, 5);
	nb_basic_city_entry = gtk_entry_new();
	gtk_table_attach_defaults(GTK_TABLE(table), nb_basic_city_entry, 1, 2, 4, 5);
		
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook),vbox,NULL);
}

void RegWizard::create_nb_contact_info()
{
	GtkWidget *vbox;
	vbox = gtk_vbox_new(false,0);
	GtkWidget *frame;
	frame = gtk_frame_new(_("Connection method"));
	gtk_box_pack_start(GTK_BOX(vbox),frame,false,false,0);

	GtkWidget *table;
	table = gtk_table_new(5, 2, false);
	gtk_container_add(GTK_CONTAINER(frame), table);
	
	GtkWidget *label;
	label = gtk_label_new(_("Email"));
	gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 0, 1);
	nb_contact_email_entry = gtk_entry_new();
	gtk_table_attach_defaults(GTK_TABLE(table), nb_contact_email_entry, 1, 2, 0, 1);
	label = gtk_label_new(_("Address"));
	gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 1, 2);
	nb_contact_address_entry = gtk_entry_new();
	gtk_table_attach_defaults(GTK_TABLE(table), nb_contact_address_entry, 1, 2, 1, 2);
	label = gtk_label_new(_("Post code"));
	gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 2, 3);
	nb_contact_postcode_entry = gtk_entry_new();
	gtk_table_attach_defaults(GTK_TABLE(table), nb_contact_postcode_entry, 1, 2, 2, 3);
	label = gtk_label_new(_("Telephone"));
	gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 3, 4);
	nb_contact_tel_entry = gtk_entry_new();
	gtk_table_attach_defaults(GTK_TABLE(table), nb_contact_tel_entry, 1, 2, 3, 4);
	label = gtk_label_new(_("Mobile"));
	gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 4, 5);
	nb_contact_mobile_entry = gtk_entry_new();
	gtk_table_attach_defaults(GTK_TABLE(table), nb_contact_mobile_entry, 1, 2, 4, 5);
		
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook),vbox,NULL);
}

void RegWizard::create_nb_detail_info()
{
	GtkWidget *frame;
	frame = gtk_frame_new(_("Detail information"));
	
	GtkWidget *vbox;
	vbox = gtk_vbox_new(false, 0);
	gtk_container_add(GTK_CONTAINER(frame), vbox);
	
	GtkWidget *table;
	table = gtk_table_new(2, 2, false);
	gtk_box_pack_start(GTK_BOX(vbox),table,false,false,0);
	GtkWidget *label;
	label = gtk_label_new(_("Real name"));
	gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 0, 1);
	nb_detail_realname_entry = gtk_entry_new();
	gtk_table_attach_defaults(GTK_TABLE(table), nb_detail_realname_entry, 0, 1, 1, 2);
	label = gtk_label_new(_("Occupation"));
	gtk_table_attach_defaults(GTK_TABLE(table), label, 1, 2, 0, 1);
	nb_detail_occupation_combo = gtk_combo_new();
	gtk_table_attach_defaults(GTK_TABLE(table), nb_detail_occupation_combo, 1, 2, 1, 2);
	
	label = gtk_label_new("Home page:");
	gtk_box_pack_start(GTK_BOX(vbox), label, false,false,0);
	nb_detail_homepage_entry = gtk_entry_new();
	gtk_box_pack_start(GTK_BOX(vbox), nb_detail_homepage_entry, false,false,0);

	label = gtk_label_new("Introduce:");
	gtk_box_pack_start(GTK_BOX(vbox), label, false,false,0);

	nb_detail_intro_textview = gtk_text_view_new();
	gtk_widget_set_size_request (nb_detail_intro_textview, -1, 50);

	GtkWidget *scrolled_window;
	scrolled_window = gtk_scrolled_window_new(NULL,NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
					GTK_POLICY_AUTOMATIC,
					GTK_POLICY_AUTOMATIC);
	gtk_container_add(GTK_CONTAINER(scrolled_window),nb_detail_intro_textview);
	gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (scrolled_window), GTK_SHADOW_IN);
	gtk_text_view_set_left_margin (GTK_TEXT_VIEW (nb_detail_intro_textview), 2);
	gtk_text_view_set_right_margin (GTK_TEXT_VIEW (nb_detail_intro_textview), 2);
	
	gtk_box_pack_start(GTK_BOX(vbox), scrolled_window, false,false,0);
	
	GtkWidget *frame1;
	frame1 = gtk_frame_new(_("Authorization"));
	gtk_container_set_border_width (GTK_CONTAINER (frame1), 5);
	gtk_box_pack_start(GTK_BOX(vbox),frame1,FALSE,FALSE,0);
	
	GtkWidget *vbox2;
	vbox2 = gtk_vbox_new(FALSE,1);
	gtk_container_add (GTK_CONTAINER (frame1), vbox2);
	nb_detail_auth_radio_1 = gtk_radio_button_new_with_label(NULL,_("anyone can add me to their contact lists"));
	gtk_box_pack_start(GTK_BOX(vbox2),nb_detail_auth_radio_1,FALSE,FALSE,0);
	nb_detail_auth_radio_2 = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON(nb_detail_auth_radio_1),_("authorization is required"));
	gtk_box_pack_start(GTK_BOX(vbox2),nb_detail_auth_radio_2,FALSE,FALSE,0);
	GtkWidget *radio;
	radio = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON(nb_detail_auth_radio_2),_("none can add me to their contact lists"));
	gtk_box_pack_start(GTK_BOX(vbox2), radio,FALSE,FALSE,0);	

	gtk_notebook_append_page(GTK_NOTEBOOK(notebook),frame,NULL);
}

void RegWizard::on_nb_network_proxy_type_optionmenu_changed(GtkOptionMenu *option_menu, RegWizard *oRegWizard)
{
	gint type = gtk_option_menu_get_history(option_menu);
	if (type == 0)
		gtk_widget_set_sensitive(oRegWizard->nb_network_proxy_table, false);
	else
		gtk_widget_set_sensitive(oRegWizard->nb_network_proxy_table, true);
}

void RegWizard::create_nb_network_info()
{
	GtkWidget *frame;
	frame = gtk_frame_new(_("NetWork setting"));
	
	GtkWidget *vbox;
	vbox = gtk_vbox_new(false, 0);
	gtk_container_add(GTK_CONTAINER(frame),vbox);
	
	GtkWidget *table;
	table = gtk_table_new(2, 2, false);
	gtk_box_pack_start(GTK_BOX(vbox),table,FALSE,FALSE,0);
	
	GtkWidget *label;
	label = gtk_label_new(_("server address"));
	gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 0, 1);
	nb_network_server_host_combo = gtk_combo_new();
	GList *items = NULL;
	items = g_list_append (items, _("localhost"));
	items = g_list_append (items, _("myicq.cosoft.org.cn"));
	items = g_list_append (items, _("www.linuxfans.org.cn"));
	gtk_combo_set_popdown_strings (GTK_COMBO (nb_network_server_host_combo), items);
	g_list_free(items);	
	gtk_table_attach_defaults(GTK_TABLE(table), nb_network_server_host_combo, 0, 1, 1, 2);
	
	label = gtk_label_new(_("port"));
	gtk_table_attach_defaults(GTK_TABLE(table), label, 1, 2, 0, 1);
	nb_network_server_port_entry = gtk_entry_new();
	gtk_entry_set_text(GTK_ENTRY(nb_network_server_port_entry), "8000");
	gtk_table_attach_defaults(GTK_TABLE(table), nb_network_server_port_entry, 1, 2, 1, 2);
	
	
	nb_network_proxy_type_optionmenu = gtk_option_menu_new();	
	gtk_box_pack_start(GTK_BOX(vbox),nb_network_proxy_type_optionmenu,FALSE,FALSE,0);
	GtkWidget *menu = gtk_menu_new();
	GtkWidget *menuitem;	
	menuitem = gtk_menu_item_new_with_label(_("No proxy"));
	gtk_menu_shell_append(GTK_MENU_SHELL(menu), menuitem);
	menuitem = gtk_menu_item_new_with_label(_("SOCKS 5"));
	gtk_menu_shell_append(GTK_MENU_SHELL(menu), menuitem);
	menuitem = gtk_menu_item_new_with_label(_("HTTP"));
	gtk_menu_shell_append(GTK_MENU_SHELL(menu), menuitem);
	gtk_option_menu_set_menu(GTK_OPTION_MENU(nb_network_proxy_type_optionmenu), menu);
	g_signal_connect (G_OBJECT (nb_network_proxy_type_optionmenu), "changed", G_CALLBACK (on_nb_network_proxy_type_optionmenu_changed), this);

	nb_network_proxy_table = gtk_table_new(5, 2, false);
	gtk_widget_set_sensitive(nb_network_proxy_table, false);
	gtk_box_pack_start(GTK_BOX(vbox),nb_network_proxy_table,FALSE,FALSE,0);
	
	label = gtk_label_new(_("proxy address"));
	gtk_table_attach_defaults(GTK_TABLE(nb_network_proxy_table), label, 0, 1, 0, 1);
	nb_network_proxy_host_entry = gtk_entry_new();
	gtk_table_attach_defaults(GTK_TABLE(nb_network_proxy_table), nb_network_proxy_host_entry, 1, 2, 0, 1);
	label = gtk_label_new(_("port"));
	gtk_table_attach_defaults(GTK_TABLE(nb_network_proxy_table), label, 0, 1, 1, 2);
	nb_network_proxy_port_entry = gtk_entry_new();
	gtk_table_attach_defaults(GTK_TABLE(nb_network_proxy_table), nb_network_proxy_port_entry, 1, 2, 1, 2);
	label = gtk_label_new(_("username"));
	gtk_table_attach_defaults(GTK_TABLE(nb_network_proxy_table), label, 0, 1, 2, 3);
	nb_network_proxy_name_entry = gtk_entry_new();
	gtk_table_attach_defaults(GTK_TABLE(nb_network_proxy_table), nb_network_proxy_name_entry, 1, 2, 2, 3);
	label = gtk_label_new(_("password"));
	gtk_table_attach_defaults(GTK_TABLE(nb_network_proxy_table), label, 0, 1, 3, 4);
	nb_network_proxy_passwd_entry = gtk_entry_new();
	gtk_table_attach_defaults(GTK_TABLE(nb_network_proxy_table), nb_network_proxy_passwd_entry, 1, 2, 3, 4);
		
	nb_network_proxy_resolve_ckbutton = gtk_check_button_new_with_label(_("resolve the host name by socks 5 proxy"));
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(nb_network_proxy_resolve_ckbutton), true);
	gtk_table_attach_defaults(GTK_TABLE(nb_network_proxy_table), nb_network_proxy_resolve_ckbutton, 0, 2, 4, 5);
	

	gtk_notebook_append_page(GTK_NOTEBOOK(notebook),frame,NULL);
}

void RegWizard::create_nb_register_result()
{
	GtkWidget *vbox;
	vbox = gtk_vbox_new(false,0);
	GtkWidget *frame;
	frame = gtk_frame_new(_("User information"));
	gtk_box_pack_start(GTK_BOX(vbox),frame,false,false,0);
	
	frame = gtk_frame_new(_("Please wait"));
	gtk_box_pack_start(GTK_BOX(vbox),frame,false,false,0);
	nb_register_result_label = gtk_label_new("");
	gtk_container_add(GTK_CONTAINER(frame),nb_register_result_label);
		
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook),vbox,NULL);
}

gboolean RegWizard::on_delete_event(GtkWidget * window, GdkEvent *event , RegWizard *oRegWizard)
{
	delete oRegWizard;
	linqMain->Quit();
	return true;
}

RegWizard::RegPage RegWizard::nb_choose_next()
{
	if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (nb_choose_new_user_radio))) {
		return NB_BASIC_INFO;
	}
	else {
		return NB_NETWORK_INFO;
	}
}

RegWizard::RegPage RegWizard::nb_basic_info_next()
{
	const gchar *account;
	account = gtk_entry_get_text(GTK_ENTRY(nb_basic_account_entry));
	if (account[0] == '\0') {
		GtkWidget *dialog = gtk_message_dialog_new(GTK_WINDOW(window), GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, _("please input the account!"));			
		g_signal_connect_swapped (GTK_OBJECT (dialog), "response", G_CALLBACK (gtk_widget_destroy), GTK_OBJECT (dialog));
		gtk_widget_show (dialog);
		return NB_NULL;
	}
	const gchar *password_1;
	password_1 = gtk_entry_get_text(GTK_ENTRY(nb_basic_passwd_1_entry));
	const gchar *password_2;
	password_2 = gtk_entry_get_text(GTK_ENTRY(nb_basic_passwd_2_entry));
	if (password_1[0] == '\0') {
		GtkWidget *dialog = gtk_message_dialog_new(GTK_WINDOW(window), GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, _("please input the password!"));			
		g_signal_connect_swapped (GTK_OBJECT (dialog), "response", G_CALLBACK (gtk_widget_destroy), GTK_OBJECT (dialog));
		gtk_widget_show (dialog);
		return NB_NULL;
	}
	if (strcmp(password_1, password_2)) {
		GtkWidget *dialog = gtk_message_dialog_new(GTK_WINDOW(window), GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, _("password don't equal!"));
		g_signal_connect_swapped (GTK_OBJECT (dialog), "response", G_CALLBACK (gtk_widget_destroy), GTK_OBJECT (dialog));
		gtk_widget_show (dialog);
		return NB_NULL;
	}
	const gchar *nickname;
	nickname = gtk_entry_get_text(GTK_ENTRY(nb_basic_nickname_entry));
	if (nickname[0] == '\0') {
		GtkWidget *dialog = gtk_message_dialog_new(GTK_WINDOW(window), GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, _("please input the nickname!"));			
		g_signal_connect_swapped (GTK_OBJECT (dialog), "response", G_CALLBACK (gtk_widget_destroy), GTK_OBJECT (dialog));
		gtk_widget_show (dialog);
		return NB_NULL;
	}	
	
	return NB_CONTACT_INFO;
}

RegWizard::RegPage RegWizard::nb_contact_info_next()
{
	return NB_DETAIL_INFO;
}

RegWizard::RegPage RegWizard::nb_detail_info_next()
{
	return NB_NETWORK_INFO;
}

RegWizard::RegPage RegWizard::nb_network_info_next()
{
	gtk_label_set_text(GTK_LABEL(nb_register_result_label),"connecting...");
	gint proxy_type = gtk_option_menu_get_history(GTK_OPTION_MENU(nb_network_proxy_type_optionmenu));
	if (proxy_type == 0) {
		linqMain->setProxy(NULL);
	}
	else {
		PROXY_INFO proxy;
		if (proxy_type == 1)
			proxy.type = PROXY_SOCKS5;
		else
			proxy.type = PROXY_HTTPS;
		proxy.host = gtk_entry_get_text(GTK_ENTRY(nb_network_proxy_host_entry));
		proxy.port = atoi(gtk_entry_get_text(GTK_ENTRY(nb_network_proxy_port_entry)));
		proxy.name = gtk_entry_get_text(GTK_ENTRY(nb_network_proxy_name_entry));
		proxy.passwd = gtk_entry_get_text(GTK_ENTRY(nb_network_proxy_passwd_entry));		
		proxy.resolve = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(nb_network_proxy_resolve_ckbutton));		
	
		linqMain->setProxy(&proxy);
	}
	linqMain->connect(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(nb_network_server_host_combo)->entry)), atoi(gtk_entry_get_text(GTK_ENTRY(nb_network_server_port_entry))));

	return NB_REGISTER_RESULT;
}

RegWizard::RegPage RegWizard::nb_register_result_next()
{
	return NB_NULL;
}

void RegWizard::on_next_clicked(GtkWidget *button, RegWizard *oRegWizard)
{
	RegPage next_page;
	switch (oRegWizard->nb_current_page) {
		case NB_CHOOSE:
			next_page = oRegWizard->nb_choose_next();
			break;
		case NB_BASIC_INFO:
			next_page = oRegWizard->nb_basic_info_next();
			break;
		case NB_CONTACT_INFO:
			next_page = oRegWizard->nb_contact_info_next();
			break;
		case NB_DETAIL_INFO:
			next_page = oRegWizard->nb_detail_info_next();
			break;
		case NB_NETWORK_INFO:
			next_page = oRegWizard->nb_network_info_next();
			break;
		case NB_REGISTER_RESULT:
			next_page = oRegWizard->nb_register_result_next();
			break;
		default:
			next_page = NB_CHOOSE;
	}
	if (next_page == NB_NULL)
		return;
	gtk_notebook_set_current_page (GTK_NOTEBOOK (oRegWizard->notebook), next_page);
	oRegWizard->nb_current_page = next_page;	
	gtk_widget_set_sensitive(oRegWizard->back_button,TRUE);
}

void RegWizard::on_back_clicked(GtkWidget *button, RegWizard *oRegWizard)
{
	RegPage back_page;
	switch (oRegWizard->nb_current_page) {
		case NB_BASIC_INFO:
			back_page = NB_CHOOSE;
			break;
		case NB_CONTACT_INFO:
			back_page = NB_BASIC_INFO;
			break;
		case NB_DETAIL_INFO:
			back_page = NB_CONTACT_INFO;
			break;
		case NB_NETWORK_INFO:
			if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (oRegWizard->nb_choose_new_user_radio)))
				back_page = NB_DETAIL_INFO;
			else
				back_page = NB_CHOOSE;
			break;
		case NB_REGISTER_RESULT:
			back_page = NB_NETWORK_INFO;
			break;
		default:
			back_page = NB_CHOOSE;
	}
	gtk_notebook_set_current_page (GTK_NOTEBOOK (oRegWizard->notebook), back_page);
	oRegWizard->nb_current_page = back_page;	
	if (oRegWizard->nb_current_page==NB_CHOOSE)
		gtk_widget_set_sensitive(oRegWizard->back_button,FALSE);
}

void RegWizard::on_finish_clicked(GtkWidget *button, RegWizard *oRegWizard)
{
	delete oRegWizard;
	linqMain->ShowMainWin();
	linqMain->main_win->changeStatus(STATUS_ONLINE);
}

void RegWizard::on_cancel_clicked(GtkWidget *button, RegWizard *oRegWizard)
{
	delete oRegWizard;
	linqMain->Quit();
}

void RegWizard::setFinished()
{
	gtk_button_set_label(GTK_BUTTON(next_button),_("Finish"));
	g_signal_handlers_disconnect_by_func(G_OBJECT (next_button), (void *)on_next_clicked, this);
	g_signal_connect (G_OBJECT (next_button), "clicked", G_CALLBACK(on_finish_clicked), this);
}

void RegWizard::onConnect(bool connected)
{
	if (connected) {
		if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (nb_choose_new_user_radio))) {
			gtk_label_set_text(GTK_LABEL(nb_register_result_label),"registering...");
			const gchar *user = gtk_entry_get_text(GTK_ENTRY(nb_basic_account_entry));
			const gchar *passwd = gtk_entry_get_text(GTK_ENTRY(nb_basic_passwd_1_entry));		
			linqMain->getUDPSession()->registerUser(user, passwd);
		}
		else {			
			gtk_label_set_text(GTK_LABEL(nb_register_result_label),"Synching with server...");
			waiting_preLogin = true;
			linqMain->getUDPSession()->preLogin(gtk_entry_get_text(GTK_ENTRY(nb_choose_user_entry)));
		}		
	}
	else
		gtk_label_set_text(GTK_LABEL(nb_register_result_label),"connect to server failed!");
}

gboolean RegWizard::onPreLoginReply(uint16 sequence, const char *token)
{	
	if (waiting_preLogin) {
		if (sequence > 0) {		
			const gchar *user;
			const gchar *passwd;
			if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (nb_choose_new_user_radio))) {
				user = gtk_entry_get_text(GTK_ENTRY(nb_basic_account_entry));
				passwd = gtk_entry_get_text(GTK_ENTRY(nb_basic_passwd_1_entry));
			}
			else {
				user = gtk_entry_get_text(GTK_ENTRY(nb_choose_user_entry));
				passwd = gtk_entry_get_text(GTK_ENTRY(nb_choose_password_entry));
			}

			linqMain->login(user, passwd, token, sequence, STATUS_INVIS);
		}
		else {
			gtk_label_set_text(GTK_LABEL(nb_register_result_label),"no such user.");
		}
		waiting_preLogin = false;
		return true;
	}
	return false;
}

void RegWizard::onRegisterReply(uint8 error)
{
	if (nb_current_page == NB_REGISTER_RESULT) {
		switch (error) {
		case REG_SUCCESS:
			gtk_label_set_text(GTK_LABEL(nb_register_result_label),"register success\nSynching with server...");
			waiting_preLogin = true;
			linqMain->getUDPSession()->preLogin(gtk_entry_get_text(GTK_ENTRY(nb_basic_account_entry)));
			break;
		case REG_ERROR_UNKNOWN:
			gtk_label_set_text(GTK_LABEL(nb_register_result_label),"unknow error");
			break;
		case REG_USER_EXISTS:
			gtk_label_set_text(GTK_LABEL(nb_register_result_label),"user already exists");
			break;
		}		
	}
}

void RegWizard::onLoginReply(uint8 error)
{
	switch (error) {
	case LOGIN_SUCCESS:
	{
		const gchar *user;
		if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (nb_choose_new_user_radio)))
			user = gtk_entry_get_text(GTK_ENTRY(nb_basic_account_entry));
		else
			user = gtk_entry_get_text(GTK_ENTRY(nb_choose_user_entry));
		
		string str;
		str = user;
		LinqUsers::addUser(str);
				
		linqMain->getUserDir(str, user);
		IcqDB::setDir(str.c_str());
#ifdef G_OS_WIN32
		struct stat st;
		if (stat (str.c_str(), &st))
			mkdir (str.c_str());
#endif
		
		getOption(linqMain->options);
		IcqDB::saveOptions(linqMain->options);

		if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (nb_choose_new_user_radio))) {
			gtk_label_set_text(GTK_LABEL(nb_register_result_label),"login succeeded\nclick finish to go on line.");
			USER_INFO info;			
			getInfo(info);
			
			linqMain->getUDPSession()->updateUserInfo(info);
			
			LinqUserInfo userInfo(info);
			IcqDB::saveUserInfo(userInfo);
			
			g_free((gchar *)(info.intro));
			
			const gchar *passwd = gtk_entry_get_text(GTK_ENTRY(nb_basic_passwd_1_entry));
			linqMain->myInfo.name = info.name;
			linqMain->myInfo.passwd = passwd;
			linqMain->myInfo.now_status = STATUS_INVIS;
			setFinished();
		}
		else {
			gtk_label_set_text(GTK_LABEL(nb_register_result_label),"login succeeded\ngetting contact list..");
			const gchar *user = gtk_entry_get_text(GTK_ENTRY(nb_choose_user_entry));
			const gchar *passwd = gtk_entry_get_text(GTK_ENTRY(nb_choose_password_entry));
			linqMain->myInfo.name = user;
			linqMain->myInfo.passwd = passwd;
			linqMain->myInfo.now_status = STATUS_INVIS;
			linqMain->getUDPSession()->getUserInfo();
			linqMain->getUDPSession()->getContactList();			
		}		
		break;
	}
	case LOGIN_WRONG_PASSWD:
		gtk_label_set_text(GTK_LABEL(nb_register_result_label),"wrong passwd.");
		break;
	case LOGIN_INVALID_USER:
		gtk_label_set_text(GTK_LABEL(nb_register_result_label),"no such user.");
		break;
	}
}

void RegWizard::getInfo(USER_INFO &info)
{
	info.name = gtk_entry_get_text(GTK_ENTRY(nb_basic_account_entry));
	info.nick = gtk_entry_get_text(GTK_ENTRY(nb_basic_nickname_entry));
	info.gender = gtk_option_menu_get_history(GTK_OPTION_MENU(nb_basic_gender_optionmenu));
			
	struct tm birth_tm;
	birth_tm.tm_sec = 0;
	birth_tm.tm_min = 0;
	birth_tm.tm_hour = 0;
	birth_tm.tm_mday = atoi(gtk_entry_get_text(GTK_ENTRY(nb_basic_birth_date_entry)));
	birth_tm.tm_mon = atoi(gtk_entry_get_text(GTK_ENTRY(nb_basic_birth_month_entry)));
	birth_tm.tm_year = atoi(gtk_entry_get_text(GTK_ENTRY(nb_basic_birth_year_entry)));
	birth_tm.tm_wday = 0;
	birth_tm.tm_yday = 0;
	birth_tm.tm_isdst = 0;
			
	info.birth = mktime(&birth_tm);
		
	info.email = gtk_entry_get_text(GTK_ENTRY(nb_contact_email_entry));
	info.country = gtk_entry_get_text(GTK_ENTRY(nb_basic_country_entry));
	info.city = gtk_entry_get_text(GTK_ENTRY(nb_basic_city_entry));
	info.address = gtk_entry_get_text(GTK_ENTRY(nb_contact_address_entry));
	info.postcode = gtk_entry_get_text(GTK_ENTRY(nb_contact_postcode_entry));
	info.tel = gtk_entry_get_text(GTK_ENTRY(nb_contact_tel_entry));
	info.mobile = gtk_entry_get_text(GTK_ENTRY(nb_contact_mobile_entry));
	info.realname = gtk_entry_get_text(GTK_ENTRY(nb_detail_realname_entry));
	info.occupation = gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(nb_detail_occupation_combo)->entry));
	info.homepage = gtk_entry_get_text(GTK_ENTRY(nb_detail_homepage_entry));
			
	GtkTextIter start, end;
	gtk_text_buffer_get_bounds(gtk_text_view_get_buffer(GTK_TEXT_VIEW(nb_detail_intro_textview)),&start,&end);
	info.intro = gtk_text_buffer_get_text(gtk_text_view_get_buffer(GTK_TEXT_VIEW(nb_detail_intro_textview)),&start,&end,FALSE);			
	
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(nb_detail_auth_radio_1)))
		info.auth = AUTH_ACCEPTED;
	else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(nb_detail_auth_radio_2)))
		info.auth = AUTH_REQUEST;
	else
		info.auth = AUTH_REJECTED;
}

void RegWizard::getOption(LinqOption &option)
{
	const gchar *passwd;	
	if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (nb_choose_new_user_radio)))
		passwd = gtk_entry_get_text(GTK_ENTRY(nb_basic_passwd_1_entry));
	else
		passwd = gtk_entry_get_text(GTK_ENTRY(nb_choose_password_entry));
	char hash[41];
	char str[51];		
	shahash_r(passwd, hash);
	snprintf(str, 51, "%slinq", hash);
	shahash_r(str, hash);
	
	option.passwd_hash = hash;


	option.server_host = gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(nb_network_server_host_combo)->entry));
	option.server_port = atoi(gtk_entry_get_text(GTK_ENTRY(nb_network_server_port_entry)));
	
	option.proxy_type = gtk_option_menu_get_history(GTK_OPTION_MENU(nb_network_proxy_type_optionmenu));
	option.proxy_host = gtk_entry_get_text(GTK_ENTRY(nb_network_proxy_host_entry));
	option.proxy_port = atoi(gtk_entry_get_text(GTK_ENTRY(nb_network_proxy_port_entry)));
	option.proxy_username = gtk_entry_get_text(GTK_ENTRY(nb_network_proxy_host_entry));
	option.proxy_passwd = gtk_entry_get_text(GTK_ENTRY(nb_network_proxy_host_entry));
	option.proxy_resolve = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(nb_network_proxy_resolve_ckbutton));
}

void RegWizard::onUserInfoReply(USER_INFO &user)
{
	UserInfo_received = true;
			
	LinqUserInfo userInfo(user);
	IcqDB::saveUserInfo(userInfo);
	
	if (ContactList_received) {
		gtk_label_set_text(GTK_LABEL(nb_register_result_label),"got contactlist,click finish.");
		setFinished();
	}
}

void RegWizard::onContactListReply(const char *result[], int n)
{
	ContactList_received = true;
	
	//need to clear all contact?
	
	for (int i = 0; i < n; i++) {
		LinqContactInfo contact;
		contact.name = result[i];
		IcqDB::saveContactInfo(contact);
				
		linqMain->getUDPSession()->getContactInfo(result[i]);
	}	
	
	if (UserInfo_received) {
		gtk_label_set_text(GTK_LABEL(nb_register_result_label),"got contactlist,click finish.");
		setFinished();
	}
}
