#include "config.h"
#include "MainWin_ContactView.h"
#include "LinqMain.h"
#include "intl.h"

enum {
	COLUMN_HEAD_ICON,
	COLUMN_NAME,
	COLUMN_NODE_DATA,
	NR_COLUMN,
};

ContactView::ContactView()
{
	buddy_left_menu = NULL;
	buddy_right_menu = NULL;
	buddy_group_menu = NULL;
}

ContactView::~ContactView()
{
}

gboolean ContactView::clear_tree_model_data(GtkTreeModel *model, GtkTreePath *path, GtkTreeIter *iter, gpointer data)
{
	ContactListNode *node;
	gtk_tree_model_get(model, iter, COLUMN_NODE_DATA, &node, -1);
	delete node;
	return false;
}

void ContactView::Destroy()
{
	gtk_tree_model_foreach(GTK_TREE_MODEL(buddy_tree_model), clear_tree_model_data, NULL);
	if (buddy_left_menu)
		gtk_widget_destroy(buddy_left_menu);
	if (buddy_right_menu)
		gtk_widget_destroy(buddy_right_menu);
	if (buddy_group_menu)
		gtk_widget_destroy(buddy_group_menu);	
}

GtkWidget *ContactView::Create()
{
	GtkWidget *vbox;
	vbox = gtk_vbox_new(false,0);
	gtk_widget_show(vbox);
	
	GtkWidget *button;
	button = gtk_button_new();
	g_signal_connect (G_OBJECT (button), "clicked", G_CALLBACK (on_buddy_button_clicked), this);
	GtkWidget *hbox;
	hbox = gtk_hbox_new(false,0);
	GtkWidget *image;
	image = gtk_image_new_from_pixbuf(linqMain->skin->linq.status[STATUS_ONLINE]);
	gtk_box_pack_start(GTK_BOX(hbox), image,true,true,0);
	GtkWidget *label;
	label = gtk_label_new(_("Buddy list"));
	gtk_box_pack_start(GTK_BOX(hbox), label,true,true,0);
	gtk_container_add(GTK_CONTAINER(button), hbox);
	gtk_box_pack_start(GTK_BOX(vbox), button,false,false,0);
	gtk_widget_show_all(button);

	GtkTreeStore *model;
	GtkTreeIter iter;
	GtkTreeIter child_iter;
	model = gtk_tree_store_new (NR_COLUMN,GDK_TYPE_PIXBUF,G_TYPE_STRING,G_TYPE_POINTER);
	buddy_tree_model = model;
	
	ContactListNode *node;
	node = new ContactListNode;
	node->type = CONTACT_LIST_NODE_GROUP;
	node->name = _("my friends");
	gtk_tree_store_append (model, &iter, NULL);
	gtk_tree_store_set (model, &iter, COLUMN_NAME, "My <b>friends</b>", COLUMN_NODE_DATA, node, -1);
	
	/*gtk_tree_store_append (model, &child_iter, &iter);
	gtk_tree_store_set (model, &child_iter, 0,linqMain->skin->linq.face[1],1,"hu<big>z</big>heng", -1);
	gtk_tree_store_append (model, &child_iter, &iter);
	gtk_tree_store_set (model, &child_iter, 0,linqMain->skin->linq.face[2],1,"<span foreground=\"blue\">zhang</span>yong :)", -1);

	gtk_tree_store_append (model, &iter, NULL);
	gtk_tree_store_set (model, &iter, 1,"my roommate", -1);

	gtk_tree_store_append (model, &child_iter, &iter);
	gtk_tree_store_set (model, &child_iter, 0,linqMain->skin->linq.face[3],1,"aa", -1);
	gtk_tree_store_append (model, &child_iter, &iter);
	gtk_tree_store_set (model, &child_iter, 0,linqMain->skin->linq.face[4],1,"bb", -1);
	*/
	
	buddy_treeview = gtk_tree_view_new_with_model (GTK_TREE_MODEL (model));	
	g_object_unref (model);
	gtk_tree_view_set_headers_visible (GTK_TREE_VIEW (buddy_treeview), FALSE);
	gtk_tree_view_set_rules_hint (GTK_TREE_VIEW (buddy_treeview), TRUE);	
	
	GtkCellRenderer *renderer_image;
	GtkCellRenderer *renderer_text;
	GtkTreeViewColumn *column;
	column = gtk_tree_view_column_new();
	renderer_image = gtk_cell_renderer_pixbuf_new();
	gtk_tree_view_column_pack_start(column,renderer_image,FALSE);
	gtk_tree_view_column_add_attribute(column,
                                     renderer_image,
                                     "pixbuf",COLUMN_HEAD_ICON);
	g_object_set(renderer_image, "xalign", 0.0, "ypad", 0, NULL);
	renderer_text = gtk_cell_renderer_text_new ();	
	gtk_tree_view_column_pack_start(column,renderer_text,TRUE);
	gtk_tree_view_column_add_attribute(column,
                                     renderer_text,
                                     "markup",COLUMN_NAME);
	g_object_set(renderer_text, "xalign", 0.0, "yalign", 0.5, NULL);
	
	gtk_tree_view_insert_column(GTK_TREE_VIEW(buddy_treeview),column,-1);

	g_signal_connect(G_OBJECT(buddy_treeview), "button-press-event", G_CALLBACK(on_buddy_treeview_button_press), this);
	g_signal_connect (G_OBJECT (buddy_treeview), "realize",  G_CALLBACK (on_buddy_treeview_realize),  this);
	
	buddy_scrollwindow = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (buddy_scrollwindow),GTK_SHADOW_ETCHED_IN);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (buddy_scrollwindow),GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);	
	gtk_container_add (GTK_CONTAINER (buddy_scrollwindow), buddy_treeview);
	
	gtk_box_pack_start(GTK_BOX(vbox), buddy_scrollwindow,true,true,0);
	gtk_widget_show_all(buddy_scrollwindow);

	
	button = gtk_button_new_with_label("Group list");
	g_signal_connect (G_OBJECT (button), "clicked", G_CALLBACK (on_group_button_clicked), this);
	gtk_box_pack_start(GTK_BOX(vbox), button,false,false,0);
	gtk_widget_show_all(button);
	

	model = gtk_tree_store_new (2,GDK_TYPE_PIXBUF,G_TYPE_STRING);
	group_tree_model = model;
	gtk_tree_store_append (model, &iter, NULL);
	gtk_tree_store_set (model, &iter, 1,"SCU linux club", -1);
	
	gtk_tree_store_append (model, &child_iter, &iter);
	gtk_tree_store_set (model, &child_iter, 0,linqMain->skin->linq.face[1],1,"hu<big>z</big>heng", -1);
	gtk_tree_store_append (model, &child_iter, &iter);
	gtk_tree_store_set (model, &child_iter, 0,linqMain->skin->linq.face[2],1,"<span foreground=\"blue\">zhang</span>yong :)", -1);

	gtk_tree_store_append (model, &iter, NULL);
	gtk_tree_store_set (model, &iter, 1,"room120", -1);

	gtk_tree_store_append (model, &child_iter, &iter);
	gtk_tree_store_set (model, &child_iter, 0,linqMain->skin->linq.face[3],1,"aa", -1);
	gtk_tree_store_append (model, &child_iter, &iter);
	gtk_tree_store_set (model, &child_iter, 0,linqMain->skin->linq.face[4],1,"bb", -1);

	
	group_treeview = gtk_tree_view_new_with_model (GTK_TREE_MODEL (model));
	g_object_unref (model);
	gtk_widget_show(group_treeview);
	gtk_tree_view_set_headers_visible (GTK_TREE_VIEW (group_treeview), FALSE);
	gtk_tree_view_set_rules_hint (GTK_TREE_VIEW (group_treeview), TRUE);	
	
	column = gtk_tree_view_column_new();
	renderer_image = gtk_cell_renderer_pixbuf_new();
	gtk_tree_view_column_pack_start(column,renderer_image,FALSE);
	gtk_tree_view_column_add_attribute(column,
                                     renderer_image,
                                     "pixbuf",0);
	g_object_set(renderer_image, "xalign", 0.0, "ypad", 0, NULL);
	renderer_text = gtk_cell_renderer_text_new ();	
	gtk_tree_view_column_pack_start(column,renderer_text,TRUE);
	gtk_tree_view_column_add_attribute(column,
                                     renderer_text,
                                     "markup",1);
	g_object_set(renderer_text, "xalign", 0.0, "yalign", 0.5, NULL);
	
	gtk_tree_view_insert_column(GTK_TREE_VIEW(group_treeview),column,-1);

	g_signal_connect(G_OBJECT(group_treeview), "button-press-event", G_CALLBACK(on_group_treeview_button_press), this);
	g_signal_connect (G_OBJECT (group_treeview), "realize",  G_CALLBACK (on_group_treeview_realize),  this);


	group_scrollwindow = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (group_scrollwindow),GTK_SHADOW_ETCHED_IN);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (group_scrollwindow),GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);	
	gtk_container_add (GTK_CONTAINER (group_scrollwindow), group_treeview);
	
	gtk_box_pack_start(GTK_BOX(vbox), group_scrollwindow,true,true,0);

	loadContactList();
	
	return vbox;
}

void ContactView::on_buddy_button_clicked(GtkWidget *button, ContactView *oContactView)
{
	gtk_widget_show(oContactView->buddy_scrollwindow);
	gtk_widget_hide(oContactView->group_scrollwindow);
}

void ContactView::on_group_button_clicked(GtkWidget *button, ContactView *oContactView)
{
	gtk_widget_show(oContactView->group_scrollwindow);
	gtk_widget_hide(oContactView->buddy_scrollwindow);
}

void ContactView::on_buddy_left_menu_sendmsg_activate(GtkMenuItem *menuitem, ContactView *oContactView)
{
	GtkTreeIter iter;
	GtkTreeModel *model;
	if (!gtk_tree_selection_get_selected (gtk_tree_view_get_selection (GTK_TREE_VIEW (oContactView->buddy_treeview)), &model, &iter))
		return;

	ContactListNode *node;
	gtk_tree_model_get (model, &iter, COLUMN_NODE_DATA, &node,-1);

	LinqWindow *win;
	win = linqMain->findWindow(WIN_SEND_MESSAGE);
	SendMsgDlg *dlg;
	if (win) {
		dlg = (SendMsgDlg *)win;
	}
	else {
		dlg = new SendMsgDlg;
	}	
	dlg->Show(node->name.c_str());	
}

void ContactView::on_buddy_left_menu_sendfile_activate(GtkMenuItem *menuitem, ContactView *oContactView)
{
	GtkTreeIter iter;
	GtkTreeModel *model;
	if (!gtk_tree_selection_get_selected (gtk_tree_view_get_selection (GTK_TREE_VIEW (oContactView->buddy_treeview)), &model, &iter))
		return;

	ContactListNode *node;
	gtk_tree_model_get (model, &iter, COLUMN_NODE_DATA, &node,-1);

	linqMain->sendTCPRequest("SENDFILE", node->name.c_str(), "nick", "reason");
}

void ContactView::on_buddy_left_menu_sendmail_activate(GtkMenuItem *menuitem, ContactView *oContactView)
{
}

void ContactView::on_buddy_left_menu_chatlog_activate(GtkMenuItem *menuitem, ContactView *oContactView)
{
}

void ContactView::on_buddy_left_menu_viewinfo_activate(GtkMenuItem *menuitem, ContactView *oContactView)
{
	GtkTreeIter iter;
	GtkTreeModel *model;
	if (!gtk_tree_selection_get_selected (gtk_tree_view_get_selection (GTK_TREE_VIEW (oContactView->buddy_treeview)), &model, &iter))
		return;

	ContactListNode *node;
	gtk_tree_model_get (model, &iter, COLUMN_NODE_DATA, &node,-1);

	linqMain->main_win->getInfo(node->name.c_str());
}

void ContactView::on_buddy_right_menu_addGroup_activate(GtkMenuItem *menuitem, ContactView *oContactView)
{
}

void ContactView::on_buddy_right_menu_onlyShowOnlineUser_activate(GtkMenuItem *menuitem, ContactView *oContactView)
{
}

void ContactView::on_buddy_right_menu_delete_activate(GtkMenuItem *menuitem, ContactView *oContactView)
{
	GtkTreeIter iter;
	GtkTreeModel *model;
	if (!gtk_tree_selection_get_selected (gtk_tree_view_get_selection (GTK_TREE_VIEW (oContactView->buddy_treeview)), &model, &iter))
		return;

	ContactListNode *node;
	gtk_tree_model_get (model, &iter, COLUMN_NODE_DATA, &node,-1);
	
	linqMain->getUDPSession()->delContact(node->name.c_str());
	
	delete node;
	gtk_tree_store_remove(oContactView->buddy_tree_model, &iter);
}

void ContactView::on_buddy_right_menu_rename_activate(GtkMenuItem *menuitem, ContactView *oContactView)
{
}

void ContactView::on_buddy_treeview_realize(GtkWidget *widget, ContactView *oContactView)
{
	g_print("realize\n");
	gtk_tree_view_expand_all (GTK_TREE_VIEW (widget));
}

gboolean ContactView::on_buddy_treeview_button_press(GtkWidget *widget, GdkEventButton *event, ContactView *oContactView)
{
	if (event->window != gtk_tree_view_get_bin_window(GTK_TREE_VIEW(oContactView->buddy_treeview)))
		return false;
	if ((event->button != 1) && (event->button !=3))
		return false;
	GtkTreePath *path;
	if (!gtk_tree_view_get_path_at_pos(GTK_TREE_VIEW(oContactView->buddy_treeview), (gint)event->x, (gint)event->y, &path, NULL, NULL, NULL)) {
		//show menu...
		return false;
	}

	gboolean return_val=false;

	GtkTreeIter iter;
	GtkTreeModel *model;
	model = gtk_tree_view_get_model(GTK_TREE_VIEW(oContactView->buddy_treeview));
	gtk_tree_model_get_iter(model, &iter, path);
	GtkTreeSelection *selection;
	selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(oContactView->buddy_treeview));
	
	ContactListNode *node;
	gtk_tree_model_get (model, &iter, COLUMN_NODE_DATA, &node,-1);

	if (event->button == 1) {
		if (node->type == CONTACT_LIST_NODE_GROUP) {
			return_val = false;
		}
		else {
			if (!oContactView->buddy_left_menu) {
				oContactView->buddy_left_menu = gtk_menu_new();
				GtkWidget *menuitem;
				menuitem = gtk_image_menu_item_new_with_mnemonic(_("_Send message"));
				GtkWidget *image;
				image = gtk_image_new_from_pixbuf(linqMain->skin->linq.buddy_menu.send_message);
				gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuitem), image);
				g_signal_connect(G_OBJECT(menuitem), "activate", G_CALLBACK(on_buddy_left_menu_sendmsg_activate), oContactView);
				gtk_menu_shell_append(GTK_MENU_SHELL(oContactView->buddy_left_menu), menuitem);

				menuitem = gtk_image_menu_item_new_with_mnemonic(_("Send _file"));
				//image = gtk_image_new_from_pixbuf(linqMain->skin->linq.buddy_menu.send_message);
				//gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuitem), image);
				g_signal_connect(G_OBJECT(menuitem), "activate", G_CALLBACK(on_buddy_left_menu_sendfile_activate), oContactView);
				gtk_menu_shell_append(GTK_MENU_SHELL(oContactView->buddy_left_menu), menuitem);
				menuitem = gtk_separator_menu_item_new();
				gtk_menu_shell_append(GTK_MENU_SHELL(oContactView->buddy_left_menu), menuitem);

				menuitem = gtk_image_menu_item_new_with_mnemonic(_("Send _mail"));
				image = gtk_image_new_from_pixbuf(linqMain->skin->linq.buddy_menu.send_mail);
				gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuitem), image);
				g_signal_connect(G_OBJECT(menuitem), "activate", G_CALLBACK(on_buddy_left_menu_sendmail_activate), oContactView);
				gtk_menu_shell_append(GTK_MENU_SHELL(oContactView->buddy_left_menu), menuitem);
				menuitem = gtk_separator_menu_item_new();
				gtk_menu_shell_append(GTK_MENU_SHELL(oContactView->buddy_left_menu), menuitem);

				menuitem = gtk_image_menu_item_new_with_mnemonic(_("_Chat log"));
				image = gtk_image_new_from_pixbuf(linqMain->skin->linq.buddy_menu.chat_log);
				gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuitem), image);
				g_signal_connect(G_OBJECT(menuitem), "activate", G_CALLBACK(on_buddy_left_menu_chatlog_activate), oContactView);
				gtk_menu_shell_append(GTK_MENU_SHELL(oContactView->buddy_left_menu), menuitem);
				menuitem = gtk_separator_menu_item_new();
				gtk_menu_shell_append(GTK_MENU_SHELL(oContactView->buddy_left_menu), menuitem);

				menuitem = gtk_image_menu_item_new_with_mnemonic(_("_View info"));
				image = gtk_image_new_from_pixbuf(linqMain->skin->linq.buddy_menu.view_info);
				gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuitem), image);
				g_signal_connect(G_OBJECT(menuitem), "activate", G_CALLBACK(on_buddy_left_menu_viewinfo_activate), oContactView);
				gtk_menu_shell_append(GTK_MENU_SHELL(oContactView->buddy_left_menu), menuitem);
			
				gtk_widget_show_all(oContactView->buddy_left_menu);				
			}
			gtk_menu_popup(GTK_MENU(oContactView->buddy_left_menu), NULL, NULL, NULL, NULL, 1, event->time);
			
			gtk_tree_selection_select_path(selection, path);
			
			return_val = true;
		}				
	}
	else if (event->button == 3) {
		if (node->type == CONTACT_LIST_NODE_GROUP) {
			if (!oContactView->buddy_group_menu) {
				oContactView->buddy_group_menu = gtk_menu_new();
				GtkWidget *menuitem;
				menuitem = gtk_image_menu_item_new_with_mnemonic(_("_Add buddy"));
				//GtkWidget *image;
				//image = gtk_image_new_from_pixbuf(linqMain->skin->linq.buddy_menu.send_message);
				//gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuitem), image);
				//g_signal_connect(G_OBJECT(menuitem), "activate", G_CALLBACK(on_buddy_left_menu_sendmsg_activate), oContactView);
				gtk_menu_shell_append(GTK_MENU_SHELL(oContactView->buddy_group_menu), menuitem);

				menuitem = gtk_image_menu_item_new_with_mnemonic(_("_Delete group"));
				//image = gtk_image_new_from_pixbuf(linqMain->skin->linq.buddy_menu.send_message);
				//gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuitem), image);
				//g_signal_connect(G_OBJECT(menuitem), "activate", G_CALLBACK(on_buddy_left_menu_sendmsg_activate), oContactView);
				gtk_menu_shell_append(GTK_MENU_SHELL(oContactView->buddy_group_menu), menuitem);

				menuitem = gtk_image_menu_item_new_with_mnemonic(_("_Rename"));
				//image = gtk_image_new_from_pixbuf(linqMain->skin->linq.buddy_menu.send_message);
				//gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuitem), image);
				//g_signal_connect(G_OBJECT(menuitem), "activate", G_CALLBACK(on_buddy_left_menu_sendmsg_activate), oContactView);
				gtk_menu_shell_append(GTK_MENU_SHELL(oContactView->buddy_group_menu), menuitem);
				gtk_widget_show_all(oContactView->buddy_group_menu);
			}
			gtk_menu_popup(GTK_MENU(oContactView->buddy_group_menu), NULL, NULL, NULL, NULL, 1, event->time);			
			gtk_tree_selection_select_path(selection, path);			
			return_val = true;
		}
		else {
			if (!oContactView->buddy_right_menu) {
				oContactView->buddy_right_menu = gtk_menu_new();
				GtkWidget *menuitem;
				menuitem = gtk_image_menu_item_new_with_mnemonic(_("_Add group"));
				//GtkWidget *image;
				//image = gtk_image_new_from_pixbuf(linqMain->skin->linq.buddy_menu.send_message);
				//gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuitem), image);
				g_signal_connect(G_OBJECT(menuitem), "activate", G_CALLBACK(on_buddy_right_menu_addGroup_activate), oContactView);
				gtk_menu_shell_append(GTK_MENU_SHELL(oContactView->buddy_right_menu), menuitem);
				menuitem = gtk_separator_menu_item_new();
				gtk_menu_shell_append(GTK_MENU_SHELL(oContactView->buddy_right_menu), menuitem);

				menuitem = gtk_image_menu_item_new_with_mnemonic(_("_Only show online user"));
				//image = gtk_image_new_from_pixbuf(linqMain->skin->linq.buddy_menu.send_message);
				//gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuitem), image);
				g_signal_connect(G_OBJECT(menuitem), "activate", G_CALLBACK(on_buddy_right_menu_onlyShowOnlineUser_activate), oContactView);
				gtk_menu_shell_append(GTK_MENU_SHELL(oContactView->buddy_right_menu), menuitem);
				menuitem = gtk_separator_menu_item_new();
				gtk_menu_shell_append(GTK_MENU_SHELL(oContactView->buddy_right_menu), menuitem);

				menuitem = gtk_image_menu_item_new_with_mnemonic(_("_Delete from this group"));
				//image = gtk_image_new_from_pixbuf(linqMain->skin->linq.buddy_menu.send_message);
				//gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuitem), image);
				g_signal_connect(G_OBJECT(menuitem), "activate", G_CALLBACK(on_buddy_right_menu_delete_activate), oContactView);
				gtk_menu_shell_append(GTK_MENU_SHELL(oContactView->buddy_right_menu), menuitem);

				menuitem = gtk_image_menu_item_new_with_mnemonic(_("_Rename"));
				//image = gtk_image_new_from_pixbuf(linqMain->skin->linq.buddy_menu.send_message);
				//gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuitem), image);
				g_signal_connect(G_OBJECT(menuitem), "activate", G_CALLBACK(on_buddy_right_menu_rename_activate), oContactView);
				gtk_menu_shell_append(GTK_MENU_SHELL(oContactView->buddy_right_menu), menuitem);
			
				gtk_widget_show_all(oContactView->buddy_right_menu);				
			}
			gtk_menu_popup(GTK_MENU(oContactView->buddy_right_menu), NULL, NULL, NULL, NULL, 1, event->time);			
			gtk_tree_selection_select_path(selection, path);			
			return_val = true;
		}				
	}	
	gtk_tree_path_free(path);
	return return_val;
}

void ContactView::on_group_treeview_realize(GtkWidget *widget, ContactView *oContactView)
{
	gtk_tree_view_expand_all (GTK_TREE_VIEW (widget));
}

gboolean ContactView::on_group_treeview_button_press(GtkWidget *widget, GdkEventButton *event, ContactView *oContactView)
{
	return false;
}

gboolean ContactView::get_iter_from_name_helper(const gchar *name, GtkTreeIter *iter, GtkTreeIter *root) {

	do {
		ContactListNode *node;
		
		gtk_tree_model_get(GTK_TREE_MODEL(buddy_tree_model), root, COLUMN_NODE_DATA, &node, -1);
		if (node->name == name) {
			*iter = *root;
			return TRUE;
		}

		GtkTreeIter child;
		if (gtk_tree_model_iter_children(GTK_TREE_MODEL(buddy_tree_model), &child, root)) {
			if (get_iter_from_name_helper(name, iter,&child))
				return TRUE;
		}
	} while(gtk_tree_model_iter_next(GTK_TREE_MODEL(buddy_tree_model), root));

	return FALSE;
}

gboolean ContactView::get_iter_from_name(const gchar *name, GtkTreeIter *iter)
{
	GtkTreeIter root;
	if(!gtk_tree_model_get_iter_first(GTK_TREE_MODEL(buddy_tree_model), &root))
		return FALSE;
	return get_iter_from_name_helper(name, iter, &root);
}

void ContactView::loadContactList()
{
/*	if (get_iter_from_name(_("my friends"),&iter)) {		
		
		ContactListNode *node;
		node = new ContactListNode;
		node->type = CONTACT_LIST_NODE_BUDDY;
		node->name = name;
		node->status = STATUS_ONLINE;
	
		GtkTreeIter child_iter;
		gtk_tree_store_append (buddy_tree_model, &child_iter, &iter);
		gtk_tree_store_set (buddy_tree_model, &child_iter, COLUMN_HEAD_ICON, linqMain->skin->linq.face[1],COLUMN_NAME, name, COLUMN_NODE_DATA, node, -1);
	}*/
}

void ContactView::onUserOnline(const gchar *name)
{
	GtkTreeIter iter;
	if (get_iter_from_name(name,&iter)) {
	}
	else {
		if (get_iter_from_name(_("my friends"),&iter)) {		
		
			ContactListNode *node;
			node = new ContactListNode;
			node->type = CONTACT_LIST_NODE_BUDDY;
			node->name = name;
			node->status = STATUS_ONLINE;
	
			GtkTreeIter child_iter;
			gtk_tree_store_append (buddy_tree_model, &child_iter, &iter);
			gtk_tree_store_set (buddy_tree_model, &child_iter, COLUMN_HEAD_ICON, linqMain->skin->linq.face[1],COLUMN_NAME, name, COLUMN_NODE_DATA, node, -1);
		}
	}
}

void ContactView::onUserOffline(const gchar *name)
{
	GtkTreeIter iter;
	if (get_iter_from_name(name,&iter)) {		
		ContactListNode *node;
		gtk_tree_model_get(GTK_TREE_MODEL(buddy_tree_model), &iter, COLUMN_NODE_DATA, &node, -1);
		delete node;
		gtk_tree_store_remove(buddy_tree_model, &iter);
	}
}

void ContactView::onUserStatus(const char *name, uint32 status)
{
	
}

void ContactView::onContactInfoReply(CONTACT_INFO &c)
{
}
