#include "config.h"
#include "LoginDlg.h"
#include "LinqMain.h"
#include "LinqUsers.h"
#include "icqdb.h"
#include "sha.h"
#include "intl.h"

LoginDlg::LoginDlg() : LinqWindow(WIN_LOGIN)
{
	window = NULL;
}

LoginDlg::~LoginDlg()
{
	if (window)
		gtk_widget_destroy(window);
}

void LoginDlg::Show()
{
	if (window) {
		gtk_window_present(GTK_WINDOW(window));
		return;
	}
	
	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_container_set_border_width(GTK_CONTAINER(window),2);
	gtk_window_set_default_size (GTK_WINDOW(window), 100, 60);
	gtk_window_set_title(GTK_WINDOW(window),_("LinQ user login"));
	gtk_window_set_icon(GTK_WINDOW (window), linqMain->skin->linq.icon);
	gtk_window_set_position (GTK_WINDOW (window), GTK_WIN_POS_CENTER);
	g_signal_connect (G_OBJECT (window), "delete_event", G_CALLBACK (on_delete_event), this);
	
	GtkWidget *vbox;
	vbox = gtk_vbox_new(false,0);
	gtk_container_add(GTK_CONTAINER(window),vbox);
	GtkWidget *table;
	table = gtk_table_new(2, 2, false);
	gtk_box_pack_start(GTK_BOX(vbox),table,false,false,0);
	GtkWidget *label;
	label = gtk_label_new(_("user name:"));
	gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 0, 1);
	user_combo = gtk_combo_new();
	gtk_combo_disable_activate(GTK_COMBO(user_combo));	
	gtk_editable_set_editable(GTK_EDITABLE(GTK_COMBO(user_combo)->entry), false);
	
	gtk_table_attach_defaults(GTK_TABLE(table), user_combo, 1, 2, 0, 1);
	label = gtk_label_new(_("user password:"));
	gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 1, 2);
	passwd_entry = gtk_entry_new();
	gtk_entry_set_visibility(GTK_ENTRY(passwd_entry), false);
	g_signal_connect (G_OBJECT (passwd_entry), "activate", G_CALLBACK (on_login_clicked), this);
	gtk_table_attach_defaults(GTK_TABLE(table), passwd_entry, 1, 2, 1, 2);
	gtk_widget_grab_focus(passwd_entry);
	
	GtkWidget *hbox;
	hbox = gtk_hbox_new(false,0);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,false,false,0);
	savepasswd_ckbutton = gtk_check_button_new_with_label(_("save password"));
	gtk_box_pack_start(GTK_BOX(hbox),savepasswd_ckbutton, true, true,0);
	invislogin_ckbutton = gtk_check_button_new_with_label(_("login invisible"));
	gtk_box_pack_start(GTK_BOX(hbox),invislogin_ckbutton, true, true,0);
	
	//do this after passwd_entry is created.
	g_signal_connect (G_OBJECT (GTK_COMBO(user_combo)->entry), "changed", G_CALLBACK (on_user_entry_changed), this);
	
	std::list<std::string> user_list;
	LinqUsers::getAllUsers(user_list);

	GList *list = NULL;
	std::list<std::string>::iterator it;
	for (it = user_list.begin(); it != user_list.end(); ++it)
		list = g_list_append(list, g_strdup((*it).c_str()));
	gtk_combo_set_popdown_strings(GTK_COMBO(user_combo),list);
	
	g_list_foreach (list, (GFunc)g_free, NULL);
	g_list_free(list);
	
	
	GtkWidget *hseparator;
	hseparator = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(vbox),hseparator, false, false, 3);
	
	hbox = gtk_hbox_new(false,0);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,false,false,0);
	GtkWidget *button;
	button = gtk_button_new_with_label(_("Login"));
	g_signal_connect (G_OBJECT (button), "clicked", G_CALLBACK (on_login_clicked), this);
	gtk_box_pack_start(GTK_BOX(hbox),button,true,false,0);
	button = gtk_button_new_with_label(_("Cancel"));
	g_signal_connect (G_OBJECT (button), "clicked", G_CALLBACK (on_cancel_clicked), this);
	gtk_box_pack_start(GTK_BOX(hbox),button,true,false,0);
	button = gtk_button_new_with_label(_("Register wizard"));	
	g_signal_connect (G_OBJECT (button), "clicked", G_CALLBACK (on_register_clicked), this);
	gtk_box_pack_start(GTK_BOX(hbox),button,true,false,0);
	gtk_widget_show_all(window);
}

gboolean LoginDlg::on_delete_event(GtkWidget * window, GdkEvent *event , LoginDlg *oLoginDlg)
{
	delete oLoginDlg;
	linqMain->Quit();
	return true;
}

void LoginDlg::on_user_entry_changed(GtkEntry *entry, LoginDlg *oLoginDlg)
{
	const gchar *user;
	user = gtk_entry_get_text(GTK_ENTRY(entry));
	if (user[0]) {
		string str;
		linqMain->getUserDir(str, user);
		IcqDB::setDir(str.c_str());
		
		IcqDB::loadOptions(oLoginDlg->options);
		
		gtk_entry_set_text(GTK_ENTRY(oLoginDlg->passwd_entry), oLoginDlg->options.saved_passwd.c_str());
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(oLoginDlg->savepasswd_ckbutton), !(oLoginDlg->options.saved_passwd.empty()));
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(oLoginDlg->invislogin_ckbutton), (oLoginDlg->options.login_status == STATUS_INVIS));			
	}
}

void LoginDlg::on_login_clicked(GtkWidget *button, LoginDlg *oLoginDlg)
{
	const gchar *passwd;
	passwd = gtk_entry_get_text(GTK_ENTRY(oLoginDlg->passwd_entry));
	if (passwd[0] == '\0') {
		GtkWidget *dialog = gtk_message_dialog_new(GTK_WINDOW(oLoginDlg->window), GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, _("Please input the password!"));			
		g_signal_connect_swapped (GTK_OBJECT (dialog), "response", G_CALLBACK (gtk_widget_destroy), GTK_OBJECT (dialog));
		gtk_widget_show (dialog);
		return;
	}
	if (!oLoginDlg->options.passwd_hash.empty()) {
		char hash[41];
		char str[51];
		
		shahash_r(passwd, hash);
		snprintf(str, 51, "%slinq", hash);
		shahash_r(str, hash);
		if (oLoginDlg->options.passwd_hash != hash) {
			GtkWidget *dialog = gtk_message_dialog_new(GTK_WINDOW(oLoginDlg->window), GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_YES_NO, _("The password may be wrong, input again?"));
			gint result = gtk_dialog_run (GTK_DIALOG (dialog));
			gtk_widget_destroy (dialog);
			if (result == GTK_RESPONSE_YES)
				return;
		}
	}
	const gchar *user;
	user = gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(oLoginDlg->user_combo)->entry));
	gboolean save;
	save = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(oLoginDlg->savepasswd_ckbutton));
	uint32 status;
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(oLoginDlg->invislogin_ckbutton)))
		status = STATUS_INVIS;
	else
		status = STATUS_ONLINE;
	//need to check user and passwd....	
	
	gboolean changed = false;
	
	if (oLoginDlg->options.login_status != status) {
		oLoginDlg->options.login_status = status;
		changed = true;
	}
	if (oLoginDlg->options.saved_passwd.empty() == save) {
		if (save)
			oLoginDlg->options.saved_passwd = passwd;
		else
			oLoginDlg->options.saved_passwd = "";
		changed = true;
	}
	if (changed)
		IcqDB::saveOptions(oLoginDlg->options);
	linqMain->options = oLoginDlg->options;
	
	LinqUserInfo userInfo; //no use now, just do a test.
	if (!IcqDB::loadUserInfo(userInfo)) {
		GtkWidget *dialog = gtk_message_dialog_new(GTK_WINDOW(oLoginDlg->window), GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_YES_NO, _("The db currupted, use register ward to rebuild db?"));
		gint result = gtk_dialog_run (GTK_DIALOG (dialog));
		gtk_widget_destroy (dialog);
		if (result == GTK_RESPONSE_YES) {			
			linqMain->ShowRegWizard(user, passwd);
			delete oLoginDlg;
			return;
		}
	}

	linqMain->myInfo.name = user;
	linqMain->myInfo.passwd = passwd;
	linqMain->myInfo.login_status = status;	

	if (oLoginDlg->options.proxy_type == 0) {
		linqMain->setProxy(NULL);
	}
	else {
		PROXY_INFO proxy;
		if (oLoginDlg->options.proxy_type == 1)
			proxy.type = PROXY_SOCKS5;
		else
			proxy.type = PROXY_HTTPS;
		proxy.host = oLoginDlg->options.proxy_host;
		proxy.port = oLoginDlg->options.proxy_port;
		proxy.name = oLoginDlg->options.proxy_username;
		proxy.passwd = oLoginDlg->options.proxy_passwd;		
		proxy.resolve = oLoginDlg->options.proxy_resolve;		
	
		linqMain->setProxy(&proxy);
	}
	
	delete oLoginDlg;
	linqMain->ShowMainWin();
	linqMain->main_win->doLogin();
}

void LoginDlg::on_cancel_clicked(GtkWidget *button, LoginDlg *oLoginDlg)
{
	delete oLoginDlg;
	linqMain->Quit();
}

void LoginDlg::on_register_clicked(GtkWidget *button, LoginDlg *oLoginDlg)
{
	delete oLoginDlg;
	linqMain->ShowRegWizard();
}
