#include "LinqUsers.h"
#include <stdio.h>
#include <gtk/gtk.h>

using namespace std;

string LinqUsers::configDir;

void LinqUsers::getAllUsers(std::list<std::string> &l)
{
	string pathName = configDir + G_DIR_SEPARATOR_S"usrs.idx";
	FILE *file = fopen(pathName.c_str(), "r");	

	if (file) {
		string qid;	
		char line[128];
		while (fgets(line, sizeof(line), file)) {
			g_strstrip(line);
			qid = line;
			l.push_back(qid);
		}
		fclose(file);
	}	
}

void LinqUsers::addUser(string &newQID)
{
	std::list<std::string> l;
	bool isNew = true;
	string pathName = configDir + G_DIR_SEPARATOR_S"usrs.idx";
	FILE *file = fopen(pathName.c_str(), "r");

	if (file) {
		char line[128];
		string qid;
		while (fgets(line, sizeof(line), file)) {
			g_strstrip(line);
			qid = line;
			if (qid == newQID) {
				isNew = false;
				l.push_front(qid);
			} else
				l.push_back(qid);
		}
		fclose(file);
	}
	if (isNew)
		l.push_front(newQID);

	file = fopen(pathName.c_str(), "w");
	if (file) {
		std::list<std::string>::iterator it;
		for (it = l.begin(); it != l.end(); ++it)
			fprintf(file, "%s\n", (*it).c_str());
		fclose(file);
	}
}
