#ifndef __LINQ_MAIN_H__
#define __LINQ_MAIN_H__

#include "skin.h"
#include "LoginDlg.h"
#include "RegWizard.h"
#include "MainWin.h"
#include "UserInfoDlg.h"
#include "SendMsgDlg.h"
#include "SearchDlg.h"
#include "LinqInfo.h"

#include "icqmain.h"

#include <gtk/gtk.h>

class LinqUser{
public:
	LinqUser();
	
	std::string name;
	std::string passwd;
	uint32 login_status;
	uint32 now_status;
};

class LinqMain   : public ICQMain {
public:	
	Skin *skin;
	LinqMain(SocketRegistry *reg);
	~LinqMain();

	void getUserDir(std::string &userdir, const gchar *user);
	void doLogin();
	void Quit();	

	void ShowLoginDlg();
	void ShowRegWizard(const gchar *user = NULL, const gchar *passwd = NULL);
	void ShowSearchDlg();
	void ShowMainWin();

	virtual const char *getUserName();
	virtual TCPSessionListener *getSessionListener(const char *type, TCPSessionBase *session);
	virtual bool getContactInfo(ONLINE_INFO &info);

	virtual void onAck(uint32 seq);
	virtual void onSendError(uint16 seq);
	virtual void onConnect(bool connected);

	virtual void onRegisterReply(uint8 error);
	virtual void onPreLoginReply(uint16 sequence, const char *token);
	virtual void onLoginReply(uint8 error);
	virtual void onAddContactReply(const char *name, uint8 auth);
	virtual void onContactListReply(const char *list[], int n);

	virtual void onUserOnline(ONLINE_INFO &info);
	virtual void onUserOffline(const char *name);
	virtual void onUserStatus(const char *name, uint32 status);
	virtual void onSearchResult(SEARCH_RESULT result[], int n);
	virtual void onRecvMessage(uint8 type, const char *from, time_t when, const char *text);

	virtual void onContactInfoReply(CONTACT_INFO &c);
	virtual void onUserInfoReply(USER_INFO &user);
	virtual void onPreChangePasswordReply(uint16 sequence, const char *token);

	LinqWindow *findWindow(int type);
	
	std::list<LinqWindow *> windowList;
	
	LinqUser myInfo;
	LinqOption options;
	MainWin *main_win;
private:
	std::list<LinqOnlineInfo> onlineInfoList;
	LinqOnlineInfo *findOnlineInfo(const char *name);

	gint send_keepalive_timeout;
	static gboolean send_keepalive_cb(gpointer data);
	
	gint check_send_queue_timeout;
	static gboolean check_send_queue_cb(gpointer data);

	void logLine(const char *fmt, ...);

	void destroyUser();

};

extern LinqMain *linqMain;

extern const char *status2text(uint32 status);

#endif
