/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   copyright            : (C) 2003 by Zhang Yong                         *
 *   email                : z-yong163@163.com                              *
 ***************************************************************************/

#ifndef _ICQ_PACKET_H
#define _ICQ_PACKET_H

#include "packet.h"
#include <time.h>

#define MAX_PACKET_SIZE		1024


class ICQOutPacket : public OutPacket {
public:
	ICQOutPacket();

	void reset() { cursor = data; }
	int getBytesAvailable() { return (MAX_PACKET_SIZE - getSize()); }

	virtual OutPacket &operator <<(uint8 b);
	virtual OutPacket &operator <<(uint16 w);
	virtual OutPacket &operator <<(uint32 dw);
	virtual OutPacket &operator <<(const char *str);
	virtual void writeData(const char *data, int n);

	const char *getData() { return data; }
	int getSize() { return (cursor - data); }

	char data[MAX_PACKET_SIZE];

private:
	char *cursor;
};


class ICQInPacket : public InPacket {
public:
	ICQInPacket(const char *data, int n);

	virtual InPacket &operator >>(uint8 &b);
	virtual InPacket &operator >>(uint16 &w);
	virtual InPacket &operator >>(uint32 &dw);
	virtual InPacket &operator >>(const char *&str);
	virtual const char *readData(int &n);

	int getBytesAvailable() {
		return (length - (cursor - data));
	}

private:
	const char *data;
	const char *cursor;
	int length;
};


#endif
