#ifndef _DEFAULT_SOCKET_REGISTRY_H
#define _DEFAULT_SOCKET_REGISTRY_H

#pragma warning(disable:4786)


#include "socketregistry.h"
#include <map>

using namespace std;


struct FD_ENTRY {
	int events;
	SocketListener *listener;
};


class DefaultSocketRegistry : public SocketRegistry {
public:
	DefaultSocketRegistry(int msecs);
	~DefaultSocketRegistry();

	virtual void add(int fd, SocketListener *l);
	virtual void remove(int fd);
	virtual void selectEvent(int fd, int event);

	bool poll();

private:
	map<int, FD_ENTRY *> socketMap;
	timeval timeout;
};


#endif
