#include "config.h"

#ifndef _WIN32
#include <unistd.h>
#else
#include <winsock.h>
#include <io.h>
#endif


#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <stdio.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <ctype.h>
#ifndef _WIN32
#include <netdb.h>
#endif
#include "gaim.h"
#include "prpl.h"
#include "proxy.h"

#ifdef _WIN32
#include "win32dep.h"
#include "stdint.h"
#endif

#include "myicq.h"
#include "ndes.h"
#include "infodlg.h"
#include "searchdlg.h"

static struct prpl *my_protocol = NULL;

/* for win32 compatability */
G_MODULE_IMPORT GSList *connections;

	static char * facefilebasename[]={
		"myicq_face_1-1","myicq_face_1-2","myicq_face_1-3","myicq_face_2-1","myicq_face_2-2","myicq_face_2-3","myicq_face_3-1","myicq_face_3-2","myicq_face_3-3",
		"myicq_face_4-1","myicq_face_4-2","myicq_face_4-3","myicq_face_5-1","myicq_face_5-2","myicq_face_5-3","myicq_face_6-1","myicq_face_6-2","myicq_face_6-3",
		"myicq_face_7-1","myicq_face_7-2","myicq_face_7-3","myicq_face_8-1","myicq_face_8-2","myicq_face_8-3","myicq_face_9-1","myicq_face_9-2","myicq_face_9-3",
		"myicq_face_10-1","myicq_face_10-2","myicq_face_10-3","myicq_face_11-1","myicq_face_11-2","myicq_face_11-3","myicq_face_12-1","myicq_face_12-2","myicq_face_12-3",
		"myicq_face_13-1","myicq_face_13-2","myicq_face_13-3","myicq_face_14-1","myicq_face_14-2","myicq_face_14-3","myicq_face_15-1","myicq_face_15-2","myicq_face_15-3",
		"myicq_face_16-1","myicq_face_16-2","myicq_face_16-3","myicq_face_17-1","myicq_face_17-2","myicq_face_17-3","myicq_face_18-1","myicq_face_18-2","myicq_face_18-3",
		"myicq_face_19-1","myicq_face_19-2","myicq_face_19-3",
		"myicq_face_20-1","myicq_face_20-2","myicq_face_20-3","myicq_face_21-1","myicq_face_21-2","myicq_face_21-3","myicq_face_22-1","myicq_face_22-2","myicq_face_22-3",
		"myicq_face_23-1","myicq_face_23-2","myicq_face_23-3","myicq_face_24-1","myicq_face_24-2","myicq_face_24-3","myicq_face_25-1","myicq_face_25-2","myicq_face_25-3",
		"myicq_face_26-1","myicq_face_26-2","myicq_face_26-3","myicq_face_27-1","myicq_face_27-2","myicq_face_27-3",
		"myicq_face_28-1","myicq_face_28-2","myicq_face_28-3","myicq_face_29-1","myicq_face_29-2","myicq_face_29-3",
		"myicq_face_30-1","myicq_face_30-2","myicq_face_30-3","myicq_face_31-1","myicq_face_31-2","myicq_face_31-3","myicq_face_32-1","myicq_face_32-2","myicq_face_32-3",
		"myicq_face_33-1","myicq_face_33-2","myicq_face_33-3","myicq_face_34-1","myicq_face_34-2","myicq_face_34-3","myicq_face_35-1","myicq_face_35-2","myicq_face_35-3",
		"myicq_face_36-1","myicq_face_36-2","myicq_face_36-3","myicq_face_37-1","myicq_face_37-2","myicq_face_37-3","myicq_face_38-1","myicq_face_38-2","myicq_face_38-3",
		"myicq_face_39-1","myicq_face_39-2","myicq_face_39-3",
		"myicq_face_40-1","myicq_face_40-2","myicq_face_40-3","myicq_face_41-1","myicq_face_41-2","myicq_face_41-3","myicq_face_42-1","myicq_face_42-2","myicq_face_42-3",
		"myicq_face_43-1","myicq_face_43-2","myicq_face_43-3","myicq_face_44-1","myicq_face_44-2","myicq_face_44-3","myicq_face_45-1","myicq_face_45-2","myicq_face_45-3",
		"myicq_face_46-1","myicq_face_46-2","myicq_face_46-3","myicq_face_47-1","myicq_face_47-2","myicq_face_47-3",
		"myicq_face_48-1","myicq_face_48-2","myicq_face_48-3","myicq_face_49-1","myicq_face_49-2","myicq_face_49-3",
		"myicq_face_50-1","myicq_face_50-2","myicq_face_50-3","myicq_face_51-1","myicq_face_51-2","myicq_face_51-3","myicq_face_52-1","myicq_face_52-2","myicq_face_52-3",
		"myicq_face_53-1","myicq_face_53-2","myicq_face_53-3","myicq_face_54-1","myicq_face_54-2","myicq_face_54-3","myicq_face_55-1","myicq_face_55-2","myicq_face_55-3",
		"myicq_face_56-1","myicq_face_56-2","myicq_face_56-3","myicq_face_57-1","myicq_face_57-2","myicq_face_57-3",
		"myicq_face_58-1","myicq_face_58-2","myicq_face_58-3","myicq_face_59-1","myicq_face_59-2","myicq_face_59-3",
		"myicq_face_60-1","myicq_face_60-2","myicq_face_60-3","myicq_face_61-1","myicq_face_61-2","myicq_face_61-3","myicq_face_62-1","myicq_face_62-2","myicq_face_62-3",
		"myicq_face_63-1","myicq_face_63-2","myicq_face_63-3","myicq_face_64-1","myicq_face_64-2","myicq_face_64-3","myicq_face_65-1","myicq_face_65-2","myicq_face_65-3",
		"myicq_face_66-1","myicq_face_66-2","myicq_face_66-3","myicq_face_67-1","myicq_face_67-2","myicq_face_67-3",
		"myicq_face_68-1","myicq_face_68-2","myicq_face_68-3","myicq_face_69-1","myicq_face_69-2","myicq_face_69-3",
		"myicq_face_70-1","myicq_face_70-2","myicq_face_70-3","myicq_face_71-1","myicq_face_71-2","myicq_face_71-3","myicq_face_72-1","myicq_face_72-2","myicq_face_72-3",
		"myicq_face_73-1","myicq_face_73-2","myicq_face_73-3","myicq_face_74-1","myicq_face_74-2","myicq_face_74-3","myicq_face_75-1","myicq_face_75-2","myicq_face_75-3",
		"myicq_face_76-1","myicq_face_76-2","myicq_face_76-3","myicq_face_77-1","myicq_face_77-2","myicq_face_77-3",
		"myicq_face_78-1","myicq_face_78-2","myicq_face_78-3","myicq_face_79-1","myicq_face_79-2","myicq_face_79-3",
		"myicq_face_80-1","myicq_face_80-2","myicq_face_80-3","myicq_face_81-1","myicq_face_81-2","myicq_face_81-3","myicq_face_82-1","myicq_face_82-2","myicq_face_82-3",
		"myicq_face_83-1","myicq_face_83-2","myicq_face_83-3","myicq_face_84-1","myicq_face_84-2","myicq_face_84-3","myicq_face_85-1","myicq_face_85-2","myicq_face_85-3",
		};


#define MAX_PACKET_SIZE	4096

enum {
	STATUS_ONLINE,
	STATUS_OFFLINE,
	STATUS_AWAY,
	STATUS_INVIS,
	NR_STATUS
};


#define USEROPT_MYICQSERVER 3
#define MYICQ_SERVER "myicq.cosoft.org.cn"
//#define MYICQ_SERVER "www.linuxfans.org"
#define USEROPT_MYICQPORT 4
#define MYICQ_PORT 8000
#define USEROPT_MYICQINVISLOGIN 5
#define MYICQ_INVISLOGIN "0"



// Sent back from server after a UDP_LOGIN request
enum {
	LOGIN_SUCCESS,
	LOGIN_INVALID_UIN,
	LOGIN_WRONG_PASSWD,
};

enum {
	GROUP_ERROR_SUCCESS,
	GROUP_ERROR_NOT_EXIST,
	GROUP_ERROR_ALREADY_EXIST,
	GROUP_ERROR_EXCEED_MAX_GROUPS,
	GROUP_ERROR_WRONG_PASSWD,
	GROUP_ERROR_EXCEED_MAX_MEMBERS,
};

// Sent back from server after a UDP_ADD_CONTACT request
enum {
	ADD_FRIEND_ACCEPTED,
	ADD_FRIEND_AUTH_REQ,
	ADD_FRIEND_REJECTED,
};

// Protocol commands
enum {
	UDP_ACK = 1,
	UDP_NEW_UIN,
	UDP_GET_CONTACTLIST,
	UDP_LOGIN,
	UDP_LOGOUT,
	UDP_KEEPALIVE,
	UDP_CHANGE_STATUS,
	UDP_UPDATE_CONTACT,
	UDP_MODIFY_USER,
	UDP_UPDATE_USER,
	UDP_SEND_MSG,
	UDP_SEARCH_RANDOM,
	UDP_SEARCH_CUSTOM,
	UDP_ADD_FRIEND,
	UDP_DEL_FRIEND,
	UDP_BROADCAST_MSG,
	UDP_GET_SERVER_LIST,
	UDP_GET_GROUP_LIST,
	UDP_SEARCH_GROUP,
	UDP_GET_REMOTE_CONTACTLIST,

	UDP_CREATE_GROUP = 0x80,
	UDP_ENTER_GROUP,
	UDP_EXIT_GROUP,
	UDP_GROUP_START,
	UDP_GROUP_MESSAGE,
	UDP_GROUP_CMD,

	UDP_SRV_USER_ONLINE = 0x0100,
	UDP_SRV_USER_OFFLINE,
	UDP_SRV_MULTI_ONLINE,
	UDP_SRV_STATUS_CHANGED,
	UDP_SRV_MESSAGE,
	UDP_SRV_SEARCH,

	UDP_SRV_GROUP_TYPES = 0x1000,
	UDP_SRV_ENTER_GROUP,
	UDP_SRV_EXIT_GROUP,
};

#define MYICQ_UDP_VER			1
// The client's TCP protocol version
#define MYICQ_TCP_VER		1

// Default HTTPS port that almost all http proxies should open, I think:-)
#define	MYICQ_HTTP_PORT		443

#define MAX_SEND_ATTEMPTS		2

#define TCP_PACKET_SIZE	4096
#define TCP_HELLO		1

#define MAX_MSG_LEN			450
#define MAX_TEXT_SIZE	1024

#define TEXT_STREAM_SEP		0xff

// Message flags
#define MF_RECEIVED			0x01
#define MF_RELAY			0x02

// Message format flags
#define MFF_BOLD			0x01
#define MFF_ITALIC			0x02
#define MFF_UNDERLINE		0x04

enum {
	TCP_FILE_INFO = 0x1000,
	TCP_FILE_RECEIVE,
	TCP_FILE_DATA,
};

enum {
	TCP_MSG_MESSAGE = 0x1000,
	TCP_MSG_MESSAGE_ACK,
};

#pragma pack(1)
// use #pragma pack(1) to make sure: sizeof(str struct UDP_CLI_HDR)==20,not 24 !!!!
struct UDP_CLI_HDR {
	uint16 ver;
	uint32 reserved;
	uint32 uin;
	uint32 sid;
	uint16 cmd;
	uint16 seq;
	uint16 cc;		// check code
};

struct UDP_SRV_HDR {
	uint16 ver;
	uint32 reserved;
	uint32 uin;
	uint32 sid;
	uint16 cmd;
	uint16 seq;
	uint16 ackseq;
};

struct TCP_HEADER {
	uint16 ver;
	uint32 reserved;
	uint16 cmd;
	uint32 uin;
	uint8 face;
};
#pragma pack()


struct sendpacket {
	int sendseq;
	int type;
	time_t sendtime;
	int resend_times;
	int fd;
	char *buf;
	int len;
};

struct tcpmsgpacket {
	uint32 id;
	uint8 type;
	uint32 to_uin;
	gchar *to_uin_domain;
	time_t sendtime;
	char *message;
};

struct _gc_and_qid
{
	uint32 uin;
	gchar *domain;
	struct gaim_connection *gc;
};

GdkPixbuf * get_face_gdkpixbuf(int i)
{
	int a = (i/3)+1;
	int b = (i%3)+1;
	char *image = g_strdup_printf("myicq_face_%d-%d.png", a,b);
	gchar *filename = g_build_filename(DATADIR, "pixmaps", "gaim", "status", "default", image, NULL);
	g_free(image);
	GdkPixbuf *pixbuf = gdk_pixbuf_new_from_file(filename,NULL);
	g_free(filename);
	return pixbuf;
}

static int myicq_write(int fd, void *data, int len,struct gaim_connection *gc)
{
	struct myicq_data *md = gc->proto_data;
	char buf[MAX_PACKET_SIZE + 256];
	char *p = buf;
	struct gaim_proxy_info *gpi = gc->account->gpi;

	if(!gpi)
		gpi = &global_proxy_info;
		
	if (gpi->proxytype == PROXY_NONE)
	{
	}
	else if (gpi->proxytype == PROXY_HTTP)
	{
		*(uint16 *) p = htons(len);
		p += sizeof(uint16);
	}
	else if (gpi->proxytype == PROXY_SOCKS5)
	{
		uint8 hostlen;
		*(uint16 *) p = 0;
		p += sizeof(uint16);
		*p++ = 0;
		// Domain name
		*p++ = 3;
		hostlen = strlen(md->myicq_server_host);
		*p++ = hostlen;
		memcpy(p, md->myicq_server_host, hostlen);
		p += hostlen;
		
		*(uint16 *) p = htons(md->myicq_server_port);
		p += sizeof(uint16);
	}
	
	memcpy(p, data, len);
	p += len;

	return send(fd, buf, p - buf, 0);
}

static char* myicq_msg_text_encode(const char *str)
{
	char text[MAX_TEXT_SIZE];
	int len;
	char miscinfo[]= "\xFF" "" "\xFF" "9" "\xFF" "0" "\xFF" "0"; // information of font type,font size,font color,background color.here is the default values.
	
	if ((!str)||(str[0]=='\0'))
		return g_strdup("");	
	
	len = strlen(str);
	if (len > (sizeof(text) -sizeof(miscinfo)))
		len = (sizeof(text) -sizeof(miscinfo));
	
	memcpy(text, str, len);
	memcpy(text+len, miscinfo, sizeof(miscinfo));
	
	return g_strdup(text);
}

static char* myicq_msg_text_decode(const char *text)
{
	char *b;
	
	if ((!text)||(text[0]=='\0'))
		return g_strdup("");
	b = strchr(text,TEXT_STREAM_SEP);
	if (b)
	{
		return g_locale_to_utf8(text, b-text, NULL,NULL,NULL);
	}
	else
	{
		return g_locale_to_utf8(text, -1, NULL,NULL,NULL);
	}
}

static void myicq_create_packet_b(char *buf,char **cursor,uint8 b)
{
	if (*cursor <= buf + MAX_PACKET_SIZE - sizeof(uint8)) {
		** (uint8 **) cursor = b;
		*cursor += sizeof(uint8);
	}
}

static void myicq_create_packet_w(char *buf,char **cursor,uint16 w)
{
	if (*cursor <= buf + MAX_PACKET_SIZE - sizeof(uint16)) {
		** (uint16 **) cursor = htons(w);
		*cursor += sizeof(uint16);
	}
}

static void myicq_create_packet_dw(char *buf,char **cursor,uint32 dw)
{
	if (*cursor <= buf + MAX_PACKET_SIZE - sizeof(uint32)) {
		** (uint32 **) cursor = htonl(dw);
		*cursor += sizeof(uint32);
	}
}

static void myicq_create_packet_str(char *buf,char **cursor,const char *str)
{
	if (str)
	{
		uint16 len = strlen(str) + 1;
		if (*cursor <= buf + MAX_PACKET_SIZE - sizeof(uint16) - len) {
			myicq_create_packet_w(buf,cursor,len);
			strcpy(*cursor, str);
			*cursor += len;
		}
	}
}

static void myicq_create_packet_data(char *buf,char **cursor,const char *data,int datalen)
{
	if (*cursor <= buf + MAX_PACKET_SIZE - datalen) {
		memcpy(*cursor, data, datalen);
		*cursor += datalen;
	}
}

static void myicq_create_tcp_packet_head(char *buf, char **cursor, struct myicq_data *md, uint16 cmd)
{
	*cursor=buf+sizeof(uint16);	// serverve for tcp packet 's len.
	myicq_create_packet_w(buf,cursor, (uint16)MYICQ_TCP_VER); //version	
	myicq_create_packet_dw(buf,cursor,(uint32)0); //reserved
	myicq_create_packet_w(buf,cursor, cmd); //cmd
	myicq_create_packet_dw(buf,cursor,md->myuin); //uin
	myicq_create_packet_b(buf,cursor, md->face); //face.
}

static void myicq_create_packet_head_seq(char *buf, char **cursor, struct myicq_data *md, uint16 cmd, uint16 seq)
{
	*cursor=buf;	
	myicq_create_packet_w(buf,cursor, (uint16)MYICQ_UDP_VER); //version	
	myicq_create_packet_dw(buf,cursor,(uint32)0); //reserved
	myicq_create_packet_dw(buf,cursor,md->myuin); //uin
	myicq_create_packet_dw(buf,cursor,md->sid); //sid
	myicq_create_packet_w(buf,cursor, cmd); //cmd
	myicq_create_packet_w(buf,cursor, seq); //seq
	myicq_create_packet_w(buf,cursor, (uint16)0); //cc, Checkcode will be calculated later	
}

static void myicq_create_packet_head(char *buf, char **cursor, struct gaim_connection *gc, uint16 cmd)
{
	struct myicq_data *md = gc->proto_data;
	myicq_create_packet_head_seq(buf, cursor, md, cmd, ++(md->sendSeq));
}

static void myicq_packet_encrypt(char *buf,char **cursor, char *subkey)
{
	int n;
	uint8 i;
	uint8 v;
	uint16 cc;
	char *p = buf + sizeof(struct UDP_CLI_HDR);
	n = *cursor - p;
	if (n <= 0)
		return;
	// Check code
	i = (rand() & 0xff) % n;
	v = p[i];
	cc = ((i << 8) | v);
	((struct UDP_CLI_HDR *) buf)->cc = htons(cc);
	while (n > 0) {
		if (n < 8) {
			int d = 8 - n;
			memset(p + n, 0, d);
			*cursor += d;
		}
		endes(p,subkey);

		p += 8;
		n -= 8;
	}
}

static void myicq_send_packet_ack(uint16 seq, struct gaim_connection *gc)
{
	struct myicq_data *md = gc->proto_data;
	char buf[MAX_PACKET_SIZE];
	char *cursor;
	
	myicq_create_packet_head_seq(buf, &cursor, md, (uint16)UDP_ACK, seq);
	myicq_write(md->fd,buf,cursor-buf,gc);	
}

static int
myicq_send(int connsock, char *buf,int len)
{
	*((uint16 *) buf) = htons(len - sizeof(uint16)); //here len is not the real data len.
	return (send(connsock, buf, len, 0));
}

static int
myicq_tcp_file_send(struct myicq_tcpfileconnection *mtfc, char *buf,int len) //this func only add data to send queue.
{
	if ((buf==NULL) || (len ==0)) //send buffer.
	{
		if (mtfc->sendqueue)
			return send(mtfc->connsock, mtfc->sendqueue, mtfc->sendlen, 0);
		else
			return 0;
	}
		
	*((uint16 *) buf) = htons(len - sizeof(uint16));  //here len is not the real data len.
	mtfc->sendqueue = g_realloc(mtfc->sendqueue, len + mtfc->sendlen);
	memcpy(mtfc->sendqueue + mtfc->sendlen, buf, len);
	mtfc->sendlen += len;
	
	int sendlen;
	char *queue;
	sendlen = send(mtfc->connsock, mtfc->sendqueue, mtfc->sendlen, 0);
	if (sendlen <= 0)
	{
		return sendlen;
	}
	queue = mtfc->sendqueue;
	mtfc->sendlen = mtfc->sendlen - sendlen;
	if (mtfc->sendlen>0)
	{
		mtfc->sendqueue = g_memdup(mtfc->sendqueue+sendlen,	mtfc->sendlen);
	}
	else
	{
		mtfc->sendqueue = NULL;
	}			
	g_free(queue);

	return sendlen;
}

char *
myicq_get_type_str(int type)
{
	switch (type)
	{
	case UDP_ACK:
		return "UDP_ACK";
	case UDP_NEW_UIN:
		return "UDP_NEW_UIN";
	case UDP_GET_CONTACTLIST:
		return "UDP_GET_CONTACTLIST";
	case UDP_LOGIN:
		return "UDP_LOGIN";
	case UDP_LOGOUT:
		return "UDP_LOGOUT";
	case UDP_KEEPALIVE:
		return "UDP_KEEPALIVE";
	case UDP_CHANGE_STATUS:
		return "UDP_CHANGE_STATUS";
	case UDP_UPDATE_CONTACT:
		return "UDP_UPDATE_CONTACT";
	case UDP_MODIFY_USER:
		return "UDP_MODIFY_USER";
	case UDP_UPDATE_USER:
		return "UDP_UPDATE_USER";
	case UDP_SEND_MSG:
		return "UDP_SEND_MSG";
	case UDP_SEARCH_RANDOM:
		return "UDP_SEARCH_RANDOM";
	case UDP_SEARCH_CUSTOM:
		return "UDP_SEARCH_CUSTOM";
	case UDP_ADD_FRIEND:
		return "UDP_ADD_FRIEND";
	case UDP_DEL_FRIEND:
		return "UDP_DEL_FRIEND";
	case UDP_BROADCAST_MSG:
		return "UDP_BROADCAST_MSG";
	case UDP_GET_SERVER_LIST:
		return "UDP_GET_SERVER_LIST";
	case UDP_GET_GROUP_LIST:
		return "UDP_GET_GROUP_LIST";
	case UDP_SEARCH_GROUP:
		return "UDP_SEARCH_GROUP";
	case UDP_GET_REMOTE_CONTACTLIST:
		return "UDP_GET_REMOTE_CONTACTLIST";
	case UDP_CREATE_GROUP:
		return "UDP_CREATE_GROUP";
	case UDP_ENTER_GROUP:
		return "UDP_ENTER_GROUP";
	case UDP_EXIT_GROUP:
		return "UDP_EXIT_GROUP";
	case UDP_GROUP_START:
		return "UDP_GROUP_START";
	case UDP_GROUP_MESSAGE:
		return "UDP_GROUP_MESSAGE";
	case UDP_GROUP_CMD:
		return "UDP_GROUP_CMD";
	case UDP_SRV_USER_ONLINE:
		return "UDP_SRV_USER_ONLINE";
	case UDP_SRV_USER_OFFLINE:
		return "UDP_SRV_USER_OFFLINE";
	case UDP_SRV_MULTI_ONLINE:
		return "UDP_SRV_MULTI_ONLINE";
	case UDP_SRV_STATUS_CHANGED:
		return "UDP_SRV_STATUS_CHANGED";
	case UDP_SRV_MESSAGE:
		return "UDP_SRV_MESSAGE";
	case UDP_SRV_SEARCH:
		return "UDP_SRV_SEARCH";
	case UDP_SRV_GROUP_TYPES:
		return "UDP_SRV_GROUP_TYPES";
	case UDP_SRV_ENTER_GROUP:
		return "UDP_SRV_ENTER_GROUP";
	case UDP_SRV_EXIT_GROUP:
		return "UDP_SRV_EXIT_GROUP";
	default:
		return "UNKNOW_TYPE!";
	}
}

static void
myicq_send_packet(struct gaim_connection *gc, char *buf,int len,int type) //add to queue after write
{
	struct myicq_data *md = gc->proto_data;
	struct sendpacket *packet;
		
	debug_printf("MyICQ: send %u %s\n", md->sendSeq, myicq_get_type_str(type));

	myicq_write(md->fd,buf,len,gc);
	
	packet=g_new(struct sendpacket, 1);
	
	packet->sendseq=md->sendSeq;
	packet->type=type;
	packet->sendtime=time(NULL);
	packet->resend_times=0;
	packet->fd=md->fd;
	packet->buf=g_memdup(buf,len); //don't use g_strdup :)
	packet->len=len;
	
	md->sendqueue = g_list_append (md->sendqueue, packet);
}

struct _gc_and_packet
{
	struct gaim_connection *gc;
	struct sendpacket *packet;
};

static void myicq_send_again(struct _gc_and_packet *gp)
{
	struct myicq_data *md = gp->gc->proto_data;
	GList *list;

	list = g_list_find(md->sendqueue,gp->packet); //packet may have already be free if received a ack packet while the dialog is showing.
	if (list)
	{
		myicq_write(gp->packet->fd,gp->packet->buf,gp->packet->len,gp->gc);
		gp->packet->resend_times=0;
		gp->packet->sendtime = time(NULL);
	}
	g_free(gp);
}

static int myicq_sendqueue_remove(struct myicq_data *md, int sendseq);

static void myicq_send_cancel(struct _gc_and_packet *gp)
{
	struct myicq_data *md = gp->gc->proto_data;
	GList *list;

	list = g_list_find(md->sendqueue,gp->packet);
	if (list)
	{
		myicq_sendqueue_remove(md, gp->packet->sendseq);
	}
	g_free(gp);
}

static gint
myicq_sendqueue_timeout_callback(gpointer data)
{
	struct gaim_connection *gc= (struct gaim_connection *)data;
	struct myicq_data *md = gc->proto_data;
	struct gaim_proxy_info *gpi = gc->account->gpi;
		
	GList *list;	
	struct sendpacket *packet;
	time_t nowtime;
	char msg[256];

	if (!md->sendqueue)
		return 1; //needn't run time(NULL);

	if(!gpi)
		gpi = &global_proxy_info;

	nowtime= time(NULL);
		
	list=md->sendqueue;
	while (list) //remove all packet whose resend_times==-1
	{
		packet= (struct sendpacket *)(list->data);
		if (packet->resend_times==-1) //to remove
		{
			g_free(packet->buf);
			g_free(list->data);
			md->sendqueue=g_list_remove(md->sendqueue,list->data);
			list=md->sendqueue;
		}
		else
		{
			list=list->next;
		}
	}

	list=md->sendqueue;
	while (list)
	{
		packet= (struct sendpacket *)(list->data);
		if (packet->resend_times>=3)
		{
			if (packet->resend_times==3)
			{
				if (packet->type==UDP_KEEPALIVE)
				{
					if (md->online)
					{
						sprintf(msg,_("To %s :\nUDP_KEEPALIVE packet have send for 3 times!\nYour network may blocked!"),gc->username);
						do_error_dialog(_("You are offline!"), msg, GAIM_WARNING);
						md->online= FALSE;
					}
					packet->resend_times=-1; //will be remove. if remove now,it will broken list 's struct.
				}
				else if (packet->type==UDP_LOGIN)
				{
					if (!md->logged_in) //cancel logging progress.
					{
						hide_login_progress(gc, _("UDP_LOGIN packet already send for 3 times.but no reply!"));
						signoff(gc);
						return 1;  //don't forget this.or it make segment fault as execute "list=list->next;" later.
					}
					else
					{
						//this should never happen.
					}
				}
				else
				{	
					struct _gc_and_packet *gp;
					gp = g_new(struct _gc_and_packet, 1);
					gp->gc = gc;
					gp->packet = packet;
					sprintf(msg,_("Packet %d %s have already send for 3 times."),packet->sendseq,myicq_get_type_str(packet->type));
					do_ask_dialog(msg, _("Send again?"), gp, _("Send"),myicq_send_again, _("Cancel"), myicq_send_cancel, my_protocol->plug ? my_protocol->plug->handle : NULL, FALSE);
					packet->resend_times++; //will not send again util set resend_times to 0.
				}
			}
		}
		else
		{
			int wait_time;
			if (gpi->proxytype == PROXY_NONE)
				wait_time = 5;
			else
				wait_time = 10;
			if (difftime(nowtime,packet->sendtime) >= (wait_time * (packet->resend_times+1)))
			{
				myicq_write(packet->fd,packet->buf,packet->len,gc);
				packet->resend_times++;
				debug_printf("MyICQ: packet %d send again for %d time!!!!\n", packet->sendseq, packet->resend_times);
			}
		}
		list=list->next;
	}
	return 1;
}

static gint
myicq_tcpmsgsendqueue_timeout_callback(gpointer data)
{
	struct gaim_connection *gc= (struct gaim_connection *)data;
	struct myicq_data *md = gc->proto_data;
		
	GList *list;	
	struct tcpmsgpacket *packet;
	time_t nowtime;

	
	if (!md->tcpmsgsendqueue)
		return 1; //needn't run time(NULL);

	nowtime= time(NULL);
	
	list=md->tcpmsgsendqueue;
	while (list)
	{
		packet= (struct tcpmsgpacket *)(list->data);
		if (difftime(nowtime,packet->sendtime) >= 5) //when a tcp packet send after 5 second,but get no ACK,then send it to server.
		{
			debug_printf("MyICQ: tcp packet %lu to user %lu didn't get ACK,send to server!\n",packet->id,packet->to_uin);
			myicq_send_packet_msg(packet->type,packet->to_uin, packet->to_uin_domain, packet->message,gc);
			g_free(packet->to_uin_domain);
			g_free(packet->message);
			g_free(packet);
			md->tcpmsgsendqueue = g_list_remove(md->tcpmsgsendqueue,packet);
			list = md->tcpmsgsendqueue;
		}
		else
		{
			list = list->next;
		}
	}
	return 1;
}

static int
myicq_sendqueue_remove(struct myicq_data *md, int sendseq)
{
	GList *list=md->sendqueue;
	struct sendpacket *packet;
	while (list)
	{
		packet= (struct sendpacket *)(list->data);
		if (packet->sendseq==sendseq)
		{
			g_free(packet->buf);
			g_free(list->data);
			md->sendqueue=g_list_remove(md->sendqueue,list->data);
			return 1;
		}
		list=list->next;
	}
	return 0;
}

static void
myicq_sendqueue_free(struct myicq_data *md)
{
	struct sendpacket *packet;
	int i=0;
	while (md->sendqueue)
	{
		i++;
		packet= (struct sendpacket *)(md->sendqueue->data);
		g_free(packet->buf);
		g_free(md->sendqueue->data);
		md->sendqueue=g_list_remove(md->sendqueue,md->sendqueue->data);
	}
	debug_printf("MyICQ: %d udp packet left in sendqueue,freed!\n",i);
}

static int
myicq_tcpmsgsendqueue_remove(struct myicq_data *md, uint32 id, uint32 uin, gchar *domain)
{
	GList *list=md->tcpmsgsendqueue;
	struct tcpmsgpacket *packet;
	while (list)
	{
		packet= (struct tcpmsgpacket *)(list->data);
		if (packet->id==id && packet->to_uin==uin && (!strcasecmp(packet->to_uin_domain,domain))) //the different uin may have send the packets which have the same id.
		{
			g_free(packet->to_uin_domain);
			g_free(packet->message);
			g_free(packet);
			md->tcpmsgsendqueue=g_list_remove(md->tcpmsgsendqueue,packet);
			return 1;
		}
		list=list->next;
	}
	return 0;
}

static void
myicq_tcpmsgsendqueue_free(struct myicq_data *md)
{
	struct tcpmsgpacket *packet;
	int i=0;
	while (md->tcpmsgsendqueue)
	{
		i++;
		packet= (struct tcpmsgpacket *)(md->tcpmsgsendqueue->data);
		g_free(packet->to_uin_domain);
		g_free(packet->message);
		g_free(packet);
		md->tcpmsgsendqueue=g_list_remove(md->tcpmsgsendqueue,packet);
	}
	debug_printf("MyICQ: %d tcp packet left in sendqueue,freed!\n",i);
}

static void
myicq_updatingContactInfo_list_free(struct myicq_data *md)
{
	struct _updatingContactInfo *info;
	int i=0;
	while (md->updatingContactInfo)
	{
		i++;
		info= (struct _updatingContactInfo *)(md->updatingContactInfo->data);
			
		if (info->window)
		{
			gtk_widget_destroy(info->window); //this will call "destroy" callback,which free data and update this list.
		}
		else
		{
			g_free(md->updatingContactInfo->data);
			md->updatingContactInfo=g_list_remove(md->updatingContactInfo,md->updatingContactInfo->data);
		}
	}
	debug_printf("MyICQ: %d updatingContactInfo request left in queue,freed!\n",i);
}

static void
myicq_tcpmsgconnection_kill(struct myicq_tcpmsgconnection *mtmc)
{
	struct gaim_connection *gc = mtmc->gc;
	struct myicq_data *md = gc->proto_data;

	if (mtmc->inpa)
		gaim_input_remove(mtmc->inpa);
	if (mtmc->connsock>=0)
		close(mtmc->connsock);		
	if (mtmc->rxqueue)
		g_free(mtmc->rxqueue);
	g_free(mtmc->domain);
	g_free(mtmc);
	md->tcpmsgConnection = g_list_remove(md->tcpmsgConnection,mtmc);	
}

static void
myicq_tcpmsgconnection_free(struct myicq_data *md)
{
	int i=0;
	while (md->tcpmsgConnection)
	{
		i++;
		myicq_tcpmsgconnection_kill((struct myicq_tcpmsgconnection *)(md->tcpmsgConnection->data));
	}
	debug_printf("MyICQ: %d tcpmsgConnection left in queue,freed!\n",i);
}

void
myicq_tcpfileconnection_kill(struct myicq_tcpfileconnection *mtfc)
{
	struct gaim_connection *gc = mtfc->gc;
	struct myicq_data *md = gc->proto_data;

	if (mtfc->inpa)
		gaim_input_remove(mtfc->inpa);
	if (mtfc->connsock>=0)
		close(mtfc->connsock);
	if (mtfc->choosefile_dialog)
		gtk_widget_destroy(mtfc->choosefile_dialog);
	if (mtfc->file)
	{
		char text[256];
		int costtime,speed;
		gchar *filename;
		
		fclose(mtfc->file);		
		if (mtfc->update_timeout)
			gtk_timeout_remove(mtfc->update_timeout);
		if (mtfc->window)
			gtk_widget_destroy(mtfc->window);
		costtime = difftime(time(NULL),mtfc->start_time);
		if (costtime==0) //can't be div.
			costtime = 1;
		speed = (mtfc->bytesSent / costtime)/1000;
		filename = g_filename_to_utf8(mtfc->filename,-1,NULL,NULL,NULL);
		if (mtfc->bytesSent==mtfc->filesize)
		{
			if (mtfc->isSend)
			{
				snprintf(text,sizeof(text),_("File send successful!\nsend %lu bytes cost %d seconds, %d k/s\nfilename: %s"),mtfc->bytesSent,costtime,speed,filename);
				do_error_dialog(_("File send over"), text, GAIM_INFO);
			}
			else
			{
				snprintf(text,sizeof(text),_("File receive successful!\nreceive %lu bytes cost %d seconds, %d k/s\nsave as %s"),mtfc->bytesSent,costtime,speed,filename);
				do_error_dialog(_("File saved"), text, GAIM_INFO);
			}
		}
		else
		{
			if (mtfc->isSend)
			{
				snprintf(text,sizeof(text),_("Error occupy while sending file!\nsend %lu bytes,but it should be %lu bytes.\ncost %d seconds, %d k/s\nfilename: %s"),mtfc->bytesSent,mtfc->filesize,costtime,speed,filename);
				do_error_dialog(_("File send over"), text, GAIM_ERROR);
			}
			else
			{
				snprintf(text,sizeof(text),_("Error occupy when receiving file!\nreceive %lu bytes,but it should be %lu bytes.\ncost %d seconds, %d k/s\nsave as %s"),mtfc->bytesSent,mtfc->filesize,costtime,speed,filename);
				do_error_dialog(_("File saved"), text, GAIM_ERROR);
			}
		}
		g_free(filename);
		g_free(mtfc->filename); //when file is open,this should not be NULL.
	}
	if (mtfc->rxqueue)
		g_free(mtfc->rxqueue);
	if (mtfc->sendqueue)
		g_free(mtfc->sendqueue);
	g_free(mtfc);
	md->tcpfileConnection = g_list_remove(md->tcpfileConnection,mtfc);
	
/*	if (!md->tcpfileConnection) //when no connection left,try to close file listen sock.
	{
		if (md->filelistenSock>=0)
		{
			close(md->filelistenSock);
			md->filelistenSock = -1;
		}
	}*/
}

static void
myicq_tcpfileconnection_free(struct myicq_data *md)
{
	int i=0;
	while (md->tcpfileConnection)
	{
		i++;
		myicq_tcpfileconnection_kill((struct myicq_tcpfileconnection *)(md->tcpfileConnection->data));
	}
	debug_printf("MyICQ: %d tcpfileConnection left in queue,freed!\n",i);
}

static void myicq_send_packet_keepalive(struct gaim_connection *gc)
{
	struct myicq_data *md = gc->proto_data;
	char buf[MAX_PACKET_SIZE];
	char *cursor;
	
	myicq_create_packet_head(buf, &cursor, gc, (uint16)UDP_KEEPALIVE);
	myicq_create_packet_dw(buf, &cursor, (uint32)rand()); //it is no use in fact.when in a NAT network,if you always send the same packet,you may be blocked.
	myicq_packet_encrypt(buf,&cursor,md->subkey);
	myicq_send_packet(gc,buf,cursor-buf,UDP_KEEPALIVE);
}

void myicq_send_packet_searchUin(uint32 uin, const char *domain, struct gaim_connection *gc)
{
	struct myicq_data *md = gc->proto_data;
	char buf[MAX_PACKET_SIZE];
	char *cursor;
	
	myicq_create_packet_head(buf, &cursor, gc, (uint16)UDP_SEARCH_CUSTOM);
	myicq_create_packet_dw(buf, &cursor, uin);
	if (domain && (domain[0])&&(strcasecmp(domain,md->domain)))
		myicq_create_packet_str(buf, &cursor, domain);
	myicq_packet_encrypt(buf,&cursor,md->subkey);
	myicq_send_packet(gc,buf,cursor-buf,UDP_SEARCH_CUSTOM);
}

void myicq_send_packet_searchCustom(const char *nick, const char *email,uint32 start_uin,struct gaim_connection *gc)
{
	struct myicq_data *md = gc->proto_data;
	char buf[MAX_PACKET_SIZE];
	char *cursor;
	
	myicq_create_packet_head(buf, &cursor, gc, (uint16)UDP_SEARCH_CUSTOM);
	myicq_create_packet_dw(buf, &cursor, 0);
	myicq_create_packet_str(buf, &cursor, nick);
	myicq_create_packet_str(buf, &cursor, email);
	myicq_create_packet_dw(buf, &cursor, start_uin);
	myicq_packet_encrypt(buf,&cursor,md->subkey);
	myicq_send_packet(gc,buf,cursor-buf,UDP_SEARCH_CUSTOM);
}

void myicq_send_packet_searchRandom(const char *domain, struct gaim_connection *gc)
{
	struct myicq_data *md = gc->proto_data;
	char buf[MAX_PACKET_SIZE];
	char *cursor;
	
	myicq_create_packet_head(buf, &cursor, gc, (uint16)UDP_SEARCH_RANDOM);
	if (domain&&(domain[0])&&(strcasecmp(domain,md->domain)))
		myicq_create_packet_str(buf, &cursor, domain);
	myicq_packet_encrypt(buf,&cursor,md->subkey);
	myicq_send_packet(gc,buf,cursor-buf,UDP_SEARCH_RANDOM);
}

void myicq_send_packet_getServerList(struct gaim_connection *gc)
{
	char buf[MAX_PACKET_SIZE];
	char *cursor;
	
	myicq_create_packet_head(buf, &cursor, gc, (uint16)UDP_GET_SERVER_LIST);
	myicq_send_packet(gc,buf,cursor-buf,UDP_GET_SERVER_LIST);
}

void myicq_send_packet_getGroupList(uint16 type, struct gaim_connection *gc)
{
	struct myicq_data *md = gc->proto_data;
	char buf[MAX_PACKET_SIZE];
	char *cursor;
	
	myicq_create_packet_head(buf, &cursor, gc, (uint16)UDP_GET_GROUP_LIST);
	myicq_create_packet_w(buf, &cursor, type);
	myicq_packet_encrypt(buf,&cursor,md->subkey);
	myicq_send_packet(gc,buf,cursor-buf,UDP_GET_GROUP_LIST);
}

void myicq_send_packet_searchGroup(uint32 id, struct gaim_connection *gc)
{
	struct myicq_data *md = gc->proto_data;
	char buf[MAX_PACKET_SIZE];
	char *cursor;
	
	myicq_create_packet_head(buf, &cursor, gc, (uint16)UDP_SEARCH_GROUP);
	myicq_create_packet_dw(buf, &cursor, id);
	myicq_packet_encrypt(buf,&cursor,md->subkey);
	myicq_send_packet(gc,buf,cursor-buf,UDP_SEARCH_GROUP);
}

void myicq_send_packet_createGroup(uint16 type, const char *name,const char *pass, struct gaim_connection *gc)
{
	struct myicq_data *md = gc->proto_data;
	char buf[MAX_PACKET_SIZE];
	char *cursor;
	
	myicq_create_packet_head(buf, &cursor, gc, (uint16)UDP_CREATE_GROUP);
	myicq_create_packet_w(buf, &cursor, type);
	myicq_create_packet_str(buf, &cursor, name);
	myicq_create_packet_str(buf, &cursor, pass);
	myicq_packet_encrypt(buf,&cursor,md->subkey);
	myicq_send_packet(gc,buf,cursor-buf,UDP_CREATE_GROUP);
}

void myicq_send_packet_enterGroup(uint32 id, const char *pass, struct gaim_connection *gc)
{
	struct myicq_data *md = gc->proto_data;
	char buf[MAX_PACKET_SIZE];
	char *cursor;
	
	myicq_create_packet_head(buf, &cursor, gc, (uint16)UDP_ENTER_GROUP);
	myicq_create_packet_dw(buf, &cursor, id);
	myicq_create_packet_str(buf, &cursor, pass);
	myicq_packet_encrypt(buf,&cursor,md->subkey);
	myicq_send_packet(gc,buf,cursor-buf,UDP_ENTER_GROUP);
}

static void myicq_send_packet_exitGroup(uint32 id, struct gaim_connection *gc)
{
	struct myicq_data *md = gc->proto_data;
	char buf[MAX_PACKET_SIZE];
	char *cursor;
	
	myicq_create_packet_head(buf, &cursor, gc, (uint16)UDP_EXIT_GROUP);
	myicq_create_packet_dw(buf, &cursor, id);
	myicq_packet_encrypt(buf,&cursor,md->subkey);
	myicq_send_packet(gc,buf,cursor-buf,UDP_EXIT_GROUP);
}

void myicq_send_packet_groupMessage(uint32 id, const char *message, struct gaim_connection *gc)
{
	struct myicq_data *md = gc->proto_data;
	char buf[MAX_PACKET_SIZE];
	char *cursor;
	gchar *msg;
	
	myicq_create_packet_head(buf, &cursor, gc, (uint16)UDP_GROUP_MESSAGE);
	myicq_create_packet_dw(buf, &cursor, id);
	msg = myicq_msg_text_encode(message); //encode msg to contain font,color etc. information.
	myicq_create_packet_str(buf, &cursor, msg);
	g_free(msg);
	myicq_packet_encrypt(buf,&cursor,md->subkey);
	myicq_send_packet(gc,buf,cursor-buf,UDP_GROUP_MESSAGE);
}

static uint16 myicq_create_tcp_msglisten_sock(struct gaim_connection *gc);

static void myicq_send_packet_login(struct gaim_connection *gc)
{
	struct myicq_data *md = gc->proto_data;
	char buf[MAX_PACKET_SIZE];
	char *cursor;
	
	uint32 real_ip;
	uint16 port,status;
	struct sockaddr_in addr;
	socklen_t len = sizeof(addr);

	if (md->loginmethod==0)
		status = (uint16) STATUS_INVIS;
	else if (md->loginmethod==2)
		status = (uint16) STATUS_AWAY;
	else
		status = (uint16) STATUS_ONLINE;

	getsockname(md->fd, (struct sockaddr *) &addr, &len);
	debug_printf("MyICQ: myip: %s \n",inet_ntoa(addr.sin_addr));
	real_ip = ntohl(addr.sin_addr.s_addr);
	
	port = myicq_create_tcp_msglisten_sock(gc);		
	
	myicq_create_packet_head(buf, &cursor, gc, (uint16)UDP_LOGIN);
	myicq_create_packet_str(buf, &cursor, gc->password);
	myicq_create_packet_dw(buf, &cursor, status);
	myicq_create_packet_w(buf,&cursor, (uint16) MYICQ_TCP_VER); //tcp version	
	myicq_create_packet_dw(buf,&cursor, real_ip);
	myicq_create_packet_w(buf,&cursor, port);
	myicq_send_packet(gc,buf,cursor-buf,UDP_LOGIN);
}

static void myicq_send_packet_logout(struct gaim_connection *gc)
{
	struct myicq_data *md = gc->proto_data;
	char buf[MAX_PACKET_SIZE];
	char *cursor;
	
	myicq_create_packet_head(buf, &cursor, gc, (uint16)UDP_LOGOUT);
	myicq_write(md->fd,buf,cursor-buf,gc);
}

static void myicq_send_packet_newUin(struct gaim_connection *gc)
{
	struct myicq_data *md = gc->proto_data;
	char buf[MAX_PACKET_SIZE];
	char *cursor;
	
	myicq_create_packet_head(buf, &cursor, gc, (uint16)UDP_NEW_UIN);
	myicq_create_packet_str(buf, &cursor, gc->password);
	myicq_write(md->fd,buf,cursor-buf,gc);  //it should not send more than one time.
}

static void myicq_send_packet_getContactList(struct gaim_connection *gc)
{
	char buf[MAX_PACKET_SIZE];
	char *cursor;
	
	myicq_create_packet_head(buf, &cursor, gc, (uint16)UDP_GET_CONTACTLIST);
	myicq_send_packet(gc,buf,cursor-buf,UDP_GET_CONTACTLIST);
}

static void myicq_send_packet_getRemoteContactList(struct gaim_connection *gc)
{
	char buf[MAX_PACKET_SIZE];
	char *cursor;
	
	myicq_create_packet_head(buf, &cursor, gc, (uint16)UDP_GET_REMOTE_CONTACTLIST);
	myicq_send_packet(gc,buf,cursor-buf,UDP_GET_REMOTE_CONTACTLIST);
}


void myicq_send_packet_addfriend(struct gaim_connection *gc, const char *name)
{
	struct myicq_data *md = gc->proto_data;
	char buf[MAX_PACKET_SIZE];
	char *cursor;
	uint32 uin;
	gchar *domain;	
	
	uin = atol(name);
	domain = strchr(name,'@');
	if (domain)
		domain++;
	myicq_create_packet_head(buf, &cursor, gc, (uint16)UDP_ADD_FRIEND);
	myicq_create_packet_dw(buf, &cursor, uin);
	if ((domain)&&(domain[0])&&(strcasecmp(domain,md->domain)))
		myicq_create_packet_str(buf, &cursor, domain);
	myicq_packet_encrypt(buf,&cursor, md->subkey);
	myicq_send_packet(gc,buf,cursor-buf,UDP_ADD_FRIEND);
}

static void myicq_send_packet_delfriend(struct gaim_connection *gc, char *name)
{
	struct myicq_data *md = gc->proto_data;
	char buf[MAX_PACKET_SIZE];
	char *cursor;
	uint32 uin;
	gchar *domain;	
	
	uin = atol(name);
	domain = strchr(name,'@');	
	if (domain)
		domain++;
	myicq_create_packet_head(buf, &cursor, gc, (uint16)UDP_DEL_FRIEND);
	myicq_create_packet_dw(buf, &cursor, uin);
	if ((domain)&&(domain[0])&&(strcasecmp(domain,md->domain)))	
		myicq_create_packet_str(buf, &cursor, domain);
	myicq_packet_encrypt(buf,&cursor, md->subkey);
	myicq_send_packet(gc,buf,cursor-buf,UDP_DEL_FRIEND);	
}

static void myicq_send_packet_changeStatus(uint32 status, struct gaim_connection *gc)
{
	struct myicq_data *md = gc->proto_data;
	char buf[MAX_PACKET_SIZE];
	char *cursor;
	
	myicq_create_packet_head(buf, &cursor, gc, (uint16)UDP_CHANGE_STATUS);
	myicq_create_packet_dw(buf, &cursor, status);
	myicq_packet_encrypt(buf, &cursor, md->subkey);
	myicq_send_packet(gc,buf,cursor-buf,UDP_CHANGE_STATUS);
}

void myicq_send_packet_updateContact(uint32 uin, const char *domain, struct gaim_connection *gc)
{
	struct myicq_data *md = gc->proto_data;
	char buf[MAX_PACKET_SIZE];
	char *cursor;
	
	myicq_create_packet_head(buf, &cursor, gc, (uint16)UDP_UPDATE_CONTACT);
	myicq_create_packet_dw(buf, &cursor, uin);
	if (domain&&(domain[0])&&(strcasecmp(domain,md->domain)))
		myicq_create_packet_str(buf, &cursor, domain);
	myicq_packet_encrypt(buf, &cursor, md->subkey);
	myicq_send_packet(gc,buf,cursor-buf,UDP_UPDATE_CONTACT);
}

void myicq_send_packet_updateUser(struct gaim_connection *gc)
{
	char buf[MAX_PACKET_SIZE];
	char *cursor;
	
	myicq_create_packet_head(buf, &cursor, gc, (uint16)UDP_UPDATE_USER);
	myicq_send_packet(gc,buf,cursor-buf,UDP_UPDATE_USER);
}

void myicq_send_packet_modifyUser(struct ContactInfo *info, struct gaim_connection *gc)
{
	struct myicq_data *md = gc->proto_data;
	char buf[MAX_PACKET_SIZE];
	char *cursor;
	
	myicq_create_packet_head(buf, &cursor, gc, (uint16)UDP_MODIFY_USER);
	myicq_create_packet_b(buf, &cursor, info->face);
	myicq_create_packet_str(buf, &cursor, info->nick);
	myicq_create_packet_b(buf, &cursor, info->age);
	myicq_create_packet_b(buf, &cursor, info->gender);
	myicq_create_packet_str(buf, &cursor, info->country);
	myicq_create_packet_str(buf, &cursor, info->province);
	myicq_create_packet_str(buf, &cursor, info->city);
	myicq_create_packet_str(buf, &cursor, info->email);
	myicq_create_packet_str(buf, &cursor, info->address);
	myicq_create_packet_str(buf, &cursor, info->zipcode);
	myicq_create_packet_str(buf, &cursor, info->tel);
	myicq_create_packet_str(buf, &cursor, info->name);
	myicq_create_packet_b(buf, &cursor, info->blood);
	myicq_create_packet_str(buf, &cursor, info->college);
	myicq_create_packet_str(buf, &cursor, info->occupation);
	myicq_create_packet_str(buf, &cursor, info->homepage);
	myicq_create_packet_str(buf, &cursor, info->intro);
	myicq_create_packet_b(buf, &cursor, info->auth);
	myicq_create_packet_b(buf, &cursor, info->is_modify_passwd);
	if (info->is_modify_passwd == 1)
		myicq_create_packet_str(buf, &cursor, info->password);
		
	myicq_packet_encrypt(buf, &cursor, md->subkey);
	myicq_send_packet(gc,buf,cursor-buf,UDP_MODIFY_USER);
}

struct myicq_msgpacket
{
	uint8 type;
	uint32 to_uin;
	gchar *to_uin_domain;
	char *message;
	struct gaim_connection *gc;
};

static void myicq_tcp_msg_got_connect(gpointer data, gint source, GaimInputCondition cond);

static int myicq_send_tcp_msg_connect(uint8 type, uint32 to_uin, gchar *to_uin_domain, char *message, struct gaim_connection *gc)
{
	struct myicq_data *md = gc->proto_data;
	GList *list;
	struct myicq_buddy *buddy=NULL;
	gboolean find= FALSE;
	char ipaddr[256];
	int fd;
	struct myicq_msgpacket *packet;
	struct in_addr in;
	
	list = md->onlinebuddy;
	while (list)
	{
		buddy= (struct myicq_buddy *)(list->data);
		if ((buddy->uin==to_uin)&&(!strcasecmp(buddy->domain,to_uin_domain)))
		{
			find = TRUE;
			break;
		}
		list=list->next;
	}
	if (!find)
	{
		debug_printf("MyICQ: send msg connect,can't find buddy's ip info!\n");
		return FALSE;
	}
	if (buddy->try_connected)
		return FALSE;  //connected ago.

	buddy->try_connected = TRUE;
	
	if ((buddy->real_ip != buddy->ip)&&(md->ourIP != buddy->ip))
	{
		// Unfortunately, the remote is behind a firewall,
		// and we are not behind the same firewall,
		// so that the connection can not be established
		debug_printf("MyICQ: the remote is behind a firewall,can't connect!\n");
		return FALSE;				
	}
	
	in.s_addr = htonl(buddy->real_ip);
	sprintf(ipaddr,"%s",inet_ntoa(in));
	
	packet = g_new0(struct myicq_msgpacket,1);
	packet->type = type;
	packet->to_uin = to_uin;
	packet->to_uin_domain = g_strdup(to_uin_domain);
	packet->message = g_strdup(message);
	packet->gc = gc;

	fd = proxy_connect(gc->account, ipaddr, (int)buddy->port, myicq_tcp_msg_got_connect, packet);
	if (fd < 0)
	{
		g_free(packet->to_uin_domain);
		g_free(packet->message);
		g_free(packet);
		debug_printf("MyICQ: send tcp msg,connect fail!!\n");		
		return FALSE;
	}

	return TRUE; //connected.
}

static void myicq_tcp_sendfile_got_connect(gpointer data, gint source, GaimInputCondition cond);

static int myicq_send_file_connect(uint32 to_uin, gchar *to_uin_domain, int port, struct gaim_connection *gc)
{
	struct myicq_data *md = gc->proto_data;
	GList *list;
	struct myicq_buddy *buddy=NULL;
	gboolean find= FALSE;
	char ipaddr[256];
	struct in_addr in;
	int fd;
	struct _gc_and_qid *gq;
	
	list = md->onlinebuddy;
	while (list)
	{
		buddy= (struct myicq_buddy *)(list->data);
		if ((buddy->uin==to_uin)&&(!strcasecmp(buddy->domain,to_uin_domain)))
		{
			find = TRUE;
			break;
		}
		list=list->next;
	}
	if (!find)
	{
		debug_printf("MyICQ: send file connect,can't find buddy's ip info!\n");
		return FALSE;
	}
	
	if ((buddy->real_ip != buddy->ip)&&(md->ourIP != buddy->ip))
	{
		// Unfortunately, the remote is behind a firewall,
		// and we are not behind the same firewall,
		// so that the connection can not be established
		debug_printf("MyICQ: the remote is behind a firewall,can't connect!\n");
		return FALSE;				
	}
	
	in.s_addr = htonl(buddy->real_ip);
	sprintf(ipaddr,"%s",inet_ntoa(in));
	
	gq = g_new0(struct _gc_and_qid,1);
	gq->uin = to_uin;
	gq->domain = g_strdup(to_uin_domain);
	gq->gc = gc;

	fd = proxy_connect(gc->account, ipaddr, port, myicq_tcp_sendfile_got_connect, gq);
	if (fd < 0)
	{
		g_free(gq->domain);
		g_free(gq);
		debug_printf("MyICQ: send file,connect fail!!\n");		
		return FALSE;
	}

	return TRUE; //connected.
}

void myicq_send_packet_msg(uint8 type, uint32 to_uin, gchar *to_uin_domain, char *message, struct gaim_connection *gc)
{
	struct myicq_data *md = gc->proto_data;
	char buf[MAX_PACKET_SIZE];
	char *cursor;
	
	myicq_create_packet_head(buf, &cursor, gc, (uint16)UDP_SEND_MSG);
	myicq_create_packet_b(buf, &cursor, type);
	myicq_create_packet_dw(buf, &cursor, to_uin);
	if (type==MSG_TEXT)
	{
		gchar *msg;
		msg = myicq_msg_text_encode(message); //encode msg to contain font,color etc. information.
		myicq_create_packet_str(buf, &cursor, msg);
		g_free(msg);
	}
	else if (type==MSG_AUTO_REPLY)
	{
		myicq_create_packet_str(buf, &cursor, message);
	}
	else if (type == MSG_AUTH_ACCEPTED || type == MSG_ADDED)
	{
	}
	else if (type == MSG_AUTH_REQUEST)
	{
		char text[MAX_MSG_LEN];
		snprintf(text, sizeof(text), "%d\xFF%s\xFF%s",md->face,gc->displayname,message);
		myicq_create_packet_str(buf, &cursor, text);
	}
	else if (type == MSG_AUTH_REJECTED)
	{
		myicq_create_packet_str(buf, &cursor, message);
	}
	else if (type == MSG_TCP_REQUEST)
	{
		myicq_create_packet_str(buf, &cursor, message);
	}
	else if (type == MSG_TCP_ACCEPTED)
	{
		myicq_create_packet_str(buf, &cursor, message);		
	}
	else if (type == MSG_TCP_REJECTED)
	{
	}
	if (to_uin_domain&&(to_uin_domain[0])&&(strcasecmp(to_uin_domain,md->domain)))
		myicq_create_packet_str(buf, &cursor, to_uin_domain);		
	myicq_packet_encrypt(buf, &cursor, md->subkey);
	myicq_send_packet(gc,buf,cursor-buf,UDP_SEND_MSG);
}


static int
myicq_send_tcp_sendfileinfo_packet(struct myicq_tcpfileconnection *mtfc)
{
	struct gaim_connection *gc = mtfc->gc;
	struct myicq_data *md = gc->proto_data;
	char buf[MAX_PACKET_SIZE];
	char *cursor;
	gchar *basename;	
	
	myicq_create_tcp_packet_head(buf, &cursor, md, (uint16)TCP_FILE_INFO);
	basename = g_path_get_basename(mtfc->filename);
	myicq_create_packet_str(buf, &cursor, basename);
	g_free(basename);
	myicq_create_packet_dw(buf, &cursor, mtfc->filesize);
	return (myicq_tcp_file_send(mtfc,buf,cursor-buf));
}

static int
myicq_send_tcp_packet_hello(int fd,struct myicq_data *md, int isSend)
{
	char buf[MAX_PACKET_SIZE];
	char *cursor;
	
	myicq_create_tcp_packet_head(buf, &cursor, md, (uint16)TCP_HELLO);
	myicq_create_packet_b(buf, &cursor, (uint8)isSend);
	myicq_create_packet_str(buf, &cursor, md->domain);
	return (myicq_send(fd,buf,cursor-buf));
}

void myicq_send_tcp_msg_packet(uint8 type, char *message, struct myicq_tcpmsgconnection *mtmc)
{
	struct gaim_connection *gc = mtmc->gc;
	struct myicq_data *md = gc->proto_data;
	struct tcpmsgpacket	*packet;

	char buf[MAX_PACKET_SIZE];
	char *cursor;
	uint32 nowtime;
	
	myicq_create_tcp_packet_head(buf, &cursor, md, (uint16)TCP_MSG_MESSAGE);
	myicq_create_packet_dw(buf, &cursor, --(mtmc->msgID));
	myicq_create_packet_b(buf, &cursor, type);
	nowtime = time(NULL);
	myicq_create_packet_dw(buf, &cursor, nowtime);
	
	if (type==MSG_TEXT)
	{
		char * msg;
		msg = myicq_msg_text_encode(message); //encode msg to contain font,color etc. information.
		myicq_create_packet_str(buf, &cursor, msg);
		g_free(msg);
	}
	else if (type==MSG_AUTO_REPLY)
	{
		myicq_create_packet_str(buf, &cursor, message);
	}
	else if (type == MSG_TCP_REQUEST)
	{
		myicq_create_packet_str(buf, &cursor, message);
	}
	else if (type == MSG_TCP_ACCEPTED)
	{
		myicq_create_packet_str(buf, &cursor, message);
	}
	
	myicq_send(mtmc->connsock,buf,cursor-buf);
	debug_printf("MyICQ: send_tcp packet %lu\n",mtmc->msgID);
	
	//add to tcp send queue.

	packet = g_new(struct tcpmsgpacket,1);
	packet->id = mtmc->msgID;
	packet->type = type;
	packet->to_uin = mtmc->uin;
	packet->to_uin_domain = g_strdup(mtmc->domain);
	packet->sendtime = nowtime;
	packet->message = g_strdup(message);

	md->tcpmsgsendqueue = g_list_append(md->tcpmsgsendqueue,packet);
}

void myicq_send_tcp_msg_packet_ack(uint32 id, struct myicq_tcpmsgconnection *mtmc)
{
	struct gaim_connection *gc = mtmc->gc;
	struct myicq_data *md = gc->proto_data;

	char buf[MAX_PACKET_SIZE];
	char *cursor;
	
	myicq_create_tcp_packet_head(buf, &cursor, md, (uint16)TCP_MSG_MESSAGE_ACK);
	myicq_create_packet_dw(buf, &cursor, id);
	myicq_send(mtmc->connsock,buf,cursor-buf);
}

void myicq_send_tcp_packet_fileReceive(struct myicq_tcpfileconnection *mtfc)
{
	struct gaim_connection *gc = mtfc->gc;
	struct myicq_data *md = gc->proto_data;
	char buf[MAX_PACKET_SIZE];
	char *cursor;
	
	myicq_create_tcp_packet_head(buf, &cursor, md, TCP_FILE_RECEIVE);
	myicq_tcp_file_send(mtfc,buf,cursor-buf);
}

static int
myicq_send_tcp_packet_fileData(char *data, int datalen, struct myicq_tcpfileconnection *mtfc)
{
	struct gaim_connection *gc = mtfc->gc;
	struct myicq_data *md = gc->proto_data;
	char buf[MAX_PACKET_SIZE];
	char *cursor;
	
	myicq_create_tcp_packet_head(buf, &cursor, md, (uint16)TCP_FILE_DATA);
	myicq_create_packet_data(buf, &cursor, data, datalen);
	return (myicq_tcp_file_send(mtfc,buf,cursor-buf)); // when net speed is low,it may not send fully.
}

static void myicq_read_packet_b(char *buf, char **cursor, int buflen,uint8 *b)
{
	if (*cursor <= buf + buflen - sizeof(*b)) {
		*b = **(uint8 **) cursor;
		*cursor += sizeof(*b);
	} else
		*b = 0;
}

static void myicq_read_packet_w(char *buf, char **cursor, int buflen,uint16 *w)
{
	if (*cursor <= buf + buflen - sizeof(*w)) {
		*w = ntohs(**(uint16 **) cursor);
		*cursor += sizeof(*w);
	} else
		*w = 0;
}

static void myicq_read_packet_dw(char *buf, char **cursor, int buflen,uint32 *dw)
{
	if (*cursor <= buf + buflen - sizeof(*dw)) {
		*dw = ntohl(**(uint32 **) cursor);
		*cursor += sizeof(*dw);
	} else
		*dw = 0;
}

static void myicq_read_packet_str(char *buf, char **cursor, int buflen, char **str)
{
	uint16 len;
	myicq_read_packet_w(buf, cursor,buflen,&len);
	if ((len>0)&&((*cursor <= buf + buflen - len) && (!((*cursor)[len - 1])))) {
		*str = *cursor;
		*cursor += len;
	} else
		*str = "";
}

static int myicq_check_packet_set_window(uint16 seq, struct gaim_connection *gc)
{
	struct myicq_data *md = gc->proto_data;
	uint8 *byte = &(md->window[seq / 8]);
	uint8 mask = (1 << (seq % 8));
	if ((*byte) & mask)
		return 0;

	(*byte) |= mask;
	return 1;
}

static void myicq_process_onAck(uint16 seq, struct gaim_connection *gc)
{
	if (myicq_sendqueue_remove((struct myicq_data *)(gc->proto_data), seq))
		debug_printf("MyICQ: packet %d is acked\n",seq);
	else
		debug_printf("MyICQ: ack packet %d is ignored\n",seq);		
}

static void myicq_process_userOnline(char *buf, int buflen, struct gaim_connection *gc)
{
	struct myicq_data *md = gc->proto_data;
	char *cursor = buf;
	uint32 uin,status,ip,real_ip,uc;
	uint16 port;
	char bud[256];
	struct myicq_buddy *buddy;
	GList *list;
	gchar *domain;	
	
	myicq_read_packet_dw(buf, &cursor, buflen, &uin);
	myicq_read_packet_dw(buf, &cursor, buflen, &status);
	myicq_read_packet_dw(buf, &cursor, buflen, &ip);
	myicq_read_packet_w(buf, &cursor, buflen, &port);
	myicq_read_packet_dw(buf, &cursor, buflen, &real_ip);
	myicq_read_packet_str(buf, &cursor, buflen, &domain);
	if (domain[0])
	{
		sprintf(bud,"%lu@%s",uin,domain);
	}
	else
	{
		sprintf(bud,"%lu",uin);
		domain=md->domain;
	}
	
	struct buddy *b = gaim_find_buddy(gc->account, bud);
	if (!b)
	{
		struct group *g;
		gchar group[256];
		sprintf(group,_("%s friends"),gc->username);
		if (!(g = gaim_find_group(group))) {
			g = gaim_group_new(group);
			gaim_blist_add_group(g, NULL);
		}
		b = gaim_buddy_new(gc->account, bud, NULL);
		gaim_blist_add_buddy(b,g,NULL);
	}

	uc = ( UC_UNAVAILABLE | (status << 1)) ;	
	serv_got_update(gc, bud, 1, 0, 0, 0, uc);
		
	list = md->onlinebuddy;
	while (list)
	{
		buddy= (struct myicq_buddy *)(list->data);
		if ((buddy->uin==uin)&&(!strcasecmp(buddy->domain,domain)))
		{
			g_free(buddy->domain);
			g_free(buddy);
			md->onlinebuddy=g_list_remove(md->onlinebuddy,buddy);
			break;
		}
		list=list->next;
	}
	buddy = g_new0(struct myicq_buddy,1);
	buddy->uin=uin;
	buddy->domain = g_strdup(domain);
	buddy->ip=ip;
	buddy->port=port;
	buddy->real_ip=real_ip;
	
	md->onlinebuddy = g_list_append(md->onlinebuddy,buddy);
}

static void myicq_process_multiOnline(char *buf, int buflen, struct gaim_connection *gc)
{
	struct myicq_data *md = gc->proto_data;
	char *cursor = buf;
	uint16 num,port;
	uint32 uin,status,ip,real_ip,uc;
	int i;
	char bud[256];
	struct myicq_buddy *buddy;
	GList *list;
	gchar group[256];
	
	myicq_read_packet_w(buf, &cursor, buflen, &num);
	debug_printf("MyICQ: multionline : %u \n",num);
	for (i=0; i< num; i++)
	{
		myicq_read_packet_dw(buf, &cursor, buflen, &uin);
		sprintf(bud,"%lu",uin);
		myicq_read_packet_dw(buf, &cursor, buflen, &status);
		myicq_read_packet_dw(buf, &cursor, buflen, &ip);
		myicq_read_packet_w(buf, &cursor, buflen, &port);
		myicq_read_packet_dw(buf, &cursor, buflen, &real_ip);
		
		
		struct buddy *b = gaim_find_buddy(gc->account, bud);
		if (!b)
		{
			struct group *g;
			sprintf(group,_("%s friends"),gc->username);			
			if (!(g = gaim_find_group(group))) {
				g = gaim_group_new(group);
				gaim_blist_add_group(g, NULL);
			}
			b = gaim_buddy_new(gc->account, bud, NULL);
			gaim_blist_add_buddy(b,g,NULL);
		}

		uc = ( UC_UNAVAILABLE | (status << 1)) ;	
		serv_got_update(gc, bud, 1, 0, 0, 0, uc);		
	
		list = md->onlinebuddy;
		while (list)
		{
			buddy= (struct myicq_buddy *)(list->data);
			if ((buddy->uin==uin)&&(!strcasecmp(buddy->domain,md->domain)))
			{
				g_free(buddy->domain);
				g_free(buddy);
				md->onlinebuddy=g_list_remove(md->onlinebuddy,buddy);
				break;
			}
			list=list->next;
		}

		buddy = g_new0(struct myicq_buddy,1);
		buddy->uin=uin;
		buddy->domain = g_strdup(md->domain);
		buddy->ip=ip;
		buddy->port=port;
		buddy->real_ip=real_ip;
		md->onlinebuddy = g_list_append(md->onlinebuddy,buddy);
	}
}

static void myicq_process_userOffline(char *buf, int buflen, struct gaim_connection *gc)
{
	struct myicq_data *md = gc->proto_data;
	char *cursor = buf;
	uint32 uin;
	char bud[256];
	gchar *domain;
	
	myicq_read_packet_dw(buf, &cursor, buflen, &uin);
	myicq_read_packet_str(buf, &cursor, buflen, &domain);
	if (domain[0])
	{
		sprintf(bud,"%lu@%s",uin,domain);
	}
	else
	{
		sprintf(bud,"%lu",uin);
		domain=md->domain;
	}
	serv_got_update(gc, bud, 0, 0, 0, 0, 0);	
}

static void myicq_process_statusChanged(char *buf, int buflen, struct gaim_connection *gc)
{
	struct myicq_data *md = gc->proto_data;
	char *cursor = buf;
	uint32 uin,status,uc;
	char bud[256];
	gchar *domain;
	
	myicq_read_packet_dw(buf, &cursor, buflen, &uin);
	myicq_read_packet_dw(buf, &cursor, buflen, &status);
	myicq_read_packet_str(buf, &cursor, buflen, &domain);
	if (domain[0])
	{
		sprintf(bud,"%lu@%s",uin,domain);
	}
	else
	{
		sprintf(bud,"%lu",uin);
		domain= md->domain;
	}
	uc = ( UC_UNAVAILABLE | (status << 1)) ;
	serv_got_update(gc, bud, 1, 0, 0, 0, uc);
}

static void myicq_addFriendAuthReq_reject_ok(gpointer data, char *entry)
{
	struct _gc_and_qid *gq = (struct _gc_and_qid *)data;
	gchar *reason;
	reason = g_locale_from_utf8(entry,-1,NULL,NULL,NULL);
	myicq_send_packet_msg(MSG_AUTH_REJECTED,gq->uin,gq->domain, reason,gq->gc);
	g_free(reason);
	gq->gc=NULL;

	//g_free(gq->domain); //this will be free by myicq_addFriendAuthReq_reject_cancel.
	//g_free(gq);
}

static void myicq_addFriendAuthReq_reject_cancel(gpointer data, char *entry)
{
	struct _gc_and_qid *gq = (struct _gc_and_qid *)data;
	
	if (gq->gc) //user clicked "Cancel" or close the diglog.
	{
	}
	else //this function is call after myicq_addFriendAuthReq_reject_ok,as "Accept" button is clicked.
	{
	}
	g_free(gq->domain);
	g_free(gq);
}

static void myicq_addFriendAuthReq_reject(gpointer data)
{
	do_prompt_dialog(_("Please input the reason for rejecting:"),_("Sorry,i don't want to make friend with you."), data, myicq_addFriendAuthReq_reject_ok, myicq_addFriendAuthReq_reject_cancel);
}

static void myicq_addFriendAuthReq_accept(gpointer data)
{
	struct _gc_and_qid *gq = (struct _gc_and_qid *)data;
	struct myicq_data *md = gq->gc->proto_data;
	
	char bud[256];
	myicq_send_packet_msg(MSG_AUTH_ACCEPTED,gq->uin,gq->domain, NULL,gq->gc);
	if (strcasecmp(gq->domain,md->domain))
		sprintf(bud,"%lu@%s",gq->uin,gq->domain);
	else
		sprintf(bud,"%lu",gq->uin);
	show_got_added(gq->gc, NULL, bud, NULL, NULL); // if you accept him,you will not receive get MSG_ADDED,as it is needn't tell you.			
	g_free(gq->domain);
	g_free(gq);
}

static gint update_sendfile_progress(gpointer data)
{
	struct myicq_tcpfileconnection *mtfc = (struct myicq_tcpfileconnection *) data;
	char text[16];
	int nowtime;


	nowtime = difftime(time(NULL),mtfc->start_time);
	if (mtfc->filesize==0 || nowtime==0) // it can't be div.
		return 1;
	gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(mtfc->progressbar),((gfloat)mtfc->bytesSent / (gfloat)mtfc->filesize));
	
	sprintf(text,_("%8d k/s"),(gint) ((mtfc->bytesSent / nowtime)/1000));
	gtk_label_set_text(GTK_LABEL(mtfc->speed_label),text);
/*	while (gtk_events_pending()) //repaint any window.
	{
		gtk_main_iteration();
	}	*/
	return 1;
}

static void receivefile_choosefile_ok(GtkWidget *widget, struct myicq_tcpfileconnection *mtfc)
{	
	GtkWidget *file_selector = (GtkWidget *)g_object_get_data(G_OBJECT(widget),"user_data");
	const char *selected_filename = gtk_file_selection_get_filename (GTK_FILE_SELECTION(file_selector));

	mtfc->file = fopen(selected_filename,"wb");
	if (mtfc->file)
	{	
		myicq_send_tcp_packet_fileReceive(mtfc);
		mtfc->filename = g_strdup(selected_filename);
		mtfc->start_time = time(NULL);
		myicq_show_send_file_progress(mtfc);
		mtfc->update_timeout = gtk_timeout_add(500, update_sendfile_progress, mtfc);
		
		gtk_widget_destroy(file_selector);
		mtfc->choosefile_dialog = NULL;
	}
	else
	{
		do_error_dialog(_("Receive file"), _("Open file for write failed!"), GAIM_ERROR);
	}
}

static void receivefile_choosefile_cancel(GtkWidget *widget, struct myicq_tcpfileconnection *mtfc)
{
	myicq_tcpfileconnection_kill(mtfc);	
}

static void receivefile_choosefile_delete_event(GtkWidget *widget,GdkEvent  *event, struct myicq_tcpfileconnection *mtfc)
{
	mtfc->choosefile_dialog = NULL; //the file selection dialog will destroy it auto,so make myicq_tcpfileconnection_kill didn't destroy it again.
	myicq_tcpfileconnection_kill(mtfc);	
}

static void myicq_process_tcp_fileInfo(char *buf, int buflen, struct myicq_tcpfileconnection *mtfc)
{
	char *cursor = buf;
	char *name;
	uint32 filesize;
	GtkWidget *file_selector;
	char text[256];
	
	myicq_read_packet_str(buf, &cursor, buflen, &name);
	myicq_read_packet_dw(buf, &cursor, buflen, &filesize);
	
	mtfc->filesize = filesize;
	
	sprintf(text,_("Receive file.size: %lu K .Save as..."),filesize/1000);
	file_selector = gtk_file_selection_new(text);
	gtk_file_selection_set_filename(GTK_FILE_SELECTION(file_selector),name);
	
	mtfc->choosefile_dialog = file_selector;
	
	g_object_set_data(G_OBJECT (GTK_FILE_SELECTION(file_selector)->ok_button),"user_data",file_selector);
	g_signal_connect (G_OBJECT (GTK_FILE_SELECTION(file_selector)->ok_button),
   			   "clicked", G_CALLBACK (receivefile_choosefile_ok), mtfc);   			   
	g_signal_connect (G_OBJECT (GTK_FILE_SELECTION(file_selector)->cancel_button),
   			   "clicked", G_CALLBACK (receivefile_choosefile_cancel), mtfc);   	
	g_signal_connect (G_OBJECT (file_selector),
   			   "delete_event", G_CALLBACK (receivefile_choosefile_delete_event), mtfc);   
   
	gtk_widget_show (file_selector);	
}

static void myicq_tcp_file_writing(gpointer data, gint source, GaimInputCondition cond);

static void myicq_process_tcp_fileReceive(struct myicq_tcpfileconnection *mtfc)
{
	if (!mtfc->isSend)
		return;
	gaim_input_remove(mtfc->inpa); //needn't read it.
	mtfc->start_time = time(NULL);
	myicq_show_send_file_progress(mtfc);
	mtfc->update_timeout = gtk_timeout_add(500, update_sendfile_progress, mtfc);
	mtfc->inpa = gaim_input_add(mtfc->connsock, GAIM_INPUT_WRITE, myicq_tcp_file_writing, mtfc);
}

static void sendfile_choosefile_show(struct gaim_connection *gc, struct myicq_tcpfileconnection *old_mtfc, gint source);
	
static void myicq_process_tcp_fileHello(char *buf, int buflen, struct myicq_tcpfileconnection *mtfc)
{
	char *cursor = buf;
	uint8 isSend;
	
	myicq_read_packet_b(buf, &cursor, buflen, &isSend);
	debug_printf("MyICQ: receive tcp file Hello packet, isSend: %d\n",isSend);
	mtfc->isSend = (!isSend);
	if (!isSend)
		sendfile_choosefile_show(mtfc->gc,mtfc,0);
}

static void myicq_process_tcp_fileData(char *buf, int buflen, struct myicq_tcpfileconnection *mtfc)
{
	int n;
	n = fwrite(buf, 1, buflen, mtfc->file);

	mtfc->bytesSent += n;	
}

static void myicq_process_tcp_msgHello(char *buf, int buflen, uint32 from_uin, struct myicq_tcpmsgconnection *mtmc);
static void myicq_process_tcp_msgRecv(char *buf, int buflen, uint32 from_uin, struct myicq_tcpmsgconnection *mtmc);
static void myicq_process_tcp_msgAck(char *buf, int buflen, uint32 from_uin, struct myicq_tcpmsgconnection *mtmc);
	
static void myicq_tcp_msg_packet_process(char *buf, int buflen, struct myicq_tcpmsgconnection *mtmc)
{
	struct TCP_HEADER header;
	char *cursor;
	int len;

	if (buflen < sizeof(struct TCP_HEADER))
	{
		debug_printf("MyICQ: process: drop a short packet\n");
		return;
	}

	cursor = buf;
	myicq_read_packet_w(buf, &cursor, buflen, &header.ver);
	if (header.ver != MYICQ_TCP_VER)
	{
		debug_printf("MyICQ: tcp header.ver not right\n");
		return;
	}
	myicq_read_packet_dw(buf, &cursor, buflen, &header.reserved);
	myicq_read_packet_w(buf, &cursor, buflen, &header.cmd);
	myicq_read_packet_dw(buf, &cursor, buflen, &header.uin);
	myicq_read_packet_b(buf, &cursor, buflen, &header.face);
	
	len = buflen - sizeof(struct TCP_HEADER);
	
	switch (header.cmd)
	{
		case TCP_HELLO:
			myicq_process_tcp_msgHello(cursor, len , header.uin, mtmc);
			break;
		case TCP_MSG_MESSAGE:
			myicq_process_tcp_msgRecv(cursor, len , header.uin, mtmc);
			break;
		case TCP_MSG_MESSAGE_ACK:
			myicq_process_tcp_msgAck(cursor, len , header.uin, mtmc);
			break;
		default:
			debug_printf("MyICQ: receive UNKNOW tcp msg packet\n");
			break;
	}
}

static void myicq_tcp_file_packet_process(char *buf, int buflen, struct myicq_tcpfileconnection *mtfc)
{
	struct TCP_HEADER header;
	char *cursor;
	int len;

	if (buflen < sizeof(struct TCP_HEADER))
	{
		debug_printf("MyICQ: process: drop a short packet\n");
		return;
	}

	cursor = buf;
	myicq_read_packet_w(buf, &cursor, buflen, &header.ver);
	if (header.ver != MYICQ_TCP_VER)
	{
		debug_printf("MyICQ: tcp header.ver not right\n");
		return;
	}
	myicq_read_packet_dw(buf, &cursor, buflen, &header.reserved);
	myicq_read_packet_w(buf, &cursor, buflen, &header.cmd);
	myicq_read_packet_dw(buf, &cursor, buflen, &header.uin);
	myicq_read_packet_b(buf, &cursor, buflen, &header.face);
	
	len = buflen - sizeof(struct TCP_HEADER);
	
	switch (header.cmd)
	{
		case TCP_HELLO:
			myicq_process_tcp_fileHello(cursor, len , mtfc);
			break;
		case TCP_FILE_INFO:
			myicq_process_tcp_fileInfo(cursor, len , mtfc);
			break;
		case TCP_FILE_RECEIVE:
			myicq_process_tcp_fileReceive(mtfc);
			break;
		case TCP_FILE_DATA:
			myicq_process_tcp_fileData(cursor, len , mtfc);
			break;
		default:
			debug_printf("MyICQ: receive UNKNOW tcp packet\n");
			break;
	}
}

static void myicq_tcp_msg_pending(gpointer data, gint source, GaimInputCondition cond)
{
	struct myicq_tcpmsgconnection *mtmc = data;

	if (cond & GAIM_INPUT_READ)
	{
		char buf[MAX_PACKET_SIZE];
		char *start, *end;
		char *queue;
		uint16 len;
		int readlen;

		readlen = recv(mtmc->connsock, buf, sizeof(buf),0);
	
		if (readlen <= 0) {
			debug_printf("MyICQ: read error,tcp msg connection close!\n");	
			myicq_tcpmsgconnection_kill(mtmc);		
			return;
		}

		mtmc->rxqueue = g_realloc(mtmc->rxqueue, readlen + mtmc->rxlen);
		memcpy(mtmc->rxqueue + mtmc->rxlen, buf, readlen);
		mtmc->rxlen += readlen;

		start = mtmc->rxqueue;
		end = start + mtmc->rxlen;

		while (start + sizeof(len) < end)
		{
			len = ntohs(*(uint16 *) start);
			if (end - start - sizeof(len) < len)
			{
				// Not a complete packet
				break;
			}

			start += sizeof(len);
			if (len >= sizeof(struct TCP_HEADER))
			{
				myicq_tcp_msg_packet_process(start, len, mtmc);
			}
			start += len;
		}

		queue=mtmc->rxqueue;
		mtmc->rxlen = end - start;
		if (mtmc->rxlen > 0)
		{
			mtmc->rxqueue = g_memdup(start, mtmc->rxlen);
		}
		else
		{
			mtmc->rxqueue=NULL;
		}
		g_free(queue);
	}	
}

static void myicq_tcp_file_pending(gpointer data, gint source, GaimInputCondition cond)
{
	struct myicq_tcpfileconnection *mtfc = data;
	char buf[MAX_PACKET_SIZE];
	char *start, *end;
	char *queue;
	uint16 len;
	int readlen;

	readlen = recv(mtfc->connsock, buf, sizeof(buf),0);
	
	if (readlen <= 0) {
		debug_printf("MyICQ: tcp file connection close!\n");	
		myicq_tcpfileconnection_kill(mtfc);		
		return;
	}

	mtfc->rxqueue = g_realloc(mtfc->rxqueue, readlen + mtfc->rxlen);
	memcpy(mtfc->rxqueue + mtfc->rxlen, buf, readlen);
	mtfc->rxlen += readlen;

	start = mtfc->rxqueue;
	end = start + mtfc->rxlen;

	while (start + sizeof(len) < end)
	{
		len = ntohs(*(uint16 *) start);
		if (end - start - sizeof(len) < len)
		{
			// Not a complete packet
			break;
		}

		start += sizeof(len);
		if (len >= sizeof(struct TCP_HEADER))
		{
			myicq_tcp_file_packet_process(start, len, mtfc);
		}
		start += len;
	}

	queue=mtfc->rxqueue;
	mtfc->rxlen = end - start;
	if (mtfc->rxlen > 0)
	{
		mtfc->rxqueue = g_memdup(start, mtfc->rxlen);
	}
	else
	{
		mtfc->rxqueue=NULL;
	}
	g_free(queue);
}

static void myicq_tcp_file_writing(gpointer data, gint source, GaimInputCondition cond)
{
	struct myicq_tcpfileconnection *mtfc = data;
	if (mtfc->file)
	{
		char buf[2048];
		int sendlen;		
		int n;
		if (mtfc->sendlen==0) //not buffer need to send.
		{			
			n = fread(buf, 1, sizeof(buf), mtfc->file);
			sendlen = myicq_send_tcp_packet_fileData(buf,n,mtfc);
			mtfc->bytesSent += n;
		}
		else
		{
			sendlen = myicq_tcp_file_send(mtfc,NULL,0); //send buffer.
		}
		if (sendlen <=0 || (mtfc->bytesSent >= mtfc->filesize && mtfc->sendlen==0))
		{
			myicq_tcpfileconnection_kill(mtfc);
		}
	}
}

static void myicq_tcp_file_got_connect(gpointer data, gint source, GaimInputCondition cond)
{
	struct gaim_connection *gc = data;
	struct myicq_data *md = gc->proto_data;
	struct myicq_tcpfileconnection *mtfc;
	
	if (source == -1 || !g_slist_find(connections, gc)) {
		close(source);		
		return;
	}
	
	if (myicq_send_tcp_packet_hello(source,md,FALSE)<=0)
	{
		debug_printf("MyICQ: send hello packet fail!\n");
		return;
	}

		
	debug_printf("MyICQ: tcp file got connect!!\n");
	
		
	mtfc = g_new0(struct myicq_tcpfileconnection,1);
		
	mtfc->connsock=source;	
	mtfc->gc = gc;
	md->tcpfileConnection= g_list_append(md->tcpfileConnection,mtfc);
	
	mtfc->inpa = gaim_input_add(mtfc->connsock, GAIM_INPUT_READ, myicq_tcp_file_pending, mtfc);
}

static void sendfile_choosefile_ok(GtkWidget *widget, struct myicq_tcpfileconnection *mtfc)
{	
	GtkFileSelection *file_selector = (GtkFileSelection *)g_object_get_data(G_OBJECT(widget),"user_data");
	const char *selected_filename = gtk_file_selection_get_filename (file_selector);
	FILE * sendfile;

	sendfile = fopen(selected_filename,"rb"); // open it just for test.
	if (sendfile)
	{
		struct stat stats;
		stat(selected_filename, &stats);
		
		mtfc->filename = g_strdup(selected_filename);
		mtfc->filesize = stats.st_size;
		mtfc->file = sendfile;
	
		if (myicq_send_tcp_sendfileinfo_packet(mtfc)<=0)
		{
			myicq_tcpfileconnection_kill(mtfc);
			return;
		}
	
		if (!mtfc->inpa) // when remote is behind a firewall,the inpa is already set on.
			mtfc->inpa = gaim_input_add(mtfc->connsock, GAIM_INPUT_READ, myicq_tcp_file_pending, mtfc);
		
		gtk_widget_destroy(GTK_WIDGET(file_selector));
		mtfc->choosefile_dialog = NULL;
	}
	else
	{
		do_error_dialog(_("Send file"), _("Open file for read fail!"), GAIM_ERROR);
	}
}

static void sendfile_choosefile_cancel(GtkWidget *widget, struct myicq_tcpfileconnection *mtfc)
{
	myicq_tcpfileconnection_kill(mtfc);
}

static void sendfile_choosefile_delete_event(GtkWidget *widget,GdkEvent  *event, struct myicq_tcpfileconnection *mtfc)
{
	mtfc->choosefile_dialog = NULL; //the file selection dialog will destroy it auto,so make myicq_tcpfileconnection_kill didn't destroy it again.
	myicq_tcpfileconnection_kill(mtfc);	
}

static void sendfile_choosefile_show(struct gaim_connection *gc, struct myicq_tcpfileconnection *old_mtfc , gint source)
{
	struct myicq_data *md = gc->proto_data;
	GtkWidget *file_selector;
	struct myicq_tcpfileconnection *mtfc;
	
	file_selector = gtk_file_selection_new(_("Choose the file which you want to send"));	
		
	if (old_mtfc)
	{
		mtfc = old_mtfc;
	}
	else
	{
		mtfc = g_new0(struct myicq_tcpfileconnection,1);
		mtfc->gc = gc;	
		mtfc->connsock=source;
		mtfc->isSend = TRUE;
		md->tcpfileConnection= g_list_append(md->tcpfileConnection,mtfc);
	}		
	mtfc->choosefile_dialog = file_selector;	

	g_object_set_data(G_OBJECT (GTK_FILE_SELECTION(file_selector)->ok_button),"user_data", file_selector);
	g_signal_connect (G_OBJECT (GTK_FILE_SELECTION(file_selector)->ok_button),
   			   "clicked", G_CALLBACK (sendfile_choosefile_ok), mtfc);
	g_signal_connect (G_OBJECT (GTK_FILE_SELECTION(file_selector)->cancel_button),
   			   "clicked", G_CALLBACK (sendfile_choosefile_cancel), mtfc);
	g_signal_connect (G_OBJECT (file_selector),
   			   "delete_event", G_CALLBACK (sendfile_choosefile_delete_event), mtfc);   

	gtk_widget_show (file_selector);		
}

static void myicq_tcp_sendfile_got_connect(gpointer data, gint source, GaimInputCondition cond)
{
	struct _gc_and_qid *gq = data;
	struct gaim_connection *gc = gq->gc;
	struct myicq_data *md = gc->proto_data;
	
	if (source == -1 || !g_slist_find(connections, gc)) {
		close(source);
		do_error_dialog(_("Send file"), _("Connect failed"), GAIM_ERROR);
		g_free(gq->domain);
		g_free(gq);
		return;
	}
	
	if (myicq_send_tcp_packet_hello(source,md,TRUE)<=0)
	{
		close(source);
		do_error_dialog(_("Send file"), _("Connect error,send packet error"), GAIM_ERROR);
		g_free(gq->domain);
		g_free(gq);		
		return;
	}
	
	sendfile_choosefile_show(gc,NULL,source);	
	
	g_free(gq->domain);
	g_free(gq);	
}

static void myicq_tcp_msg_got_connect(gpointer data, gint source, GaimInputCondition cond)
{
	struct myicq_msgpacket *packet = data;
	struct gaim_connection *gc = packet->gc;
	struct myicq_data *md = gc->proto_data;
	struct myicq_tcpmsgconnection *mtmc;
	
	if (source == -1 || !g_slist_find(connections, gc)) {
		close(source);
		myicq_send_packet_msg(packet->type,packet->to_uin, packet->to_uin_domain, packet->message, packet->gc); // connect to user fail,send message to server.
		g_free(packet->to_uin_domain);
		g_free(packet->message);
		g_free(packet);
		return;
	}
	
	if (myicq_send_tcp_packet_hello(source,md,TRUE)<=0)
	{
		myicq_send_packet_msg(packet->type, packet->to_uin, packet->to_uin_domain, packet->message, packet->gc); // send direct to user fail,send message to server.
		g_free(packet->to_uin_domain);
		g_free(packet->message);
		g_free(packet);		
		debug_printf("MyICQ: send hello packet fail!\n");
		return;
	}

		
	debug_printf("MyICQ: tcp msg got connect!!\n");
	
		
	mtmc = g_new0(struct myicq_tcpmsgconnection,1);
		
	mtmc->connsock=source;
	mtmc->gc = gc;
	mtmc->msgID = 0xFFffFFff;
	mtmc->uin = packet->to_uin;
	mtmc->domain = g_strdup(packet->to_uin_domain);
	mtmc->isSend = TRUE;
	md->tcpmsgConnection= g_list_append(md->tcpmsgConnection,mtmc);
	
	myicq_send_tcp_msg_packet(packet->type,packet->message,mtmc); //send to user,this should be ok.and even fail,it will add to queue.
	
	mtmc->inpa = gaim_input_add(mtmc->connsock, GAIM_INPUT_READ, myicq_tcp_msg_pending, mtmc);

	g_free(packet->to_uin_domain);
	g_free(packet->message);
	g_free(packet);
}

static void myicq_tcp_msg_got_acceptable(gpointer data, gint source, GaimInputCondition cond)
{
	struct gaim_connection *gc = data;
	struct myicq_data *md = gc->proto_data;
	int ts;
		
	debug_printf("MyICQ: tcp msg got acceptable!\n");

	
	ts = accept( source, NULL, NULL );	 // accept connection if there is one

	if( ts < 0 )
	{
		debug_printf("MyICQ: accept connection error!\n");
	}	
	else
	{	
		struct myicq_tcpmsgconnection *mtmc;
		
		mtmc = g_new0(struct myicq_tcpmsgconnection,1);
		
		mtmc->connsock=ts;
		mtmc->gc = gc;
		mtmc->msgID = 0xFFffFFff;
		md->tcpmsgConnection= g_list_append(md->tcpmsgConnection,mtmc);
		mtmc->inpa = gaim_input_add(mtmc->connsock, GAIM_INPUT_READ, myicq_tcp_msg_pending, mtmc);
	}
}

static void myicq_tcp_file_got_acceptable(gpointer data, gint source, GaimInputCondition cond)
{	
	struct gaim_connection *gc = data;
	struct myicq_data *md = gc->proto_data;
	int ts;
		
	debug_printf("MyICQ: tcp file got acceptable!\n");
	
	ts = accept( source, NULL, NULL );	 // accept connection if there is one

	if (md->filelistenInpa)
	{
		gaim_input_remove(md->filelistenInpa);
		md->filelistenInpa=0;
	}

	if( ts < 0 )
	{
		debug_printf("MyICQ: accept connection error!\n");
	}	
	else
	{	
		struct myicq_tcpfileconnection *mtfc;
		mtfc = g_new0(struct myicq_tcpfileconnection, 1);
		mtfc->gc = gc;		
		mtfc->connsock=ts;
		md->tcpfileConnection= g_list_append(md->tcpfileConnection,mtfc);
		
		mtfc->inpa = gaim_input_add(mtfc->connsock, GAIM_INPUT_READ, myicq_tcp_file_pending, mtfc);
	}
}

static int myicq_establish(unsigned short portnum)
{
	int s=-1,i;
	struct sockaddr_in sa;

	for (i=0;i<10;i++)
	{
		memset(&sa, 0, sizeof(struct sockaddr_in)); // clear our address

		sa.sin_family = AF_INET;
		sa.sin_port = htons (portnum+i);
		sa.sin_addr.s_addr = htonl (INADDR_ANY);

		// create socket
		if ((s = socket(AF_INET, SOCK_STREAM, 0)) < 0)
			continue;

		// bind address to socket
		if (bind(s,(struct sockaddr*)&sa,sizeof(struct sockaddr_in)) < 0) 
		{
			close(s);
			continue;
		}

		// listen, max # of queued connects
		listen(s, 100);
		break;
	}

	return(s);
}

struct _gc_qid_and_port
{
	uint32 uin;
	gchar *domain;
	struct gaim_connection *gc;
	int port;
};

static uint16 myicq_create_tcp_filelisten_sock(struct gaim_connection *gc);
	
static void receivefile_accept(struct _gc_qid_and_port *gqp)
{
	char text[256];
	GList *list;
	struct myicq_data *md = gqp->gc->proto_data;
	struct myicq_buddy *buddy;
	uint32 real_ip;
	struct myicq_tcpmsgconnection *mtmc=NULL;
	gboolean senddirect=FALSE;
		
	list = md->onlinebuddy;
	while (list)
	{
		buddy= (struct myicq_buddy *)(list->data);
		if ((buddy->uin==gqp->uin)&&(!strcasecmp(buddy->domain,gqp->domain)))
		{
			real_ip=buddy->real_ip;
			break;
		}
		list=list->next;
	}
	if (!list) //this should not happen.
	{
		debug_printf("MyICQ: error: can't get contact's ip info!\n");
		g_free(gqp->domain);
		g_free(gqp);
		return;
	}

	if (gqp->port) // i am in a firewall,so the sender established a port wait me to connect.
	{
		struct in_addr in;
		char ipaddr[256];
		int fd;
		
		in.s_addr = htonl(real_ip);
		sprintf(ipaddr,"%s",inet_ntoa(in));
		fd = proxy_connect(gqp->gc->account, ipaddr, (int)gqp->port, myicq_tcp_file_got_connect, gqp->gc);
		if (fd < 0) {
			debug_printf("MyICQ: connect fail!!\n");		
			g_free(gqp->domain);
			g_free(gqp);
			return;
		}		
		
		gqp->port = 0;
	}
	else  //createListenSession
	{
		gqp->port = myicq_create_tcp_filelisten_sock(gqp->gc);
		if (gqp->port<0)
		{
			g_free(gqp->domain);
			g_free(gqp);
			return;
		}
	}

	sprintf(text,"sendfile\xFF%d",gqp->port);


	list = md->tcpmsgConnection;
	while (list)
	{
		mtmc = (struct myicq_tcpmsgconnection *)(list->data);
		if ((mtmc->uin==gqp->uin)&&(!strcasecmp(mtmc->domain,gqp->domain))) //already have direct tcp connection.
		{
			senddirect = TRUE;
			break;
		}
		list=list->next;
	}
	if (senddirect)
	{
		myicq_send_tcp_msg_packet(MSG_TCP_ACCEPTED,text,mtmc);
	}
	else
	{
		myicq_send_packet_msg(MSG_TCP_ACCEPTED,gqp->uin, gqp->domain, text,gqp->gc);
	}
	
	g_free(gqp->domain);
	g_free(gqp);
}

static void receivefile_reject(struct _gc_qid_and_port *gqp)
{
	g_free(gqp->domain);
	g_free(gqp);	
}

static void
myicq_on_msgTcpAccepted(uint32 from_uin, gchar *from_uin_domain, const char *sessionname, int port,struct gaim_connection *gc)
{	
	if (!strcmp(sessionname,"sendfile"))
	{
		if (port>0)
		{
			if (!myicq_send_file_connect(from_uin, from_uin_domain, port,gc))
				do_error_dialog(_("Send file"), _("Connect failed"), GAIM_ERROR);
		}
		else //remote is behind a firewall,i already established a port waiting for him.
		{			
		}
	}
	else
	{
		debug_printf("MyICQ: unknow tcp accepted session!\n");
	}		
}

static uint16
myicq_create_tcp_msglisten_sock(struct gaim_connection *gc)
{
	struct myicq_data *md = gc->proto_data;

	struct sockaddr_in addr;
	socklen_t addrLen = sizeof(addr);
		
	int sock;
	uint16 port;
	
	if (md->msglistenSock >=0)
		return md->msglistenSock;
	
	sock = myicq_establish(32765); //the port should be ..?
	if (sock<0)
	{
		debug_printf("MyICQ: createlistensession fail!\n");
		return -1;
	}
	md->msglistenSock = sock;

	md->msglistenInpa = gaim_input_add(md->msglistenSock, GAIM_INPUT_READ, myicq_tcp_msg_got_acceptable, gc);
		
	getsockname(md->msglistenSock, (struct sockaddr *)&addr, &addrLen);
	port = ntohs(addr.sin_port);
	debug_printf("MyICQ: CreateMsgListenSession OK! port: %d\n",port);	
	return port;
}

static uint16
myicq_create_tcp_filelisten_sock(struct gaim_connection *gc)
{
	struct myicq_data *md = gc->proto_data;
	struct sockaddr_in addr;
	socklen_t addrLen = sizeof(addr);
	uint16 port;
		
	if (md->filelistenSock>=0) //already build listen sock
	{
		if (md->filelistenInpa)
			gaim_input_remove(md->filelistenInpa);
	}
	else
	{
		int sock;
		sock = myicq_establish(33765); //the port should be ..?
		if (sock<0)
		{
			debug_printf("MyICQ: createlistensession fail!\n");
			return -1;
		}
		md->filelistenSock = sock;
	}
	md->filelistenInpa = gaim_input_add(md->filelistenSock, GAIM_INPUT_READ, myicq_tcp_file_got_acceptable, gc);
		
	getsockname(md->filelistenSock, (struct sockaddr *)&addr, &addrLen);
	port = ntohs(addr.sin_port);
	debug_printf("MyICQ: CreateFileListenSession OK! port: %d\n",port);
	return port;
}

static void myicq_process_tcp_msgRecv(char *buf, int buflen, uint32 from_uin, struct myicq_tcpmsgconnection *mtmc)
{
	struct gaim_connection *gc= mtmc->gc;
	struct myicq_data *md = gc->proto_data;
	char *cursor = buf;
	uint8 type;
	uint32 id,time;
	char *text;
	char bud[256],dlg_text[256];
	
	myicq_read_packet_dw(buf, &cursor, buflen, &id);
	
	myicq_send_tcp_msg_packet_ack(id,mtmc);
	
	myicq_read_packet_b(buf, &cursor, buflen, &type);
	myicq_read_packet_dw(buf, &cursor, buflen, &time);
	myicq_read_packet_str(buf, &cursor, buflen, &text);
	
	if (strcasecmp(mtmc->domain,md->domain))
		sprintf(bud,"%lu@%s",from_uin,mtmc->domain);
	else
		sprintf(bud,"%lu",from_uin);
	
	if (type == MSG_TEXT)
	{
		char *msg;		
		struct buddy *b = gaim_find_buddy(gc->account, bud);
		if (!b)
		{
			struct group *g;
			char group[256];
			sprintf(group,_("%s misc"),gc->username);
			if (!(g = gaim_find_group(group))) {
				g = gaim_group_new(group);
				gaim_blist_add_group(g, NULL);
			}
			b = gaim_buddy_new(gc->account, bud, NULL);
			gaim_blist_add_buddy(b,g,NULL);
		}
		debug_printf("MyICQ: receive tcp msg MSG_TEXT\n");		
		msg = myicq_msg_text_decode(text);
		serv_got_im(gc, bud, msg, IM_FLAG_GAIMUSER, time, -1);
		g_free(msg);		
	}
	else if (type == MSG_AUTO_REPLY)
	{
		char *msg;
		msg = g_locale_to_utf8(text,-1,NULL,NULL,NULL);
		serv_got_im(gc, bud, msg, IM_FLAG_AWAY, time, -1);
		g_free(msg);
	}
	else if (type == MSG_TCP_REQUEST)
	{
		char *a,*b;
		debug_printf("MyICQ: receive tcp msg MSG_TCP_REQUEST\n");
		a= strchr(text,'\xFF');
		*a = '\0';
		if (!strcmp(text,"sendfile"))
		{
			struct _gc_qid_and_port *gqp;
			gchar *reason;
				
			a++;
			b= strchr(a,'\xFF');
			*b = '\0';
			reason = g_locale_to_utf8(a,-1,NULL,NULL,NULL);
			sprintf(dlg_text,_("To %s:\n%lu want to send file to you.\nreason: %s"),gc->username,from_uin,reason);
			gqp= g_new(struct _gc_qid_and_port,1);
			gqp->uin=from_uin;
			gqp->domain = g_strdup(mtmc->domain);
			gqp->gc=gc;
			gqp->port=atoi(b+1);
			debug_printf("MyICQ: port: %d!!!!\n",gqp->port);			
			do_ask_dialog(dlg_text, _("Receive file?"),gqp, _("Receive"), receivefile_accept, _("Cancel"), receivefile_reject, my_protocol->plug ? my_protocol->plug->handle : NULL, FALSE);
			g_free(reason);
		}
	}
	else if (type == MSG_TCP_ACCEPTED)
	{
		char *a;
		debug_printf("MyICQ: receive tcp msg MSG_TCP_ACCEPTED\n");
		a= strchr(text,'\xFF');
		if (a)
			*a = '\0';
		myicq_on_msgTcpAccepted(from_uin, mtmc->domain, text,atoi(a+1),gc);
	}
	else if (type == MSG_TCP_REJECTED)
	{
		debug_printf("MyICQ: receive tcp msg MSG_TCP_REJECTED\n");
	}
}

static void myicq_process_tcp_msgAck(char *buf, int buflen, uint32 from_uin, struct myicq_tcpmsgconnection *mtmc)
{
	struct gaim_connection *gc= mtmc->gc;
	char *cursor = buf;
	uint32 id;
	
	myicq_read_packet_dw(buf, &cursor, buflen, &id);
	
	if (myicq_tcpmsgsendqueue_remove((struct myicq_data *)(gc->proto_data), id , from_uin , mtmc->domain))
		debug_printf("MyICQ: tcp packet %lu to user %lu is acked\n",id,from_uin);
	else
		debug_printf("MyICQ: tcp ack packet %lu is ignored\n",id);
}

static void myicq_process_tcp_msgHello(char *buf, int buflen, uint32 from_uin, struct myicq_tcpmsgconnection *mtmc)
{
	struct myicq_data *md = mtmc->gc->proto_data;
	char *cursor = buf;
	uint8 isSend;
	gchar *domain;
	
	mtmc->uin = from_uin;
	
	myicq_read_packet_b(buf, &cursor, buflen, &isSend);
	myicq_read_packet_str(buf, &cursor, buflen, &domain);
	if (domain[0])
		mtmc->domain= g_strdup(domain);
	else
		mtmc->domain= g_strdup(md->domain);

	debug_printf("MyICQ: receive tcp msg Hello packet, isSend: %d\n",isSend);
	mtmc->isSend = (!isSend);
}

static void myicq_process_recvMessage(char *buf, int buflen, struct gaim_connection *gc)
{
	struct myicq_data *md = gc->proto_data;
	char *cursor = buf;
	uint8 type;
	uint32 from_uin;
	uint32 time;
	char *text;
	char bud[256],dlg_text[256];
	char group[256];
	gchar *domain;
	
	myicq_read_packet_b(buf, &cursor, buflen, &type);
	myicq_read_packet_dw(buf, &cursor, buflen, &from_uin);	
	myicq_read_packet_dw(buf, &cursor, buflen, &time);	
	myicq_read_packet_str(buf, &cursor, buflen, &text);
	myicq_read_packet_str(buf, &cursor, buflen, &domain);
	if (domain[0])
	{
		sprintf(bud,"%lu@%s",from_uin,domain);	
	}
	else
	{
		sprintf(bud,"%lu",from_uin);	
		domain= md->domain;
	}
	
	if (type == MSG_TEXT)
	{
		char *msg;
		
		struct buddy *b = gaim_find_buddy(gc->account, bud);
		if (!b)
		{
			struct group *g;
			char group[256];
			sprintf(group,_("%s misc"),gc->username);
			if (!(g = gaim_find_group(group))) {
				g = gaim_group_new(group);
				gaim_blist_add_group(g, NULL);
			}
			b = gaim_buddy_new(gc->account, bud, NULL);
			gaim_blist_add_buddy(b,g,NULL);
		}
		msg = myicq_msg_text_decode(text);
		serv_got_im(gc, bud, msg, IM_FLAG_GAIMUSER, time, -1);
		g_free(msg);				
	}
	else if (type == MSG_AUTO_REPLY)
	{
		char *msg;
		msg = g_locale_to_utf8(text,-1,NULL,NULL,NULL);
		serv_got_im(gc, bud, msg, IM_FLAG_AWAY, time, -1);
		g_free(msg);
	}
	else if (type == MSG_AUTH_ACCEPTED) // i think this should never happem,it should use UDP_ADD_FRIEND.
	{
		struct buddy *bdy;

		if ((md->searchDlg)&&(md->searchDlg->nb_current_page == NB_ADD_FRIEND)&&(!strcasecmp(bud,gtk_label_get_text(GTK_LABEL(md->searchDlg->add_friend_uin_label))))) //when search dialog is show.
		{
			sprintf(dlg_text,_("%s have accepted your add friend request."),bud);
			gtk_label_set_text(GTK_LABEL(md->searchDlg->add_friend_info_label),dlg_text);
		}
		else
		{
			sprintf(dlg_text,_("To %s:\n%s have accepted your add friend request."),gc->username,bud);
			do_error_dialog(_("Add friend success"), dlg_text, GAIM_INFO);
		}

		bdy= gaim_find_buddy(gc->account, bud);
		if (!bdy)
		{
			struct group *g;
			sprintf(group,_("%s friends"),gc->username);			
			if (!(g = gaim_find_group(group))) {
				g = gaim_group_new(group);
				gaim_blist_add_group(g, NULL);
			}
			bdy = gaim_buddy_new(gc->account, bud, NULL);
			gaim_blist_add_buddy(bdy,g,NULL);
		}
		myicq_send_packet_updateContact(from_uin, domain, gc);
	}
	else if (type == MSG_AUTH_REQUEST)
	{
		struct _gc_and_qid *gq;
		char *a,*b;
		gchar *reason,*nick;
		a= strchr(text,'\xFF')+1; //ignore face.
		b= strchr(a,'\xFF');
		*b= '\0';
		nick = g_locale_to_utf8(a,-1,NULL,NULL,NULL);
		reason = g_locale_to_utf8(b+1,-1,NULL,NULL,NULL);
		snprintf(dlg_text,sizeof(dlg_text), _("To %s:\n%s (%s) want to add you to his contact list:\n%s\ndo you want to accept his request?"),gc->username,bud,nick,reason);
		g_free(nick);
		g_free(reason);
		gq= g_new(struct _gc_and_qid,1);
		gq->uin=from_uin;
		gq->domain= g_strdup(domain);
		gq->gc=gc;
		do_ask_dialog(dlg_text, _("Accept authorization?"),gq, _("Accept"), myicq_addFriendAuthReq_accept, _("Reject"), myicq_addFriendAuthReq_reject, my_protocol->plug ? my_protocol->plug->handle : NULL, FALSE);		
	}
	else if (type == MSG_AUTH_REJECTED)
	{
		gchar *reason;
		reason = g_locale_to_utf8(text,-1,NULL,NULL,NULL);
		snprintf(dlg_text,sizeof(dlg_text),_("To %s:\n%s have rejected your add friend request.\nreason: %s"),gc->username,bud,reason);
		do_error_dialog(_("Add friend failed"), dlg_text, GAIM_INFO);
		g_free(reason);
	}
	else if (type == MSG_ADDED)
	{
		show_got_added(gc, NULL, bud, NULL, NULL);
	}
	else if (type == MSG_TCP_REQUEST)
	{
		char *a,*b;
		a= strchr(text,'\xFF');
		if (a)
			*a = '\0';
		if (!strcmp(text,"sendfile"))
		{
			struct _gc_qid_and_port *gqp;
			gchar *reason;
				
			a++;
			b= strchr(a,'\xFF');
			*b = '\0';
			reason = g_locale_to_utf8(a,-1,NULL,NULL,NULL);
			snprintf(dlg_text,sizeof(dlg_text), _("To %s:\n%s want to send file to you.\nreason: %s"),gc->username,bud,reason);
			gqp= g_new(struct _gc_qid_and_port,1);
			gqp->uin=from_uin;
			gqp->domain = g_strdup(domain);
			gqp->gc=gc;
			gqp->port=atoi(b+1);
			debug_printf("MyICQ: port: %d!!!!\n",gqp->port);
			do_ask_dialog(dlg_text, _("Receive file?"),gqp, _("Receive"), receivefile_accept, _("Cancel"), receivefile_reject, my_protocol->plug ? my_protocol->plug->handle : NULL, FALSE);
			g_free(reason);
		}
	}
	else if (type == MSG_TCP_ACCEPTED)
	{
		char *a;
		a= strchr(text,'\xFF');
		if (a)
			*a = '\0';
		myicq_on_msgTcpAccepted(from_uin, domain, text, atoi(a+1), gc);
	}
	else if (type == MSG_TCP_REJECTED)
	{
		debug_printf("MyICQ: MSG_TCP_REJECTED");
	}
}

static void myicq_send_addFriendAuthReq_ok(gpointer data, char *entry)
{
	struct _gc_and_qid *gq= (struct _gc_and_qid *)data;
	gchar *reason;
	reason = g_locale_from_utf8(entry,-1,NULL,NULL,NULL);
	myicq_send_packet_msg(MSG_AUTH_REQUEST,gq->uin, gq->domain, reason,gq->gc);
	g_free(reason);
	//g_free(data); //this line is needn't,as when user click "Accept",gaim will call this,then call "cancel" function too.
}

static void myicq_send_addFriendAuthReq_cancel(struct _gc_and_qid *gq)
{
	g_free(gq->domain);
	g_free(gq);
}

static void myicq_process_addFriendReply(char *buf, int buflen, struct gaim_connection *gc)
{
	struct myicq_data *md = gc->proto_data;
	char *cursor = buf;
	uint8 result;
	uint32 uin;
	char msg[256];
	char bud[256],group[256];
	struct buddy *b;
	char def[256];	
	struct _gc_and_qid *gq;	
	gchar *domain;
	gboolean in_search_dialog;
		
	myicq_read_packet_dw(buf, &cursor, buflen, &uin);
	myicq_read_packet_b(buf, &cursor, buflen, &result);
	myicq_read_packet_str(buf, &cursor, buflen, &domain);
	if (domain[0])
	{
		sprintf(bud,"%lu@%s",uin,domain);
	}
	else
	{
		sprintf(bud,"%lu",uin);
		domain= md->domain;
	}
	in_search_dialog = ((md->searchDlg)&&(md->searchDlg->nb_current_page == NB_ADD_FRIEND)&&(!strcasecmp(bud,gtk_label_get_text(GTK_LABEL(md->searchDlg->add_friend_uin_label))))); //when search dialog is show.
	
	if (result == ADD_FRIEND_ACCEPTED)
	{
		if (in_search_dialog)
		{
			snprintf(msg,sizeof(msg),_("%s have accepted your add friend request."),bud);
			gtk_label_set_text(GTK_LABEL(md->searchDlg->add_friend_info_label),msg);
		}
		else
		{
			snprintf(msg,sizeof(msg),_("To %s:\n%s have accepted your add friend request."),gc->username,bud);
			do_error_dialog(_("Add friend success"), msg, GAIM_INFO);
		}
			
		b=gaim_find_buddy(gc->account, bud);
		if (!b)
		{
			struct group *g;
			sprintf(group,_("%s friends"),gc->username);
			if (!(g = gaim_find_group(group))) {
				g = gaim_group_new(group);
				gaim_blist_add_group(g, NULL);
			}
			b = gaim_buddy_new(gc->account, bud, NULL);
			gaim_blist_add_buddy(b,g,NULL);
		}
		myicq_send_packet_updateContact(uin, domain, gc);
	}
	else if (result == ADD_FRIEND_AUTH_REQ)
	{
		if (in_search_dialog)
		{
			snprintf(msg,sizeof(msg),_("Authorization is required for your previous add friend request.\ntyping your auth msg if you want to add %s to your friend list."),bud);
			gtk_label_set_text(GTK_LABEL(md->searchDlg->add_friend_info_label),msg);
			gtk_widget_set_sensitive(md->searchDlg->add_friend_hbox,TRUE);
			gtk_widget_show(md->searchDlg->add_friend_hbox);
		}
		else
		{
			snprintf(msg,sizeof(msg),_("To %s:\nauthorization is required for your previous add friend request.\ntyping your auth msg if you want to add %s to your friend list."),gc->username,bud);
			snprintf(def,sizeof(def),_("I am %s (%s),can i make friend with you?"),gc->username,gc->displayname);
			gq= g_new(struct _gc_and_qid,1);
			gq->uin=uin;
			gq->domain = g_strdup(domain);
			gq->gc=gc;
			do_prompt_dialog(msg, def, gq, myicq_send_addFriendAuthReq_ok, myicq_send_addFriendAuthReq_cancel);
		}
	}
	else if (result == ADD_FRIEND_REJECTED)
	{
		if (in_search_dialog)
		{
			snprintf(msg,sizeof(msg),_("%s have rejected your add friend request."),bud);
			gtk_label_set_text(GTK_LABEL(md->searchDlg->add_friend_info_label),msg);
		}
		else
		{
			snprintf(msg,sizeof(msg),_("To %s:\n%s have rejected your add friend request."),gc->username,bud);
			do_error_dialog(_("Add friend failed"), msg, GAIM_INFO);
		}
	}
}

static void myicq_process_updateContactReply(int is_myself, char *buf, int buflen, struct gaim_connection *gc)
{
	char *cursor = buf;
	struct ContactInfo info;
	struct myicq_data *md = gc->proto_data;
	GList *list;
	struct _updatingContactInfo *updateinfo;
	char *nick;
	
	if (is_myself)
		info.uin = md->myuin;
	else
		myicq_read_packet_dw(buf, &cursor, buflen, &info.uin);
	
	myicq_read_packet_b(buf, &cursor, buflen, &info.face);
	myicq_read_packet_str(buf, &cursor, buflen, &info.nick);
	myicq_read_packet_b(buf, &cursor, buflen, &info.age);
	myicq_read_packet_b(buf, &cursor, buflen, &info.gender);
	myicq_read_packet_str(buf, &cursor, buflen, &info.country);
	myicq_read_packet_str(buf, &cursor, buflen, &info.province);
	myicq_read_packet_str(buf, &cursor, buflen, &info.city);
	myicq_read_packet_str(buf, &cursor, buflen, &info.email);
	myicq_read_packet_str(buf, &cursor, buflen, &info.address);
	myicq_read_packet_str(buf, &cursor, buflen, &info.zipcode);
	myicq_read_packet_str(buf, &cursor, buflen, &info.tel);
	myicq_read_packet_str(buf, &cursor, buflen, &info.name);
	myicq_read_packet_b(buf, &cursor, buflen, &info.blood);
	myicq_read_packet_str(buf, &cursor, buflen, &info.college);
	myicq_read_packet_str(buf, &cursor, buflen, &info.occupation);
	myicq_read_packet_str(buf, &cursor, buflen, &info.homepage);
	myicq_read_packet_str(buf, &cursor, buflen, &info.intro);
	if (is_myself)
	{
		myicq_read_packet_b(buf, &cursor, buflen, &info.auth);
	}
	
	myicq_read_packet_str(buf, &cursor, buflen, &info.domain);
	if ((info.domain)[0]=='\0')
		info.domain = md->domain;
	
	//debug_printf("user %s 's info:\nnick: %s email: %s homepage: %s introduce: %s\n",bud,info.nick,info.email,info.homepage,info.intro);
	
	list= md->updatingContactInfo;	
	while (list)
	{
		updateinfo = (struct _updatingContactInfo *)(list->data);
		if ((updateinfo->uin == info.uin)&&(!strcasecmp(updateinfo->domain,info.domain)))
		{
			if (updateinfo->window)
			{
				myicq_refresh_contact_info_dialog(&info,gc,updateinfo); //refresh info dialog.
			}
			else
			{
				myicq_show_contact_info_dialog(&info,gc,updateinfo); //only show info dialog when click by user.
			}
			break;
		}
		else
		{
			list = list->next;
		}
	}
	
	myicq_save_contact_info(is_myself,&info);	//save those user information to file.

	nick = g_locale_to_utf8(info.nick,-1,NULL,NULL,NULL);
	if (!is_myself)
	{
		char bud[256];
		struct buddy *b;
		
		if (strcasecmp(info.domain,md->domain))		
			sprintf(bud,"%lu@%s",info.uin,info.domain);
		else
			sprintf(bud,"%lu",info.uin);
		b=gaim_find_buddy(gc->account, bud);
		if (!b)
		{			
			//gchar *group[256];
			//sprintf(group,_("%s misc"),gc->username);
			//add_buddy(gc->account, group, bud, nick);
		}
		else
		{
			serv_got_alias(gc,bud,nick); //this seems will not save the setting.
			/*
			if (b->present)
			{
				gaim_blist_update_buddy_icon(b); // refresh head icon.
			}
			*/
		}		
	}
	else
	{
		md->face = info.face; //refresh face cache.
		strcpy(gc->displayname,nick);
	}
	g_free(nick);
}

static void myicq_process_searchReply(char *buf, int buflen, struct gaim_connection *gc)
{
	struct myicq_data *md = gc->proto_data;
	
	if ((md->searchDlg)&&(md->searchDlg->nb_current_page == NB_USER_LIST)) //when search dialog is show.
	{
		char *cursor = buf;
		uint16 num;
		gchar *str;
		int i;
		struct search_user_info *user;
		GSList *user_info_list=NULL;

		myicq_read_packet_w(buf, &cursor, buflen, &num);
		for (i=0; i< num; i++)
		{
			user = g_new(struct search_user_info,1);
			myicq_read_packet_dw(buf, &cursor, buflen, &(user->uin));
			myicq_read_packet_b(buf, &cursor, buflen, &(user->online));
			myicq_read_packet_b(buf, &cursor, buflen, &(user->face));
			myicq_read_packet_str(buf, &cursor, buflen, &str);
			user->nick = g_locale_to_utf8(str,-1,NULL,NULL,NULL);
			myicq_read_packet_str(buf, &cursor, buflen, &str);
			user->province = g_locale_to_utf8(str,-1,NULL,NULL,NULL);
			user_info_list = g_slist_append(user_info_list,user);
		}
		md->searchDlg->search_user_result_page_list = g_slist_append(md->searchDlg->search_user_result_page_list,user_info_list);
		search_dialog_refresh_search_user_result(md->searchDlg,g_slist_length(md->searchDlg->search_user_result_page_list)-1); //show last page
	}
}

static void myicq_process_contactListReply(char *buf, int buflen, struct gaim_connection *gc)
{
	struct myicq_data *md = gc->proto_data;
	char *cursor = buf;
	uint16 num;
	uint32 uin;
	int i;
	char bud[256],group[256];
	
	myicq_read_packet_w(buf, &cursor, buflen, &num);
	for (i=0; i< num; i++)
	{
		myicq_read_packet_dw(buf, &cursor, buflen, &uin);
		if (uin == 0)
			continue;
		sprintf(bud,"%lu",uin);
		struct buddy *b = gaim_find_buddy(gc->account, bud);
		if (!b)
		{
			struct group *g;
			sprintf(group,_("%s friends"),gc->username);
			if (!(g = gaim_find_group(group))) {
				g = gaim_group_new(group);
				gaim_blist_add_group(g, NULL);
			}
			b = gaim_buddy_new(gc->account, bud, NULL);
			gaim_blist_add_buddy(b,g,NULL);
			myicq_send_packet_updateContact(uin, md->domain, gc);
		}
		
	}
}

static void myicq_process_remoteContactListReply(char *buf, int buflen, struct gaim_connection *gc)
{
	struct myicq_data *md = gc->proto_data;
	char *cursor = buf;
	uint16 num;
	uint32 uin;
	gchar *domain;
	int i;
	char bud[256],group[256];
	
	myicq_read_packet_str(buf, &cursor, buflen, &domain);
	if (strcmp(domain,md->domain))
	{	
		GSList *list;
		struct gaim_account *a;

		strcpy(md->domain,domain);
		sprintf(gc->username,"%lu@%s",md->myuin,domain);
		
		list = gaim_accounts; // this is not a good but working way as gaim didn't support better api.
		while (list)
		{
			a = (struct gaim_account *)(list->data);
			if (a->gc==gc)
			{
				sprintf(a->username,"%lu@%s",md->myuin,domain);
				save_prefs();
				break;
			}
			list = list->next;
		}
	}
	sprintf(group,_("%s friends"),gc->username);
	struct group *g;
	if (!(g = gaim_find_group(group))) {
		g = gaim_group_new(group);
		gaim_blist_add_group(g, NULL);
	}

	myicq_read_packet_w(buf, &cursor, buflen, &num);
	for (i=0; i< num; i++)
	{
		myicq_read_packet_dw(buf, &cursor, buflen, &uin);
		myicq_read_packet_str(buf, &cursor, buflen, &domain);
		if ((uin == 0)||(!domain)||(domain[0]=='\0'))
			continue;
		sprintf(bud,"%lu@%s",uin,domain);
		struct buddy *b = gaim_find_buddy(gc->account, bud);
		if (!b)
		{
			struct group *g;
			if (!(g = gaim_find_group(group))) {				
				g = gaim_group_new(group);
				gaim_blist_add_group(g, NULL);
			}
			b = gaim_buddy_new(gc->account, bud, NULL);
			gaim_blist_add_buddy(b,g,NULL);
			myicq_send_packet_updateContact(uin, domain, gc);
		}		
	}
}

static void myicq_process_keepAliveReply(char *buf, int buflen, struct gaim_connection *gc)
{
	struct myicq_data *md = gc->proto_data;
	char *cursor = buf;

	myicq_read_packet_dw(buf, &cursor, buflen, &md->sessionCount);
	
	if (!md->online)
	{
		char msg[256];
		sprintf(msg,_("To %s :\nUDP_KEEPALIVE packet have send successful!\nyour network connected again!"),gc->username);
		do_error_dialog(_("You are online again!"), msg, GAIM_INFO);
		md->online= TRUE;
	}
}

static int myicq_process_newNINReply(char *buf, int buflen, struct gaim_connection *gc)
{
	char *cursor = buf;
	uint32 uin;	

	myicq_read_packet_dw(buf, &cursor, buflen, &uin);
	if (uin == 0)
	{
		hide_login_progress(gc, _("Register fail,the server encounter some error!"));
		signoff(gc);
		return 1;
	}
	else
	{
		struct myicq_data *md = gc->proto_data;
		char text[256];
		GSList *list;
		struct gaim_account *a;
		gchar *domain;
		gchar group[256];
		
		myicq_read_packet_str(buf, &cursor, buflen, &domain);
		sprintf(text,_("\nRegister successful!\n your uin: %lu@%s password: %s\nPlease select \"tools menu->protocol actions->my information\" to set your information."),uin,domain,gc->password);
		do_error_dialog(_("Register successful"), text, GAIM_INFO);

		list = gaim_accounts; // this is not a good but working way as gaim didn't support better api.
		while (list)
		{
			a = (struct gaim_account *)(list->data);
			if (a->gc==gc)
			{
				sprintf(a->username,"%lu@%s",uin,domain);
				save_prefs();
				break;
			}
			list = list->next;
		}
		set_login_progress(gc, 3,_("Register new user successful! logging..."));		
		md->myuin = uin;
		sprintf(gc->username,"%lu@%s",uin,domain);
		strcpy(md->domain,domain);
		sprintf(group,_("%s friends"),gc->username);
		struct group *g;
		if (!(g = gaim_find_group(group))) {
			g = gaim_group_new(group);
			gaim_blist_add_group(g, NULL);
		}
		myicq_send_packet_logout(gc);
		myicq_send_packet_login(gc); // after register new uin successful,do login.
		return 0;
	}
}

static int myicq_process_loginReply(char *buf, int buflen, struct gaim_connection *gc)
{
	struct myicq_data *md = gc->proto_data;
	char *cursor = buf;
	uint8 error;
	uint32 ip;

	myicq_read_packet_b(buf, &cursor, buflen, &error);
	if (error == LOGIN_INVALID_UIN)
	{
		hide_login_progress(gc, _("Invalid user"));
		signoff(gc);
		return 1;
	}
	else if (error == LOGIN_WRONG_PASSWD)
	{
		hide_login_progress(gc, _("Password is wrong"));
		signoff(gc);
		return 1;
	}
	else if (error== LOGIN_SUCCESS)
	{
		char dir[256];
		
		myicq_read_packet_dw(buf, &cursor, buflen, &ip);
		myicq_read_packet_dw(buf, &cursor, buflen, &md->sessionCount);
		
		md->ourIP = ip; // ip from the server's point of view, in case of NAT, this is different from our real ip
		debug_printf("MyICQ: login success\n");
		account_online(gc);
		serv_finish_login(gc);
		
		
		sprintf(dir,"%s/myicq/%s.dat",gaim_user_dir(),gc->username);
		if (!g_file_test(dir,G_FILE_TEST_EXISTS))
		{
			myicq_send_packet_getRemoteContactList(gc);
			myicq_send_packet_getContactList(gc);
			myicq_send_packet_updateUser(gc);
		}
		
		md->logged_in = TRUE; //this line shoud be execute after do_import().
	}
	else
	{
		hide_login_progress(gc, _("Unknow login reply"));
		signoff(gc);
		return 1;
	}
	return 0;
}

static void myicq_process_getServerList(char *buf, int buflen, struct gaim_connection *gc)
{
	struct myicq_data *md = gc->proto_data;
	
	if (md->searchDlg) //when search dialog is show.
	{
		char *cursor = buf;
		uint16 num;
		gchar *str;
		int i;
		struct search_server_info *server;

		md->searchDlg->have_server_list = TRUE;
		myicq_read_packet_w(buf, &cursor, buflen, &num);
		for (i=0; i< num; i++)
		{
			server = g_new(struct search_server_info,1);
			myicq_read_packet_str(buf, &cursor, buflen, &str);
			server->domain = g_strdup(str);
			myicq_read_packet_str(buf, &cursor, buflen, &str);
			server->desc = g_locale_to_utf8(str,-1,NULL,NULL,NULL);
			myicq_read_packet_dw(buf, &cursor, buflen, &(server->sessionCount));
			md->searchDlg->search_server_list = g_slist_append(md->searchDlg->search_server_list,server);
		}
		search_dialog_refresh_search_server_result(md->searchDlg);
	}	
}

static void myicq_process_srvGroupTypes(char *buf, int buflen, struct gaim_connection *gc)
{
	struct myicq_data *md = gc->proto_data;
	char *cursor = buf;
	uint16 num;
	gint i;
	gchar *name,*displayname;
	struct serv_group_type *grouptype;

	myicq_read_packet_w(buf, &cursor, buflen, &num);
	for (i=0; i< num; i++)
	{
		myicq_read_packet_str(buf, &cursor, buflen, &name);
		myicq_read_packet_str(buf, &cursor, buflen, &displayname);
		grouptype = g_new(struct serv_group_type,1);
		grouptype->name = g_strdup(name);
		grouptype->displayname = g_locale_to_utf8(displayname,-1,NULL,NULL,NULL);
		md->servgrouptype = g_slist_append(md->servgrouptype,grouptype);
	}	
}

static void myicq_process_groupList(char *buf, int buflen, struct gaim_connection *gc)
{
	struct myicq_data *md = gc->proto_data;
	
	if ((md->searchDlg)&&(md->searchDlg->nb_current_page == NB_GROUP_LIST)) //when search dialog is show.
	{
		char *cursor = buf;
		uint16 num;
		gchar *str;
		int i;
		struct search_group_info *group;

		myicq_read_packet_w(buf, &cursor, buflen, &num);
		for (i=0; i< num; i++)
		{
			group = g_new(struct search_group_info,1);
			myicq_read_packet_dw(buf, &cursor, buflen, &(group->id));
			myicq_read_packet_str(buf, &cursor, buflen, &str);
			group->name = g_locale_to_utf8(str,-1,NULL,NULL,NULL);
			myicq_read_packet_w(buf, &cursor, buflen, &(group->num));
			md->searchDlg->search_group_list = g_slist_append(md->searchDlg->search_group_list,group);
		}
		search_dialog_refresh_search_group_result(md->searchDlg);
	}
}

static void myicq_process_searchGroup(char *buf, int buflen, struct gaim_connection *gc)
{
	struct myicq_data *md = gc->proto_data;
	
	if ((md->searchDlg)&&(md->searchDlg->nb_current_page == NB_GROUP_LIST)) //when search dialog is show.
	{
		char *cursor = buf;
		gchar *str;
		struct search_group_info *group;

		group = g_new(struct search_group_info,1);
		myicq_read_packet_dw(buf, &cursor, buflen, &(group->id));
		myicq_read_packet_str(buf, &cursor, buflen, &str);
		group->name = g_locale_to_utf8(str,-1,NULL,NULL,NULL);
		myicq_read_packet_w(buf, &cursor, buflen, &(group->type));
		myicq_read_packet_w(buf, &cursor, buflen, &(group->num));
		md->searchDlg->search_group_list = g_slist_append(md->searchDlg->search_group_list,group);
		search_dialog_refresh_search_group_result(md->searchDlg);
	}
}

static void myicq_process_createGroup(char *buf, int buflen, struct gaim_connection *gc)
{
	struct myicq_data *md = gc->proto_data;
	char *cursor = buf;
	uint32 id;
	gchar *str;
	struct gaim_conversation *c=NULL;
	
	myicq_read_packet_dw(buf, &cursor, buflen, &id);
	if (id!=0)
	{
		str = g_strdup_printf(_("Group %lu"),id);
		c = serv_got_joined_chat(gc,id,str);
		gaim_chat_add_user(GAIM_CHAT(c), gc->username, gc->displayname);
		g_free(str);
	}

	if ((md->searchDlg)&&(md->searchDlg->nb_current_page == NB_CREATE_GROUP_RESULT)) //when search dialog is show.
	{
		if (id==0)
		{
			gtk_label_set_text(GTK_LABEL(md->searchDlg->create_group_result_info_label),_("Create group failed!"));
		}
		else
		{
			gaim_chat_set_topic(GAIM_CHAT(c), gc->displayname, gtk_entry_get_text(GTK_ENTRY(md->searchDlg->create_group_name_entry)));
			str = g_strdup_printf(_("Created group successful,the group number is %lu.\nnotice: the group will be removed after everyone left the group."),id);
			gtk_label_set_text(GTK_LABEL(md->searchDlg->create_group_result_info_label),str);
			g_free(str);
		}		
	}
}

static void myicq_process_enterGroup(char *buf, int buflen, struct gaim_connection *gc)
{
	struct myicq_data *md = gc->proto_data;
	char *cursor = buf;
	uint32 id;
	uint16 error;

	
	myicq_read_packet_dw(buf, &cursor, buflen, &id);
	myicq_read_packet_w(buf, &cursor, buflen, &error);
	if (error==GROUP_ERROR_SUCCESS)
	{
		uint16 n;
		uint32 uin;
		uint8 face;
		gchar *str,*nick;
		gint i;
		gchar bud[256];
		struct gaim_conversation *c;

		myicq_read_packet_w(buf, &cursor, buflen, &n);		
		sprintf(bud,_("Group %lu"),id);
		c = serv_got_joined_chat(gc,id,bud);
		for (i=0;i<n;i++)
		{
			myicq_read_packet_dw(buf, &cursor, buflen, &uin);
			myicq_read_packet_b(buf, &cursor, buflen, &face);
			myicq_read_packet_str(buf, &cursor, buflen, &str);
			nick = g_locale_to_utf8(str,-1,NULL,NULL,NULL);
			sprintf(bud,"%lu",uin);
			gaim_chat_add_user(GAIM_CHAT(c), bud, nick);
			g_free(nick);
		}

		if ((md->searchDlg)&&(md->searchDlg->nb_current_page == NB_CREATE_GROUP_RESULT))
		{
			GtkTreeModel *model;
			GtkTreeIter iter;	
	
			if (gtk_tree_selection_get_selected (gtk_tree_view_get_selection (GTK_TREE_VIEW (md->searchDlg->group_list_treeview)), &model, &iter))
			{
				gchar *groupname;
				gtk_tree_model_get (model, &iter,1,&groupname,-1);
				gaim_chat_set_topic(GAIM_CHAT(c), gc->displayname, groupname);
				g_free(groupname);
			}
			str = g_strdup_printf(_("Enter group successful,the group number is %lu,with %d member in it."),id,n);
			gtk_label_set_text(GTK_LABEL(md->searchDlg->create_group_result_info_label),str);
			g_free(str);
		}
	}
	else
	{
		gchar *str;
		switch (error)
		{
			case GROUP_ERROR_NOT_EXIST:
				str = _("The group is not exist.");
				break;
			case GROUP_ERROR_ALREADY_EXIST:
				str = _("You have already entered this group.");
				break;
			case GROUP_ERROR_EXCEED_MAX_GROUPS:
				str = _("You have entered too many groups.");
				break;
			case GROUP_ERROR_WRONG_PASSWD:
				str = _("The password is wrong.");
				break;
			case GROUP_ERROR_EXCEED_MAX_MEMBERS:
				str = _("The group is is full,exceed max members.");
				break;
			default:
				str = _("Unknow error.");
				break;
		}			
		if ((md->searchDlg)&&(md->searchDlg->nb_current_page == NB_CREATE_GROUP_RESULT))
		{
			gchar *text;
			text = g_strdup_printf(_("Enter group failed:\n%s"),str);
			gtk_label_set_text(GTK_LABEL(md->searchDlg->create_group_result_info_label),text);
			g_free(text);
		}
		else
		{
			do_error_dialog(_("Enter group failed"), str, GAIM_ERROR);
		}
	}		
}

static void myicq_process_groupStart(char *buf, int buflen, struct gaim_connection *gc)
{
}

static void myicq_process_groupCmd(char *buf, int buflen, struct gaim_connection *gc)
{
}

static void myicq_process_groupMessage(char *buf, int buflen, struct gaim_connection *gc)
{
	char *cursor = buf;
	uint32 id, from, when;
	gchar *str,*text;
	gchar bud[32];

	myicq_read_packet_dw(buf, &cursor, buflen, &id);
	myicq_read_packet_dw(buf, &cursor, buflen, &from);
	myicq_read_packet_dw(buf, &cursor, buflen, &when);
	myicq_read_packet_str(buf, &cursor, buflen, &str);
	text = myicq_msg_text_decode(str);
	sprintf(bud,"%lu",from);
	serv_got_chat_in(gc, id, bud, FALSE, text, when);
	g_free(text);
}

static void myicq_process_srvEnterGroup(char *buf, int buflen, struct gaim_connection *gc)
{
	char *cursor = buf;
	uint32 id, uin;
	uint8 face;
	gchar *str,*nick;	
	gchar bud[32];
	struct gaim_conversation *c;

	myicq_read_packet_dw(buf, &cursor, buflen, &id);
	myicq_read_packet_dw(buf, &cursor, buflen, &uin);
	myicq_read_packet_b(buf, &cursor, buflen, &face);
	myicq_read_packet_str(buf, &cursor, buflen, &str);
	nick = g_locale_to_utf8(str,-1,NULL,NULL,NULL);
	c = gaim_find_chat(gc,id);
	if (!c)
	{
		sprintf(bud,_("Group %lu"),id);
		c = serv_got_joined_chat(gc,id,bud);
	}
	sprintf(bud,"%lu",uin);
	gaim_chat_add_user(GAIM_CHAT(c), bud, nick);
	g_free(nick);
}

static void myicq_process_srvExitGroup(char *buf, int buflen, struct gaim_connection *gc)
{
	char *cursor = buf;
	uint32 id, uin;
	gchar bud[32];
	struct gaim_conversation *c;

	myicq_read_packet_dw(buf, &cursor, buflen, &id);
	myicq_read_packet_dw(buf, &cursor, buflen, &uin);
	c = gaim_find_chat(gc,id);
	if (c)
	{		
		sprintf(bud,"%lu",uin);
		gaim_chat_remove_user(GAIM_CHAT(c), bud, NULL);
	}
}

static void myicq_packet_process(char *buf, int buflen, struct gaim_connection *gc)
{
	struct myicq_data *md = gc->proto_data;
	struct UDP_SRV_HDR header;
	int len;
	char *cursor;
	uint16 ackseq,seq; // Only for convenient access, header.ackseq is 16 bits,here will be 32 bits in fact.
	
	if (buflen < sizeof(struct UDP_SRV_HDR))
	{
		debug_printf("MyICQ: process: drop a short packet\n");
		return;
	}

	cursor = buf;
	myicq_read_packet_w(buf, &cursor, buflen, &header.ver);
	myicq_read_packet_dw(buf, &cursor, buflen, &header.reserved);
	myicq_read_packet_dw(buf, &cursor, buflen, &header.uin);
	myicq_read_packet_dw(buf, &cursor, buflen, &header.sid);
	myicq_read_packet_w(buf, &cursor, buflen, &header.cmd);
	myicq_read_packet_w(buf, &cursor, buflen, &header.seq);
	myicq_read_packet_w(buf, &cursor, buflen, &header.ackseq);
		
	debug_printf("MyICQ: receive %s\n",myicq_get_type_str(header.cmd));
	if (header.ver != MYICQ_UDP_VER)
	{
		debug_printf("MyICQ: header.ver not right\n");
		return;
	}
	
	// The session ID must match, otherwise, this is a cracking packet
	if (header.sid != md->sid)
	{
		debug_printf("MyICQ: sid not match\n");
		return;
	}
	ackseq = header.ackseq;
	seq = header.seq;
	if (ackseq)
	{
		myicq_process_onAck(ackseq, gc);
	}
	if (!seq)  //UDP_LOGIN 's ackseq can tell you that your login is received,but,it also tell you some other information.
		return; //is a pure ack packet,already processed.

	if (!myicq_check_packet_set_window(seq, gc)) {
		// This packet is a duplicated one that we have received already
		debug_printf("MyICQ: packet %u is duplicated\n", seq);
		return;
	}
	
	len = buflen - sizeof(struct UDP_SRV_HDR);
		
	switch (header.cmd) {
	case UDP_NEW_UIN:
		if (myicq_process_newNINReply(cursor, len , gc))			
			return;
		break;
	case UDP_GET_CONTACTLIST:
		myicq_process_contactListReply(cursor, len , gc);
		break;

	case UDP_GET_REMOTE_CONTACTLIST:
		myicq_process_remoteContactListReply(cursor, len , gc);
		break;

	case UDP_LOGIN:
		if (myicq_process_loginReply(cursor, len , gc)) //is login fail,then return soon,or run myicq_send_packet_ack() will make segment fault.
			return;
		break;

	case UDP_KEEPALIVE:
		myicq_process_keepAliveReply(cursor, len , gc);
		return;

	case UDP_SRV_USER_ONLINE:
		myicq_process_userOnline(cursor, len , gc);
		break;

	case UDP_SRV_USER_OFFLINE:
		myicq_process_userOffline(cursor, len , gc);
		break;

	case UDP_SRV_MULTI_ONLINE:
		myicq_process_multiOnline(cursor, len , gc);
		break;

	case UDP_SRV_STATUS_CHANGED:
		myicq_process_statusChanged(cursor, len , gc);
		break;

	case UDP_UPDATE_CONTACT:
		myicq_process_updateContactReply(0, cursor, len , gc);
		break;

	case UDP_UPDATE_USER:
		myicq_process_updateContactReply(1, cursor, len , gc);
		break;
	
	case UDP_SRV_MESSAGE:
		myicq_process_recvMessage(cursor, len , gc);
		break;

	case UDP_SRV_SEARCH:
		myicq_process_searchReply(cursor, len , gc);
		break;

	case UDP_ADD_FRIEND:
		myicq_process_addFriendReply(cursor, len , gc);
		break;
	
	case UDP_GET_SERVER_LIST:
		myicq_process_getServerList(cursor, len , gc);
		break;

	case UDP_SRV_GROUP_TYPES:
		myicq_process_srvGroupTypes(cursor, len , gc);
		break;
	case UDP_GET_GROUP_LIST:
		myicq_process_groupList(cursor, len , gc);
		break;
	case UDP_SEARCH_GROUP:
		myicq_process_searchGroup(cursor, len , gc);
		break;
	case UDP_CREATE_GROUP:
		myicq_process_createGroup(cursor, len , gc);
		break;
	case UDP_ENTER_GROUP:
		myicq_process_enterGroup(cursor, len , gc);
		break;
	case UDP_GROUP_START:
		myicq_process_groupStart(cursor, len , gc);
		break;
	case UDP_GROUP_MESSAGE:
		myicq_process_groupMessage(cursor, len , gc);
		break;
	case UDP_GROUP_CMD:
		myicq_process_groupCmd(cursor, len , gc);
		break;
	case UDP_SRV_ENTER_GROUP:
		myicq_process_srvEnterGroup(cursor, len , gc);
		break;
	case UDP_SRV_EXIT_GROUP:
		myicq_process_srvExitGroup(cursor, len , gc);
		break;

	default:
		debug_printf("MyICQ: UNKNOW udp packet!\n");
		break;
	}

	myicq_send_packet_ack(seq, gc);
}


static void myicq_pending(gpointer data, gint source, GaimInputCondition cond)
{
	struct gaim_connection *gc = data;
	struct myicq_data *md = gc->proto_data;
	struct gaim_proxy_info *gpi = gc->account->gpi;
	char buf[MAX_PACKET_SIZE];
	char *cursor = buf;
	int len;
	struct sockaddr_in addr;
	socklen_t addrlen = sizeof(addr);

	if(!gpi)
		gpi = &global_proxy_info;

	len = recvfrom(md->fd, buf, sizeof(buf), 0, (struct sockaddr *) &addr, &addrlen);

	if (len <= 0) {
		hide_login_progress(gc, _("Error reading from server"));
		signoff(gc);
		return;
	}

	if (gpi->proxytype == PROXY_SOCKS5) {
		if (buf[0] != 0 || buf[1] != 0 || buf[2] != 0 || buf[3] != 1)
		{
			hide_login_progress(gc, _("Error reading from server"));
			signoff(gc);
			return;
		}		
		cursor += 10;
		len -= 10;
	}

	myicq_packet_process(cursor, len, gc);
}

static void myicq_proxy_http_pending(gpointer data, gint source, GaimInputCondition cond)
{
	struct gaim_connection *gc = data;
	struct myicq_data *md = gc->proto_data;

	char buf[MAX_PACKET_SIZE];
	char *start, *end;
	char *queue;
	uint16 len;
	int readlen;

	readlen = recv(md->fd, buf, sizeof(buf),0);
	
	if (readlen <= 0) {
		hide_login_progress(gc, _("Error reading from server"));
		signoff(gc);
		return;
	}

	md->rxqueue = g_realloc(md->rxqueue, readlen + md->rxlen);
	memcpy(md->rxqueue + md->rxlen, buf, readlen);
	md->rxlen += readlen;

	start = md->rxqueue;
	end = start + md->rxlen;

	while (start + sizeof(len) < end)
	{
		len = ntohs(*(uint16 *) start);
		if (end - start - sizeof(len) < len)
		{
			// Not a complete packet
			break;
		}

		start += sizeof(len);
		if (len >= sizeof(struct TCP_HEADER))
		{
			myicq_packet_process(start, len, gc);
		}
		start += len;
	}

	queue=md->rxqueue;
	md->rxlen = end - start;
	if (md->rxlen > 0)
	{
		md->rxqueue = g_memdup(start, md->rxlen);
	}
	else
	{
		md->rxqueue=NULL;
	}
	g_free(queue);
}

static void myicq_proxy_socks5_pending(gpointer data, gint source, GaimInputCondition cond)
{
	struct gaim_connection *gc = data;
	struct myicq_data *md = gc->proto_data;
	char buf[MAX_PACKET_SIZE];

	int readlen;
debug_printf("MyICQ: myicq_proxy socks pending\n");	
	readlen = recv(md->fd, buf, sizeof(buf),0);

	if (readlen <= 0) {
		hide_login_progress(gc, _("Error reading from server")); //connection to socks5 proxy blocked.
		signoff(gc);
		return;
	}
}

static void myicq_load_face(struct gaim_connection *gc)
{
	FILE *file;
	char dir[256];
	struct myicq_data *md = gc->proto_data;
		
	sprintf(dir,"%s/myicq/%s.dat",gaim_user_dir(),gc->username);
	file = fopen (dir, "r");
	if (file!=NULL)
	{
		int faceindex=0;
		char nick[17],*a;
		fscanf(file,"%d",&faceindex);
		md->face = (uint8)faceindex;
		fgets(nick,17,file);
		a=strchr(nick,'');
		if (a)
			*a='\0';
		strcpy(gc->displayname,nick);
		fclose(file);
	}
	else
	{
		md->face = 0;
	}
}

static void myicq_got_connected(gpointer data, gint source, GaimInputCondition cond)
{
	struct gaim_connection *gc = data;
	struct myicq_data *md;
	struct gaim_proxy_info *gpi = gc->account->gpi;

	if (!g_slist_find(connections, gc)) {
		close(source);
		return;
	}


	if (source < 0) {
		hide_login_progress(gc, _("Unable to connect"));
		signoff(gc);
		return;
	}
	
	md = gc->proto_data;
	if(!gpi)
		gpi = &global_proxy_info;

	if (gpi->proxytype == PROXY_SOCKS5)
	{					
		md->fd = (int)cond; //when use_udp and connect to SOCK5,cond is the udpsock in fact.		
		md->socks5proxySock = source;
		md->socks5proxyInpa = gaim_input_add(md->socks5proxySock, GAIM_INPUT_READ, myicq_proxy_socks5_pending, gc);
	}
	else
	{
		md->fd = source;
	}
	if (md->loginmethod == -1) //reister new user.
	{
		myicq_send_packet_newUin(gc);
		set_login_progress(gc, 2,_("Registering new myicq user"));
	}
	else
	{
		myicq_load_face(gc);
		
		myicq_send_packet_login(gc);
		set_login_progress(gc, 2,_("Synching with server"));
	}
	
	md->online = TRUE;	
	md->sendqueue_timeout=gtk_timeout_add(5000, myicq_sendqueue_timeout_callback, gc);
	md->tcpmsgsendqueue_timeout=gtk_timeout_add(1000, myicq_tcpmsgsendqueue_timeout_callback, gc);

	if (gpi->proxytype == PROXY_HTTP)
	{
		gc->inpa = gaim_input_add(md->fd, GAIM_INPUT_READ, myicq_proxy_http_pending, gc);
	}
	else
	{
		gc->inpa = gaim_input_add(md->fd, GAIM_INPUT_READ, myicq_pending, gc);
	}
}

static void init_myicq_data(struct myicq_data *md)
{
	md->sid = (rand() & 0x7fffffff) + 1;
	md->sendSeq = (rand() & 0x3fff);
	md->fd = -1;
	md->filelistenSock = -1;
	md->msglistenSock = -1;
	md->socks5proxySock = -1;
}

static void myicq_do_connect(struct gaim_account *account, gboolean regNewUser)
{
	struct gaim_connection *gc = new_gaim_conn(account);
	struct myicq_data *md = gc->proto_data = g_new0(struct myicq_data, 1);
	struct gaim_proxy_info *gpi = account->gpi;
	char pass[8];
	char *aa;

	if(!gpi)
		gpi = &global_proxy_info;

	srand(time(NULL));
	init_myicq_data(md);

	desinit(0);	
	strncpy(pass, gc->password, sizeof(pass));
	des_setkey(md->subkey,pass); // set des's key	
	
	if (regNewUser) //register new user
		md->loginmethod=-1;
	else if (!strcmp(account->proto_opt[USEROPT_MYICQINVISLOGIN],"0"))
		md->loginmethod=0;
	else if (!strcmp(account->proto_opt[USEROPT_MYICQINVISLOGIN],"1"))
		md->loginmethod=1;
	else if (!strcmp(account->proto_opt[USEROPT_MYICQINVISLOGIN],"2"))
		md->loginmethod=2;
	else
		md->loginmethod=1;

	set_login_progress(gc, 1, _("Connecting"));
	
	//need by socks5 proxy.
	md->myicq_server_host = g_strdup(account->proto_opt[USEROPT_MYICQSERVER][0] ?account->proto_opt[USEROPT_MYICQSERVER] : MYICQ_SERVER);
	md->myicq_server_port = (account->proto_opt[USEROPT_MYICQPORT][0] ? atoi(account->proto_opt[USEROPT_MYICQPORT]) : MYICQ_PORT);
	aa = strchr(gc->username,'@');
	if (aa)
	{
		strcpy(md->domain,aa+1);
	}
	else
	{
		strcat(gc->username,"@");
		strcat(gc->username,md->myicq_server_host);
		strcpy(md->domain,md->myicq_server_host);
	}
	md->myuin = (uint32)atol(gc->username);
	
	if (gpi->proxytype == PROXY_HTTP)
	{
		md->fd = proxy_connect(account, md->myicq_server_host, 
			       MYICQ_HTTP_PORT,
			       myicq_got_connected, gc);
	}
	else if (gpi->proxytype == PROXY_SOCKS4)
	{
		hide_login_progress(gc, _("As SOCKS4 doesn't support UDP proxy,you can't use it to access Myicq server!"));
		signoff(gc);
		return;
	}
	else //PROXY_NONE or PROXY_SOCKS5
	{
		md->fd = proxy_connect_full(account, md->myicq_server_host, 
			       md->myicq_server_port,
			       myicq_got_connected, gc, TRUE);
	}

	if (md->fd < 0) {
		hide_login_progress(gc, _("Unable to connect"));
		signoff(gc);
		return;
	}	
}

static void myicq_login(struct gaim_account *account)
{
	myicq_do_connect(account, FALSE);
}

static void myicq_register_user(struct gaim_account *account)
{
	if (account->password[0])
		myicq_do_connect(account, TRUE);
}

static void myicq_close(struct gaim_connection *gc)
{
	struct myicq_data *md = gc->proto_data;
	struct myicq_buddy *buddy;
	struct serv_group_type *grouptype;

	if (md->fd>=0)
		myicq_send_packet_logout(gc);
		
	if (md->sendqueue_timeout)
		gtk_timeout_remove(md->sendqueue_timeout);
	myicq_sendqueue_free(md);
	if (md->tcpmsgsendqueue_timeout)
		gtk_timeout_remove(md->tcpmsgsendqueue_timeout);
	myicq_tcpmsgsendqueue_free(md);
	
	myicq_updatingContactInfo_list_free(md);
	if (md->searchDlg)
		gtk_widget_destroy(md->searchDlg->window); //this will auto g_free md->searchDlg.

	if (md->msglistenSock >= 0) //tcp msg listener
	{
		close(md->msglistenSock);
		md->msglistenSock = -1;
	}
	if (md->msglistenInpa)
	{
		gaim_input_remove(md->msglistenInpa);
		md->msglistenInpa = 0;
	}

	if (md->filelistenSock >= 0) //tcp file listener
	{
		close(md->filelistenSock);
		md->filelistenSock = -1;
	}
	if (md->filelistenInpa)
	{
		gaim_input_remove(md->filelistenInpa);
		md->filelistenInpa = 0;
	}

	myicq_tcpfileconnection_free(md);
	myicq_tcpmsgconnection_free(md);

	while (md->servgrouptype)
	{
		grouptype = (struct serv_group_type *)(md->servgrouptype->data);
		g_free(grouptype->name);
		g_free(grouptype->displayname);
		g_free(grouptype);
		md->servgrouptype=g_slist_remove(md->servgrouptype,grouptype);
	}
	while (md->onlinebuddy)
	{
		buddy= (struct myicq_buddy *)(md->onlinebuddy->data);
		g_free(buddy->domain);
		g_free(buddy);
		md->onlinebuddy=g_list_remove(md->onlinebuddy,buddy);
	}		

	
	if (md->fd >= 0)
		close(md->fd);
	if (gc->inpa)
		gaim_input_remove(gc->inpa);

	if (md->socks5proxySock >= 0) //socks5 proxy 's tcp connect sock
	{
		close(md->socks5proxySock);
		md->socks5proxySock = -1;
	}
	if (md->socks5proxyInpa)
	{
		gaim_input_remove(md->socks5proxyInpa);
		md->socks5proxyInpa = 0;
	}

	if (gc->away)
	{
		g_free(gc->away);
		gc->away = NULL;
	}

	if (md->myicq_server_host)
		g_free(md->myicq_server_host);
	if (md->rxqueue)
		g_free(md->rxqueue);
	g_free(md);
	
	if (prpl_accounts[PROTO_MYICQ]==1)
		desdone(); //when plug-in is load for two time,the first instant call this,but the second instance need it!
}

static int myicq_send_im(struct gaim_connection *gc, char *who, char *msg, int len, int flags)
{	
	struct myicq_data *md = gc->proto_data;
	
	if (strlen(msg)>MAX_MSG_LEN)
		return -E2BIG;	
	if (strcmp(who, gc->username)) {
		uint32 to_uin;
		gchar *to_uin_domain;
		GList *list;
		struct myicq_tcpmsgconnection *mtmc=NULL;
		gboolean senddirect=FALSE;
		uint8 type;
		gchar *message;
		
		if (flags & IM_FLAG_AWAY)
			type = MSG_AUTO_REPLY;
		else
			type = MSG_TEXT;
		to_uin = atol(who);
		to_uin_domain = strchr(who,'@');
		if (to_uin_domain)
			to_uin_domain++;
		else
			to_uin_domain = md->domain;
		message = g_locale_from_utf8(msg,-1,NULL,NULL,NULL);
		list = md->tcpmsgConnection;
		while (list)
		{
			mtmc = (struct myicq_tcpmsgconnection *)(list->data);
			if ((mtmc->uin==to_uin)&&(!strcasecmp(mtmc->domain,to_uin_domain))) //already have direct tcp connection.
			{
				senddirect = TRUE;
				break;
			}
			list=list->next;
		}
		if (senddirect)
		{
			myicq_send_tcp_msg_packet(type,message,mtmc);
			debug_printf("MyICQ: send_im direct\n");
		}
		else
		{
			if (myicq_send_tcp_msg_connect(type, to_uin, to_uin_domain, message,gc))
			{
				debug_printf("MyICQ: send_im,connected to user... \n");
			}
			else
			{
				debug_printf("MyICQ: send_im to server\n");
				myicq_send_packet_msg(type, to_uin, to_uin_domain, message,gc);
			}
		}
		g_free(message);
	}
	else
	{
		/* in myicq you can't send messages to yourself, so we'll fake like we received it ;) */
		serv_got_im(gc, who, msg, flags | IM_FLAG_GAIMUSER, time(NULL), -1);
	}
	return 1;
}

static GList *myicq_away_states(struct gaim_connection *gc)
{
	GList *m = NULL;

	m = g_list_append(m, _("Online"));
	m = g_list_append(m, _("Away"));
	m = g_list_append(m, _("Invisible"));
	m = g_list_append(m, GAIM_AWAY_CUSTOM);

	return m;
}

static char *myicq_get_away_text(int s)
{
	switch (s) {
		case STATUS_ONLINE :
			return _("OnLine");
		case STATUS_OFFLINE :
			return _("OffLine");
		case STATUS_AWAY :
			return _("Away");
		case STATUS_INVIS :
			return _("Invisible");
		default:
			return _("UnKnow");
	}
}

static char *myicq_status_text(struct buddy *b) {
	if (b->uc & UC_UNAVAILABLE)
		return g_strdup(myicq_get_away_text(b->uc >> 1));
	return NULL;
}

static char *myicq_tooltip_text(struct buddy *b) {
	if (b->present)
		return g_strdup_printf(_("<b>Status:</b> %s"), myicq_get_away_text(b->uc >> 1));

	return NULL;
}

static void myicq_set_away(struct gaim_connection *gc, char *state, char *msg)
{
	uint32 status;

	if (gc->away)
	{
		g_free(gc->away);
		gc->away = NULL;
	}
	if (!strcmp(state, _("Online"))) {
		status = STATUS_ONLINE;
	}
	else if (!strcmp(state, _("Away"))) {
		status = STATUS_AWAY;
	}
	else if (!strcmp(state, _("Invisible"))) {
		status = STATUS_INVIS;
		//gc->away = NULL; //not away,make gaim don't make it online when send message.
	}
	else if (!strcmp(state, GAIM_AWAY_CUSTOM))
	{
		if (msg)
		{
			status = STATUS_AWAY;
			gc->away = g_strndup(msg,MAX_MSG_LEN);
		}
		else
		{
			status = STATUS_ONLINE;
		}
	}
	else
	{
		status = STATUS_ONLINE;
	}

	myicq_send_packet_changeStatus(status, gc);	
}

static const char *myicq_list_icon(struct gaim_account *a, struct buddy *b)
{	
	if (!b)
	{
		return "myicq";
	}
	else
	{
		struct myicq_data *md = a->gc->proto_data;
		uint32 uin;
		gchar *domain;
		int faceindex;
		char dir[256];
		FILE *file;
		int uc = b->uc;
	
		uc >>= 1;
	
		uin = atol(b->name);
		domain = strchr(b->name,'@');
		if (domain)
			domain++;
		else
			domain= md->domain;
		sprintf(dir,"%s/myicq/%s/%lu.dat",gaim_user_dir(), domain, uin);
		file = fopen (dir, "r");
		if (file==NULL)
		{
			faceindex=0;
		}
		else
		{
			fscanf(file,"%d",&faceindex);
			fclose(file);
		}

		faceindex= faceindex*3+uc;
		if (faceindex<0 || faceindex> 84*3+2)
			return "myicq_face_1-1";
		return facefilebasename[faceindex];
	}
}

static void myicq_list_emblems(struct buddy *b, char **se, char **sw, char **nw, char **ne)
{
	if (b->present == 0)
		*se = "offline";
	else if (b->uc >> 1 == STATUS_ONLINE)
		*se = "online";
	else if (b->uc >> 1 == STATUS_AWAY)
		*se = "away";
	else
		*se = "unknow";
}

static void myicq_get_ip(struct gaim_connection *gc, char *who)
{
	struct myicq_data *md = gc->proto_data;
	GList *list;
	struct myicq_buddy *buddy;
	uint32 uin;
	gchar *domain;
	
	uin = atol(who);
	domain = strchr(who,'@');
	if (domain)
		domain++;
	else
		domain = md->domain;
	
	list= md->onlinebuddy;
	while (list)
	{
		buddy= (struct myicq_buddy*)(list->data);
		if ((buddy->uin==uin)&&(!strcasecmp(buddy->domain,domain)))
		{
			char text[256],ip[32],real_ip[32];
			struct in_addr in;
			in.s_addr = htonl(buddy->ip);
			sprintf(ip,"%s",inet_ntoa(in));
			in.s_addr = htonl(buddy->real_ip);
			sprintf(real_ip,"%s",inet_ntoa(in));
			sprintf(text,_("To %s:\nuser %s 's ip:%s port: %u real_ip: %s"),gc->username,who,ip,buddy->port,real_ip);
			//sprintf(text,"to %s:\nuser %s 's ip:%s port: %u real_ip: %s",gc->username,who,,buddy->port,inet_ntoa(htonl(buddy->real_ip))); //this will make real_ip and ip always be the same as inet_ntoa return a static buffer.
			do_error_dialog(_("IP info"),text,GAIM_INFO);
			break;
		}
		list=list->next;
	}
}

static void myicq_sendfile_request_ok(gpointer data, char *entry)
{
	struct _gc_and_qid *gq = (struct _gc_and_qid *)data;
	struct myicq_data *md = gq->gc->proto_data;
	GList *list;
	struct myicq_tcpmsgconnection *mtmc=NULL;
	gboolean senddirect=FALSE;
	char text[256];
	gchar *reason;
	struct myicq_buddy *buddy=NULL;
	gboolean find= FALSE;
	int port = 0;
	

	list = md->onlinebuddy;
	while (list)
	{
		buddy= (struct myicq_buddy *)(list->data);
		if ((buddy->uin==gq->uin)&&(!strcasecmp(buddy->domain,gq->domain)))
		{
			find = TRUE;
			break;
		}
		list=list->next;
	}
	if (!find) // this should never happen.
	{
	}
	else
	{
		if (buddy->real_ip != buddy->ip) //when remote is behind a firewall,i should create a listen port and tell the port to him.
		{			
			port = myicq_create_tcp_filelisten_sock(gq->gc);
			if (port<0)
				port = 0;
		}
	}

	
	reason = g_locale_from_utf8(entry,-1,NULL,NULL,NULL);
	snprintf(text,sizeof(text),"sendfile\xFF%s\xFF%d",reason, port);
	g_free(reason);
	
	list = md->tcpmsgConnection;
	while (list)
	{
		mtmc = (struct myicq_tcpmsgconnection *)(list->data);
		if ((mtmc->uin==gq->uin)&&(!strcasecmp(mtmc->domain,gq->domain))) //already have direct tcp connection.
		{
			senddirect = TRUE;
			break;
		}
		list=list->next;
	}
	if (senddirect)
	{
		myicq_send_tcp_msg_packet(MSG_TCP_REQUEST,text,mtmc);
		debug_printf("MyICQ: send send_file_request direct\n");
	}
	else
	{
		if (myicq_send_tcp_msg_connect(MSG_TCP_REQUEST, gq->uin, gq->domain, text,gq->gc))
		{
			debug_printf("MyICQ: send send_file_request,connected to user... \n");
		}
		else
		{
			debug_printf("MyICQ: send send_file_request to server\n");
			myicq_send_packet_msg(MSG_TCP_REQUEST, gq->uin, gq->domain, text,gq->gc);
		}
	}	

	//g_free(data); //this line is needn't,as when user click "Accept",gaim will call this,then call "cancel" function too.
}

static void myicq_sendfile_request_cancel(struct _gc_and_qid *gq)
{
	g_free(gq->domain);
	g_free(gq);
}

static void myicq_send_file(struct gaim_connection *gc, char *who)
{
	struct myicq_data *md = gc->proto_data;
	char text[256];
	struct _gc_and_qid *gq;
	uint32 to_uin;
	gchar *domain;
	
	to_uin = atol(who);
	domain = strchr(who,'@');
	if (domain)
		domain++;
	else
		domain = md->domain;
	
	sprintf(text,_("Hi,i am %s (%s),i want to send a file to you!"),gc->username,gc->displayname);
	gq= g_new(struct _gc_and_qid,1);
	gq->uin=to_uin;
	gq->domain = g_strdup(domain);
	gq->gc=gc;
	do_prompt_dialog(_("Type in your reason first:"),text, gq, myicq_sendfile_request_ok, myicq_sendfile_request_cancel);
}

static GList *myicq_buddy_menu(struct gaim_connection *gc, char *who)
{
	GList *m = NULL;
	struct proto_buddy_menu *pbm;

	pbm = g_new0(struct proto_buddy_menu, 1);
	pbm->label = _("Get contact's ip");
	pbm->callback = myicq_get_ip;
	pbm->gc = gc;
	m = g_list_append(m, pbm);

	pbm = g_new0(struct proto_buddy_menu, 1);
	pbm->label = _("Send file");
	pbm->callback = myicq_send_file;
	pbm->gc = gc;
	m = g_list_append(m, pbm);

	return m;
}

static void myicq_show_my_information(struct gaim_connection *gc)
{
	myicq_get_info(gc, gc->username);
}

static GList *myicq_actions(struct gaim_connection *gc)
{
	GList *m = NULL;
	struct proto_actions_menu *pam;

	pam = g_new0(struct proto_actions_menu, 1);
	pam->label = _("My information");
	pam->callback = myicq_show_my_information;
	pam->gc = gc;
	m = g_list_append(m, pam);

	pam = g_new0(struct proto_actions_menu, 1);
	pam->label = _("Search");
	pam->callback = myicq_show_search_dialog;
	pam->gc = gc;
	m = g_list_append(m, pam);

	return m;
}

static void myicq_add_buddy(struct gaim_connection *gc, const char *name)
{
	struct myicq_data *md = gc->proto_data;
	if (!md->logged_in)
		return;
	myicq_send_packet_addfriend(gc,name);
}

static void myicq_rem_buddy(struct gaim_connection *gc, char *who, char *group)
{
	myicq_send_packet_delfriend(gc,who);
}

static void myicq_group_buddy(struct gaim_connection *gc, const char *who, const char *old_group, const char *new_group)
{
	char stranger_group[256];
	sprintf(stranger_group,_("%s misc"),gc->username);
	if (!strcmp(old_group,stranger_group)) // the buddy in "%s misc" is stranger.
	{
		myicq_add_buddy(gc,who);
	}
}

static void myicq_keepalive(struct gaim_connection *gc)
{
	myicq_send_packet_keepalive(gc);
}
	
static void myicq_buddy_free(struct buddy *b)
{
	if (b->proto_data)
		g_free(b->proto_data);
}

void myicq_get_info(struct gaim_connection *gc, char *who)
{
	struct myicq_data *md = gc->proto_data;
	char dir[256];
	uint tmp_int;
	struct stat st;
	uint32 uin;
	GList *list;
	struct _updatingContactInfo *updateinfo;
	gchar *domain;

	int is_myself = (!strcmp(who,gc->username));
	
	domain = strchr(who,'@');
	if (domain && (domain[1]))
		domain++;
	else
		domain= md->domain;
	uin = atol(who);
	list= md->updatingContactInfo;
	while (list)
	{
		updateinfo = (struct _updatingContactInfo *)(list->data);
		if ((updateinfo->uin == uin)&&(!strcasecmp(updateinfo->domain,domain)))
		{
			if (updateinfo->window)
			{
				gtk_window_present(GTK_WINDOW(updateinfo->window));
			}
			return;
		}
		else
		{
			list = list->next;
		}
	}
	
	updateinfo=g_new0(struct _updatingContactInfo, 1);
	updateinfo->uin=uin;
	updateinfo->domain= g_strdup(domain);
	md->updatingContactInfo = g_list_append (md->updatingContactInfo, updateinfo);
	
	if (is_myself)
		sprintf(dir,"%s/myicq/%s.dat",gaim_user_dir(),who);
	else
		sprintf(dir,"%s/myicq/%s/%lu.dat",gaim_user_dir(),domain,uin);
	if (stat (dir, &st))
	{			
		if (is_myself)
			myicq_send_packet_updateUser(gc);
		else
			myicq_send_packet_updateContact(uin, domain, gc);
	}
	else
	{	
		FILE *file;	
		struct ContactInfo info;
		char *a;
		char buf[MAX_PACKET_SIZE];
		if (st.st_size >MAX_PACKET_SIZE)
			return;
		file = fopen (dir, "r");
		if (file==NULL)
			return;
		fread (buf, 1, st.st_size, file);
		fclose (file);
		buf[st.st_size] = '\0';
		info.uin = uin;
		info.domain = domain;
		sscanf(buf,"%u",&tmp_int);
		info.face = tmp_int;
		a=strchr(buf,'')+1;
		info.nick=a;
		a=strchr(a,'');*a='\0';a++;
		sscanf(a,"%u",&tmp_int);
		info.age = tmp_int;
		a=strchr(a,'')+1;
		sscanf(a,"%u",&tmp_int);
		info.gender = tmp_int;
		a=strchr(a,'')+1;
		info.country=a;
		a=strchr(a,'');*a='\0';a++;
		info.province=a;
		a=strchr(a,'');*a='\0';a++;
		info.city=a;
		a=strchr(a,'');*a='\0';a++;
		info.email=a;
		a=strchr(a,'');*a='\0';a++;
		info.address=a;
		a=strchr(a,'');*a='\0';a++;
		info.zipcode=a;
		a=strchr(a,'');*a='\0';a++;
		info.tel=a;
		a=strchr(a,'');*a='\0';a++;
		info.name=a;
		a=strchr(a,'');*a='\0';a++;
		sscanf(a,"%u",&tmp_int);
		info.blood = tmp_int;
		a=strchr(a,'')+1;
		info.college=a;
		a=strchr(a,'');*a='\0';a++;
		info.occupation=a;
		a=strchr(a,'');*a='\0';a++;
		info.homepage=a;
		a=strchr(a,'');*a='\0';a++;
		info.intro=a;
		if (is_myself)
		{
			a=strchr(a,'');*a='\0';a++;
			sscanf(a,"%u",&tmp_int);
			info.auth = tmp_int;
		}
		myicq_show_contact_info_dialog(&info,gc,updateinfo);
	}
}

static GList *
myicq_chat_info(struct gaim_connection *gc)
{
	GList *m = NULL;
	struct proto_chat_entry *pce;

	pce = g_new0(struct proto_chat_entry, 1);
	pce->label = _("Group id:");
	m = g_list_append(m, pce);

	pce = g_new0(struct proto_chat_entry, 1);
	pce->label = _("Password:");
	m = g_list_append(m, pce);

	return m;
}

static void 
myicq_join_chat(struct gaim_connection *gc, GList *data)
{
	uint32 id;

	if (!data)
		return;
	id = atol(data->data);
	if (id<=0)
		id = 10001; //myicq's first group id.
	if (data->next)
		myicq_send_packet_enterGroup(id,(char *)(data->next->data),gc);
	else
		myicq_send_packet_enterGroup(id,"",gc);
}

static void 
myicq_chat_leave(struct gaim_connection *gc, int id)
{
	myicq_send_packet_exitGroup(id,gc);
	serv_got_chat_left(gc, id);
}

static int 
myicq_chat_send(struct gaim_connection *gc, int id, char *what)
{
	gchar *text;
	struct gaim_conversation *c = gaim_find_chat(gc, id);
	if (!c)
		return -EINVAL;
	if (strlen(what)>MAX_MSG_LEN)
		return -E2BIG;	
	text = g_locale_from_utf8(what,-1,NULL,NULL,NULL);
	myicq_send_packet_groupMessage(id,text,gc);
	g_free(text);
	serv_got_chat_in(gc, gaim_chat_get_id(GAIM_CHAT(c)),
						 gc->displayname, 0, what, time(NULL));	
	return 0;
}

static void 
myicq_chat_invite(struct gaim_connection *gc, int idn, const char *message, const char *name)
{
	gchar *msg;
	gchar *who;
	struct gaim_conversation *c = gaim_find_chat(gc, idn);
	msg = g_strdup_printf(_("%s(%s) invite you to join %s:\n%s"),gc->username,gc->displayname,c->name,message);
	who = g_strdup(name);
	myicq_send_im(gc, who, msg, strlen(msg), 0);
	g_free(who);
	g_free(msg);
}

static void myicq_chat_whisper(struct gaim_connection *gc, int id, char *who, char *message)
{
	debug_printf("MYICQ: whisper_chat\n");
}


/*
GSList *myicq_smiley_list() 
{ 
	GSList *smilies = NULL;
	gchar* myicq_emotions[] = {
		"/:O", "/:-/", "/:*", "/>:", "/8-)", "/:(", "/:$", "/:-X", "/:-Z", "/:'(",
		"/:-|", "/:@", "/:P", "/:D", "/:)", "/<D>", "/<J>", "/<H>", "/<M>", "/<QQ>",
		"/<MM>", "/<L>", "/<S>", "/<K>", "/<T>", "/<$>", "/<O>", "/<&>", "/<B>", "/<F>",
		"/<U>", "/<V>", "/<W>", "/<Y1>", "/<Y2>", "/<%>", "/<@@>", "/<X>", "/<I>", "/<G>",
		"/<!!>", "/<~>", "/<C>", "/<Z>", "/<*>", "/<)>", "/<OK>", "/<NO>", "/<00>", "/<11>",
	};

	smilies = add_smiley(smilies, myicq_emotions[0], myicq_emotion_1_xpm, 1);
	smilies = add_smiley(smilies, myicq_emotions[1], myicq_emotion_2_xpm, 1);
	smilies = add_smiley(smilies, myicq_emotions[2], myicq_emotion_3_xpm, 1);
	smilies = add_smiley(smilies, myicq_emotions[3], myicq_emotion_4_xpm, 1);
	smilies = add_smiley(smilies, myicq_emotions[4], myicq_emotion_5_xpm, 1);
	smilies = add_smiley(smilies, myicq_emotions[5], myicq_emotion_6_xpm, 1);
	smilies = add_smiley(smilies, myicq_emotions[6], myicq_emotion_7_xpm, 1);
	smilies = add_smiley(smilies, myicq_emotions[7], myicq_emotion_8_xpm, 1);
	smilies = add_smiley(smilies, myicq_emotions[8], myicq_emotion_9_xpm, 1);
	smilies = add_smiley(smilies, myicq_emotions[9], myicq_emotion_10_xpm, 1);
	smilies = add_smiley(smilies, myicq_emotions[10], myicq_emotion_11_xpm, 1);
	smilies = add_smiley(smilies, myicq_emotions[11], myicq_emotion_12_xpm, 1);
	smilies = add_smiley(smilies, myicq_emotions[12], myicq_emotion_13_xpm, 1);
	smilies = add_smiley(smilies, myicq_emotions[13], myicq_emotion_14_xpm, 1);
	smilies = add_smiley(smilies, myicq_emotions[14], myicq_emotion_15_xpm, 1);
	smilies = add_smiley(smilies, myicq_emotions[15], myicq_emotion_16_xpm, 1);
	smilies = add_smiley(smilies, myicq_emotions[16], myicq_emotion_17_xpm, 1);
	smilies = add_smiley(smilies, myicq_emotions[17], myicq_emotion_18_xpm, 1);
	smilies = add_smiley(smilies, myicq_emotions[18], myicq_emotion_19_xpm, 1);
	smilies = add_smiley(smilies, myicq_emotions[19], myicq_emotion_20_xpm, 1);
	smilies = add_smiley(smilies, myicq_emotions[20], myicq_emotion_21_xpm, 1);
	smilies = add_smiley(smilies, myicq_emotions[21], myicq_emotion_22_xpm, 1);
	smilies = add_smiley(smilies, myicq_emotions[22], myicq_emotion_23_xpm, 1);
	smilies = add_smiley(smilies, myicq_emotions[23], myicq_emotion_24_xpm, 1);
	smilies = add_smiley(smilies, myicq_emotions[24], myicq_emotion_25_xpm, 1);
	smilies = add_smiley(smilies, myicq_emotions[25], myicq_emotion_26_xpm, 1);
	smilies = add_smiley(smilies, myicq_emotions[26], myicq_emotion_27_xpm, 1);
	smilies = add_smiley(smilies, myicq_emotions[27], myicq_emotion_28_xpm, 1);
	smilies = add_smiley(smilies, myicq_emotions[28], myicq_emotion_29_xpm, 1);
	smilies = add_smiley(smilies, myicq_emotions[29], myicq_emotion_30_xpm, 1);
	smilies = add_smiley(smilies, myicq_emotions[30], myicq_emotion_31_xpm, 1);
	smilies = add_smiley(smilies, myicq_emotions[31], myicq_emotion_32_xpm, 1);
	smilies = add_smiley(smilies, myicq_emotions[32], myicq_emotion_33_xpm, 1);
	smilies = add_smiley(smilies, myicq_emotions[33], myicq_emotion_34_xpm, 1);
	smilies = add_smiley(smilies, myicq_emotions[34], myicq_emotion_35_xpm, 1);
	smilies = add_smiley(smilies, myicq_emotions[35], myicq_emotion_36_xpm, 1);
	smilies = add_smiley(smilies, myicq_emotions[36], myicq_emotion_37_xpm, 1);
	smilies = add_smiley(smilies, myicq_emotions[37], myicq_emotion_38_xpm, 1);
	smilies = add_smiley(smilies, myicq_emotions[38], myicq_emotion_39_xpm, 1);
	smilies = add_smiley(smilies, myicq_emotions[39], myicq_emotion_40_xpm, 1);
	smilies = add_smiley(smilies, myicq_emotions[40], myicq_emotion_41_xpm, 1);
	smilies = add_smiley(smilies, myicq_emotions[41], myicq_emotion_42_xpm, 1);
	smilies = add_smiley(smilies, myicq_emotions[42], myicq_emotion_43_xpm, 1);
	smilies = add_smiley(smilies, myicq_emotions[43], myicq_emotion_44_xpm, 1);
	smilies = add_smiley(smilies, myicq_emotions[44], myicq_emotion_45_xpm, 1);
	smilies = add_smiley(smilies, myicq_emotions[45], myicq_emotion_46_xpm, 1);
	smilies = add_smiley(smilies, myicq_emotions[46], myicq_emotion_47_xpm, 1);
	smilies = add_smiley(smilies, myicq_emotions[47], myicq_emotion_48_xpm, 1);
	smilies = add_smiley(smilies, myicq_emotions[48], myicq_emotion_49_xpm, 1);
	smilies = add_smiley(smilies, myicq_emotions[49], myicq_emotion_50_xpm, 1);
	
	return smilies;
}
*/

G_MODULE_EXPORT void myicq_init(struct prpl *ret)
{
	struct proto_user_opt *puo;
	ret->protocol = PROTO_MYICQ;
	ret->options = OPT_PROTO_CHAT_TOPIC;
	ret->name = g_strdup("MyICQ");
	ret->list_icon = myicq_list_icon;
	ret->list_emblems = myicq_list_emblems;
	ret->away_states = myicq_away_states;
	ret->status_text = myicq_status_text;
	ret->tooltip_text = myicq_tooltip_text;
	ret->actions = myicq_actions;
	ret->buddy_menu = myicq_buddy_menu;
	//ret->edit_buddy_menu = myicq_edit_buddy_menu;
	ret->chat_info = myicq_chat_info;
/*	ret->smiley_list = myicq_smiley_list;*/
	
	ret->login = myicq_login;
	ret->close = myicq_close;
	ret->send_im = myicq_send_im;
//	ret->set_info = myicq_set_info;
	/*ret->send_typing = myicq_send_typing;*/
	ret->get_info = myicq_get_info;
	ret->set_away = myicq_set_away;
//	ret->get_away = myicq_get_away;
//	ret->set_dir = myicq_set_dir;
//	ret->get_dir = myicq_get_dir;
//	ret->dir_search = myicq_dir_search;
	/*ret->set_idle = myicq_set_idle;*/
//	ret->change_passwd = myicq_change_passwd;
	ret->add_buddy = myicq_add_buddy;
//	ret->add_buddies = myicq_add_buddies;
	ret->remove_buddy = myicq_rem_buddy;
//	ret->remove_buddies = myicq_rem_buddies;
/*	ret->add_permit = myicq_add_permit;*/
/*	ret->add_deny = myicq_add_deny;*/
/*	ret->rem_permit = myicq_rem_permit;*/
/*	ret->rem_deny = myicq_rem_deny;*/
/*	ret->set_permit_deny = myicq_set_permit_deny;*/
//	ret->warn = myicq_warn;
	ret->join_chat = myicq_join_chat;
	ret->chat_invite = myicq_chat_invite;
	ret->chat_leave = myicq_chat_leave;
	ret->chat_whisper = myicq_chat_whisper;
	ret->chat_send = myicq_chat_send;
	ret->keepalive = myicq_keepalive;

	ret->register_user = myicq_register_user;
//	ret->get_cb_info = myicq_get_cb_info;
//	ret->get_cb_away = myicq_get_cb_away;
//	ret->alias_buddy = myicq_alias_buddy;
	ret->group_buddy = myicq_group_buddy;
	ret->buddy_free = myicq_buddy_free;
	//ret->convo_closed = myicq_convo_closed;
	//ret->normalize = myicq_normalize;

	puo = g_new0(struct proto_user_opt, 1);
	puo->label = g_strdup(_("MyICQ Server:"));
	puo->def = g_strdup(MYICQ_SERVER);
	puo->pos = USEROPT_MYICQSERVER;
	ret->user_opts = g_list_append(ret->user_opts, puo);

	puo = g_new0(struct proto_user_opt, 1);
	puo->label = g_strdup(_("Port:"));
	puo->def = g_strdup("8000");
	puo->pos = USEROPT_MYICQPORT;
	ret->user_opts = g_list_append(ret->user_opts, puo);

	puo = g_new0(struct proto_user_opt, 1);
	puo->label = g_strdup(_("Login Method(0=Invisible,1=Normal,2=Away):"));
	puo->def = g_strdup("1");
	puo->pos = USEROPT_MYICQINVISLOGIN;
	ret->user_opts = g_list_append(ret->user_opts, puo);

	my_protocol = ret;
}

#ifndef STATIC

G_MODULE_EXPORT void gaim_prpl_init(struct prpl *prpl)
{
	myicq_init(prpl);
	prpl->plug->desc.api_version = PLUGIN_API_VERSION;
}

G_MODULE_EXPORT void gaim_plugin_remove()
{
	struct prpl *p = find_prpl(PROTO_MYICQ);
	if (p == my_protocol)
		unload_protocol(p);
}

G_MODULE_EXPORT char *name()
{
	return "MyICQ";
}

G_MODULE_EXPORT char *description()
{
	return _("MyICQ Protocol V0.6.0 2003.4.10\n"
			"MyICQ is maintaind by ZhangYong <z-yong163@163.com>\nhttp://myicq.cosoft.org.cn\n\n"
			"gaim's myicq plug-in is maintaind by HuZheng <huzheng_001@163.com>\nhttp://forlinux.yeah.net\n\n"
			"Released under the GNU Public License");
}

#endif
