# -*- coding: utf-8 -*-

import os
import ConfigParser

class ConfigFile:
	def __init__(self):
		self.config = ConfigParser.SafeConfigParser()
		self.config.read([os.path.expanduser('~/.stroke-editor.cfg')])
		self.modified = False

	def set(self, section, option, value):
		self.modified = True
		if self.config.has_section(section) == False:
			self.config.add_section(section)
		self.config.set(section, option, value)

	def get(self, section, option, default = None):
		try:
			value = self.config.get(section, option)
		except:
			value = default
		return value

	def save(self):
		if self.modified:
			self.config.write(file(os.path.expanduser('~/.stroke-editor.cfg'), 'w'))
