/*
    Pirate Bulletin Board System
    Copyright (C) 1990, Edward Luke, lush@Athena.EE.MsState.EDU
    Eagles Bulletin Board System
    Copyright (C) 1992, Raymond Rocker, rocker@rock.b11.ingr.com
                        Guy Vega, gtvega@seabass.st.usm.edu
                        Dominic Tynes, dbtynes@seabass.st.usm.edu
    Firebird Bulletin Board System
    Copyright (C) 1996, Hsien-Tsung Chang, Smallpig.bbs@bbs.cs.ccu.edu.tw
                        Peng Piaw Foong, ppfoong@csie.ncu.edu.tw

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
*/
/*
$Id: xyz.c,v 1.1.1.1 2000/08/25 14:20:33 deardragon Exp $
*/

#define EXTERN
#include "bbs.h"

#ifdef ALLOWGAME
#include "money.h"
#endif

int     use_define = 0;
int child_pid=0;
extern int iscolor;
extern int enabledbchar;

#ifdef ALLOWSWITCHCODE
extern int switch_code();
extern int convcode;
#endif

#ifdef TIMECOUNTER
extern struct MCACHE *tstrshm;
#endif

char datestring[30];

extern struct BCACHE *brdshm;
#define TH_LOW	10
#define TH_HIGH	15

int modify_user_mode(int mode)
{
	uinfo.mode = mode;
	update_ulist(&uinfo, utmpent);
	return 0;
}

int showperminfo(int pbits, int i)
{
	char    buf[STRLEN];
	sprintf(buf, "%c. %-30s %2s", 'A' + i, (use_define) ? user_definestr[i] : permstrings[i],
		((pbits >> i) & 1 ? "" : ""));
	move(i + 6 - ((i > 15) ? 16 : 0), 0 + ((i > 15) ? 40 : 0));
	prints(buf);
	refresh();
	return YEA;
}

unsigned int
setperms(pbits, prompt, numbers, showfunc)
unsigned int pbits;
char   *prompt;
int     numbers;
int     (*showfunc) ();
{
	int     lastperm = numbers - 1;
	int     i, done = NA;
	char    choice[3], buf[80];
	move(4, 0);
	prints("밴ҪĴ趨%s Enter .\n", prompt);
	move(6, 0);
	clrtobot();
	for (i = 0; i <= lastperm; i++) {
		(*showfunc) (pbits, i, NA);
	}
	while (!done) {
		sprintf(buf, "ѡ(ENTER %s): ", ((strcmp(prompt, "Ȩ") != 0)) ? "" : "0 ͣȨ");
		getdata(t_lines - 1, 0, buf, choice, 2, DOECHO, YEA);
		*choice = toupper(*choice);
		if (*choice == '0')
			return (0);
		else if (*choice == '\n' || *choice == '\0')
			done = YEA;
		else if (*choice < 'A' || *choice > 'A' + lastperm)
			bell();
		else {
			i = *choice - 'A';
			pbits ^= (1 << i);
			if ((*showfunc) (pbits, i, YEA) == NA) {
				pbits ^= (1 << i);
			}
		}
	}
	return (pbits);
}

int
x_userdefine()
{
	int     id;
	unsigned int newlevel;
	modify_user_mode(USERDEF);
	if (!(id = getuser(currentuser.userid))) {
		move(3, 0);
		prints("ʹ ID...");
		clrtoeol();
		pressreturn();
		clear();
		return 0;
	}
	move(1, 0);
	clrtobot();
	move(2, 0);
	use_define = 1;
	newlevel = setperms(lookupuser.userdefine, "", NUMDEFINES, showperminfo);
	move(2, 0);
	if (newlevel == lookupuser.userdefine)
		prints("û޸...\n");
	else {
#ifdef ALLOWSWITCHCODE
        	if ((!convcode&&!(newlevel&DEF_USEGB))
            		||(convcode&&(newlevel&DEF_USEGB)))
               		switch_code();
#endif
		lookupuser.userdefine = newlevel;
		currentuser.userdefine = newlevel;
		substitute_record(PASSFILE, &lookupuser, sizeof(struct userec), id);
		uinfo.pager |= FRIEND_PAGER;
		if (!(uinfo.pager & ALL_PAGER)) {
			if (!DEFINE(DEF_FRIENDCALL))
				uinfo.pager &= ~FRIEND_PAGER;
		}
		uinfo.pager &= ~ALLMSG_PAGER;
		uinfo.pager &= ~FRIENDMSG_PAGER;
        	if (DEFINE(DEF_DELDBLCHAR))
            		enabledbchar=1;
        	else
            		enabledbchar=0;
		uinfo.from[22] = DEFINE(DEF_NOTHIDEIP)?'S':'H';
		if (DEFINE(DEF_FRIENDMSG)) {
			uinfo.pager |= FRIENDMSG_PAGER;
		}
		if (DEFINE(DEF_ALLMSG)) {
			uinfo.pager |= ALLMSG_PAGER;
			uinfo.pager |= FRIENDMSG_PAGER;
		}
		update_utmp();
		prints("µĲ趨...\n\n");
	}
	iscolor = (DEFINE(DEF_COLOR)) ? 1 : 0;
	pressreturn();
	clear();
	use_define = 0;
	return 0;
}

int
x_cloak()
{
	modify_user_mode(GMENU);
	report("toggle cloak");
	uinfo.invisible = (uinfo.invisible) ? NA : YEA;
	update_utmp();
	if (!uinfo.in_chat) {
		move(1, 0);
		clrtoeol();
		prints(" (cloak) Ѿ%s!",
			(uinfo.invisible) ? "" : "ֹͣ");
		pressreturn();
	}
	return 0;
}

void
x_edits()
{
	int     aborted;
	char    ans[7], buf[STRLEN];
	int     ch, num, confirm;
	extern int WishNum;
	static char *e_file[] =
	{"plans", "signatures", "notes", "logout", "GoodWish",
	 ".blockmail","autoreply",    
	 NULL};
	static char *explain_file[] =
	{"˵", "ǩ", "Լı¼", "վĻ","ײϢ", 
	 "ͣվʼ","Զ",
	 NULL};
	modify_user_mode(GMENU);
	clear();
	move(1, 0);
	prints("޸˵\n\n");
	for (num = 0; e_file[num] != NULL && explain_file[num] != NULL; num++) {
		prints("[[1;32m%d[m] %s\n", num + 1, explain_file[num]);
	}
	prints("[[1;32m%d[m] \n", num + 1);

	getdata(num + 5, 0, "Ҫһ˵: ", ans, 2, DOECHO, YEA);
	if (ans[0] - '0' <= 0 || ans[0] - '0' > num || ans[0] == '\n' || ans[0] == '\0')
		return;

	ch = ans[0] - '0' - 1;
	if(ch!=5)setuserfile(genbuf, e_file[ch]);
	else setmfile(genbuf,currentuser.userid,e_file[5]);
	move(3, 0);
	clrtobot();
	sprintf(buf, "(E)༭ (D)ɾ %s? [E]: ", explain_file[ch]);
	getdata(3, 0, buf, ans, 2, DOECHO, YEA);
	if (ans[0] == 'D' || ans[0] == 'd') {
		confirm = askyn("ȷҪɾ", NA, NA);
		if (confirm != 1) {
			move(5, 0);
			prints("ȡɾж\n");
			pressreturn();
			clear();
			return;
		}
		unlink(genbuf);
		move(5, 0);
		prints("%s ɾ\n", explain_file[ch]);
		sprintf(buf, "delete %s", explain_file[ch]);
		report(buf);
		pressreturn();
		if(ch == 4) WishNum = 9999;
		clear();
		return;
	}
	modify_user_mode(EDITUFILE);
	aborted = vedit(genbuf, NA, YEA);
	clear();
	if (!aborted) {
		prints("%s ¹\n", explain_file[ch]);
		sprintf(buf, "edit %s", explain_file[ch]);
		if (!strcmp(e_file[ch], "signatures")) {
			set_numofsig();
			prints("ϵͳ趨Լǩ...");
		}
		report(buf);
	} else
		prints("%s ȡ޸\n", explain_file[ch]);
	pressreturn();
	if(ch == 4) WishNum = 9999;
}

int gettheuserid(int x,char *title, int *id)
{
        move(x, 0);
        usercomplete( title , genbuf);
        if (*genbuf == '\0') {
                clear();
                return 0;
        }
        if (!(*id = getuser(genbuf))) {
                move(x + 3, 0);
                prints("ʹߴ");
                clrtoeol();
                pressreturn();
                clear();
                return 0;
        }
        return 1;
}

int gettheboardname(x,title,pos,fh,bname )
int     x, *pos;
struct boardheader * fh;
char    *bname, *title;
{
	extern int cmpbnames(); 
        move( x, 0);
	make_blist();
        namecomplete(title, bname);
        if (*bname == '\0') {
                return 0;
        }
        *pos = search_record(BOARDS, fh, sizeof(struct boardheader), cmpbnames,
bname);
        if (!(*pos)) {
                move(x + 3, 0);
                prints("ȷ");
                pressreturn();
                clear();
                return 0;
        }
        return 1;
}

void x_lockscreen()
{
   char    buf[PASSLEN + 1] ;
   #ifndef TIMECOUNTER
   time_t  now; 
   #endif
   
   modify_user_mode(LOCKSCREEN);
   move(9, 0);
   clrtobot();
   update_endline();
   buf[0] = '\0';
   #ifndef TIMECOUNTER
   now = time(0);
   getdatestring(now,NA);
   #else
   getnowdatestring();
   #endif
   move(9, 0);
   prints("[1;37m");
   prints("\n       _       _____   ___     _   _   ___     ___       __");
   prints("\n      ( )     (  _  ) (  _`\\  ( ) ( ) (  _`\\  (  _`\\    |  |");
   prints("\n      | |     | ( ) | | ( (_) | |/'/' | (_(_) | | ) |   |  |");
   prints("\n      | |  _  | | | | | |  _  | , <   |  _)_  | | | )   |  |");
   prints("\n      | |_( ) | (_) | | (_( ) | |\\`\\  | (_( ) | |_) |   |==|");
   prints("\n      (____/' (_____) (____/' (_) (_) (____/' (____/'   |__|\n");

   prints("\n[1;36mөĻ[33m %s[36m ʱ[32m %-12s [36mʱס...[m", datestring, currentuser.userid);
   while (*buf == '\0' || !checkpasswd(currentuser.passwd, buf)) {
      move(18, 0);
      clrtobot();
      update_endline();
      getdata(19, 0, "Խ: ", buf, PASSLEN, NOECHO, YEA);
   }
}

heavyload()
{
#ifndef BBSD
	double  cpu_load[3];
	get_load(cpu_load);
	if (cpu_load[0] > 15)
		return 1;
	else
		return 0;
#else
 #ifdef chkload
	register int load;
	register time_t uptime;
	
	if ( time(0) > uptime ) {
		load = chkload(load ? TH_LOW : TH_HIGH );
		uptime = time(0) + load + 45;
	}
	return load;
 #else
 	return 0;
 #endif
#endif		
}

//#define MY_DEBUG

void exec_cmd(int umode, int pager, char *cmdfile, char *param1)
{
   char    buf[160];
   char    *my_argv[18], *ptr;
   int     save_pager, i;
   
   signal(SIGALRM, SIG_IGN);
   modify_user_mode(umode);
   clear();
   move(2, 0);
   if (num_useshell() > MAX_USESHELL) {
      prints("̫ʹⲿʽˣһð...");
      pressanykey();
      return;
   }
   if (!HAS_PERM(PERM_SYSOP) && heavyload()) {
      clear();
      prints("ǸĿǰϵͳɹأ˹ʱִ...");
      pressanykey();
      return;
   }
   if (!dashf(cmdfile)) {
      prints("ļ [%s] ڣ\n", cmdfile);
      pressreturn();
      return;
   }
   save_pager = uinfo.pager;
   if (pager == NA) {
      uinfo.pager = 0;
   }
   sprintf(buf,"%s %d",cmdfile,getpid());
   report(buf); 
   my_argv[0] = cmdfile;
   strcpy(buf,param1);
   if(buf[0] != '\0')ptr = strtok(buf," \t");
   else ptr = NULL;
   for(i = 1; i< 18; i++){
      if(ptr) {
         my_argv[i] = ptr;
	 ptr = strtok(NULL," \t");
      } else my_argv[i] = NULL;
   }  
#ifdef MY_DEBUG
   for(i = 0; i< 18; i++){
      if(my_argv[i] != NULL)prints("my_argv[%d] = %s\n",i, my_argv[i]);
      else prints("my_argv[%d] = (none)\n",i);
   }
   pressanykey();
#else
   child_pid = fork();
   if(child_pid == -1){
      prints("Դȱfork() ʧܣԺʹ");
      child_pid = 0;
      pressreturn();
      return;
   }
   if(child_pid == 0){
      execv(cmdfile,my_argv);
      exit(0);
   } else
      waitpid(child_pid, NULL, 0);
#endif
   child_pid = 0;
   uinfo.pager = save_pager;
   clear();
}

void
x_showuser()
{
	char    buf[STRLEN];
	modify_user_mode(SYSINFO);
	clear();
	stand_title("վʹϲѯ");
	ansimore("etc/showuser.msg", NA);
	getdata(20, 0, "Parameter: ", buf, 30, DOECHO, YEA);
	if ((buf[0] == '\0') || dashf("tmp/showuser.result"))
		return;
	securityreport("ѯʹ");
	exec_cmd(SYSINFO, YEA, "bin/showuser", buf);
	sprintf(buf, "tmp/showuser.result");
	if (dashf(buf)) {
		mail_file(buf, currentuser.userid, "ʹϲѯ");
		unlink(buf);
	} 
}

int ent_bnet() { 
   char buf[80];
   sprintf(buf,"etc/bbsnet.ini %s",currentuser.userid);
   exec_cmd(BBSNET,NA,"bin/bbsnet",buf);
}

int ent_winmine() { 
     char buf[80];
     sprintf(buf,"%s %s",currentuser.userid,currentuser.lasthost);
     exec_cmd(WINMINE,NA,"so/winmine",buf);
}
int tetris(){
     char buf[80];
     sprintf(buf,"%s %s",currentuser.userid,currentuser.lasthost);
     exec_cmd(TETRIS,NA,"so/tetris",buf);
}
int winmine2() {
     char buf[80];
     sprintf(buf,"%s %s",currentuser.userid,currentuser.lasthost);
     exec_cmd(WINMINE2,NA,"so/winmine2",buf);
}
int x_cal() { 
        char buf[32], filebuf[80]; 
        struct stat statbuf; 
        modify_user_mode(CAL); 
        clear(); 
        refresh(); 
        prints("ԲѯԪ1--9999ӭʹ![32m89[0;1m,ѯǹԪ89;\n"); 
        prints("ѯ19996µ[32m6 1999[0;1m!!\r\n\r\n"); 
        getdata(2,0,"Ҫѯ·ݺ: ",buf,8,DOECHO,YEA); 
	if(strstr(buf,";")||strstr(buf,"&")) {prints("");pressanykey();return;}
        sprintf(genbuf, "xcal %s", buf); 
        report(genbuf); 
        sprintf(filebuf, "tmp/%s.cal", currentuser.userid); 
        sprintf(genbuf, "/usr/bin/cal %s > %s", buf, filebuf); 
        system(genbuf); 
        bzero(&statbuf, sizeof(statbuf)); 
        stat(filebuf, &statbuf); 
        if(statbuf.st_size>1) { 
                ansimore(filebuf, YEA); 
                unlink (filebuf); 
        } else {prints("\r\n");pressanykey();} 
} 
void
fill_date()
{
	time_t  now, next;
	char   *buf, *buf2, *index, index_buf[5], *t=NULL;
	char    h[3], m[3], s[3];
	int     foo, foo2, i; 
	struct tm *mytm;
	FILE   *fp;
	now = time(0);
	resolve_boards();

	if (now < brdshm->fresh_date && strlen(brdshm->date) != 0)
		return;

	mytm = localtime(&now);
	strftime(h, 3, "%H", mytm);
	strftime(m, 3, "%M", mytm);
	strftime(s, 3, "%S", mytm);

	next = (time_t)time(0) - ((atoi(h) * 3600) + (atoi(m) * 60) + atoi(s)) 
		 + 86400;	/*  0:0:00 ʱ, Ȼһ */

	sprintf(genbuf, "ո, һθʱ %s", Cdate(&next));
	report(genbuf);

	buf = (char *) malloc(80);
	buf2 = (char *) malloc(30);
	index = (char *) malloc(5);

	fp = fopen(DEF_FILE, "r");

	if (fp == NULL)
		return;

	now = time(0);
	mytm = localtime(&now);
	strftime(index_buf, 5, "%m%d", mytm);

	strcpy(brdshm->date,DEF_VALUE);

	while (fgets(buf, 80, fp) != NULL) {
		if (buf[0] == ';' || buf[0] == '#' || buf[0] == ' ')
			continue;

		buf[35] = '\0';
		strncpy(index,buf,4);	index[4] = '\0';
		strcpy(buf2,buf+5);	
                t = strchr(buf2,'\n');  if(t)*t = '\0';

		if (index[0] == '\0' || buf2[0] == '\0')
			continue;

		if (strcmp(index, "0000") == 0||strcmp(index_buf, index) == 0){
			foo = strlen(buf2);
			foo2 = (30 - foo) / 2;
			strcpy(brdshm->date, "");
			for (i = 0; i < foo2; i++)
				strcat(brdshm->date, " ");
			strcat(brdshm->date, buf2);
			for (i = 0; i < 30 - (foo + foo2); i++)
				strcat(brdshm->date, " ");
		}
	}

	fclose(fp);
	brdshm->fresh_date = next;

	free(buf);
	free(buf2);
	free(index);

	return;
}

int
is_birth(user)
struct userec user;
{
	struct tm *tm;
	time_t now;
	
	now = time(0);
	tm = localtime(&now);

	if ( strcasecmp(user.userid, "guest") == 0 )
		return NA;
		
	if ( user.birthmonth == (tm->tm_mon + 1) && user.birthday == tm->tm_mday )
		return YEA;
	else
		return NA;
}

int sendgoodwish(char *uid)
{
   return sendGoodWish(NULL);
}

int sendGoodWish(char *userid)
{
   FILE   *fp;
   int     tuid, i, count, rejects = NA;
   time_t  now;
   char    buf[5][STRLEN], tmpbuf[STRLEN];
   char    uid[IDLEN+1],*timestr;
   
   modify_user_mode(GOODWISH);
   clear();
   move(1, 0);
   prints("[0;1;32mԱ[m\nȥף");
   prints("\nҲΪ/һĻ");
   move(5,0);
   if(userid == NULL){
      usercomplete(" ID: ", uid);
      if (uid[0] == '\0') {
         clear();
	 return 0;
      }
   } else strcpy(uid,userid);
   if (!(tuid = getuser(uid))) {
      move(7, 0);
      prints("[1mʹߴ( ID )ڣ[m\n");
      pressanykey();
      clear();
      return -1;
   }
   if(!strcmp(uid,"guest")) rejects = YEA;
   if(!rejects){
      struct override fh;
      extern int cmpfnames();
      sethomefile(tmpbuf, uid, "rejects");
      rejects = search_record(tmpbuf, &fh, sizeof(fh), 
                              cmpfnames, currentuser.userid);
   }
   if(rejects){
      move(7,0);
      prints("Բ %s Ըף/\n", uid);
      pressanykey();
      clear();
      return -1;
   }   
   move(5,0); 
   prints("[m [1m%s[m ԡ\n", uid);
   move(6,0);
   prints("[ֱӰ ENTER ԣ 5 䣬ÿ 50 ַ]:");
   for( count = 0; count < 5; count ++ ){
      getdata(7+count, 0, ": ", tmpbuf, 51, DOECHO, YEA);
      if(tmpbuf[0] == '\0') break;;
      if(killwordsp(tmpbuf)==0){
         count --;
	 continue;
      }	 
      strcpy(buf[count],tmpbuf);
   }
   if(count == 0) return 0;
   sprintf(genbuf, "ȷҪԸ [1m%s[m ", uid);
   move(9+count, 0);
   if (askyn(genbuf, YEA, NA) == NA) {
      clear();
      return 0;
   }
   sethomefile(genbuf,uid,"GoodWish");
   if ((fp = fopen(genbuf, "a")) == NULL) {
      prints("޷ûĵײϢļ֪ͨվ...\n");
      pressanykey();
      return NA;
   }
   now = time(0);
   timestr = ctime(&now) + 11;
   *(timestr + 5) = '\0';
   for(i = 0; i< count ; i++){
      fprintf(fp, "%s(%s)[%d/%d]%s\n", 
         currentuser.userid,timestr, i+1,count,buf[i]);
   }
   fclose(fp);
   sethomefile(genbuf,uid,"HaveNewWish");
   if((fp = fopen(genbuf,"w+")) != NULL){
      fputs("Have New Wish",fp);
      fclose(fp);
   }
   move(11+count, 0);
   prints("Ѿͳˡ");
   sprintf(genbuf,"SendGoodWish to %s",uid);
   report(genbuf);
   pressanykey();
   clear();
   return 0;
}

#ifdef TIMECOUNTER
int getnowdatestring( void )
{ /* function add by quickmouse for enhance getdatestring 01/03/07 */
    if( tstrshm == NULL ) resolve_tstrshm();
    strcpy( datestring, tstrshm-> datestring );
    return (tstrshm->spare);
}
#endif
/* Added End. */

int getdatestring( time_t now, int Chang)
{
	struct tm *tm;
	char weeknum[7][3]={"","һ","","","","",""};

	tm = localtime(&now);
	sprintf(datestring,"%4d%02d%02d%02d:%02d:%02d %2s",
		tm->tm_year+1900,tm->tm_mon+1,tm->tm_mday,
		tm->tm_hour,tm->tm_min,tm->tm_sec,
		weeknum[tm->tm_wday]);
        return (tm->tm_sec % 10);
}

#ifdef ALLOWGAME
extern char BoardName[];
downline_title()
{
   if (chkmail()) strcpy(genbuf, "[ż]");
   else strcpy(genbuf, BoardName);
   showtitle("[]", genbuf);
   prints( " [ܶ] [[1;32m[m,[1;32me[m] 뿪 [[1;32mh[m]  [[1;32m[m,[1;32m[m] ѡ [[1;32md[m] ɾ\n");
    prints("[1;44m   ߴ       עʱ     ڽ(Ԫ)     ۼƽ(Ԫ)  ״̬ [m\n");
}

char *downline_doentry(int ent, struct downline *fh)
{
   static char buf[STRLEN];
   getdatestring(fh->time,NA);
   sprintf(buf, " %4d  %-12.12s   %14.14s %9d %9d %11d      %s", 
      ent, fh->id, datestring,fh->last,fh->num,
      fh->total,fh->mode);
   return buf;
}

int downline_help() { 
   show_help("help/downlinehelp"); 
   return FULLUPDATE; 
}

int downline_del(int ent, struct downline *fh, char   *direct)
{
   FILE *fp;
   struct downline dl;
   int     deleted = 0, ssize = sizeof(struct downline);
   char    buf[STRLEN];
   saveline(t_lines - 1, 0);
   sprintf(buf, "Ƿѡ%sȥ", fh->id);
   if (askyn(buf, NA, YEA) == YEA) {
      setuserfile(buf, "downline");
      memset(&dl,0,ssize);
      fp = fopen(buf,"r");
      if(fp){
         fseek(fp,(ent-1)*ssize,SEEK_SET);
	 fread(&dl, ssize, 1, fp);
	 fclose(fp);
      }
      if(dl.time == fh->time){ 
         deleted = 1;
         delete_record(buf, sizeof( struct downline), ent);
      } 
   }
   saveline(t_lines - 1, 1);
   return (deleted) ? PARTUPDATE : DONOTHING;
}

struct one_key downline_list[] = {
   'd', downline_del,
   'h', downline_help,
   'H', downline_help,
   '\0', NULL
};

t_downline() 
{
   char    buf[STRLEN];
   setuserfile(buf, "downline");
   i_read(DOWNLINE,buf,downline_title, downline_doentry, 
       downline_list, sizeof (struct downline));
   clear();
   return;
}

void update_game_money(void)
{
   FILE *fp;
   struct Money mdata;
   char buf[STRLEN];

   setuserfile(buf,"game_money.dat");
   if(dashf(buf)) return;
   fp = fopen(buf,"w+");
   if(fp==NULL) return;
   memset(&mdata,0,sizeof(struct Money));
   strcpy(mdata.id,currentuser.userid);
   mdata.money = currentuser.money;
   mdata.ingot = currentuser.medals;
   if(currentuser.inbank>0){
      mdata.outbank = currentuser.inbank;
      mdata.outime = currentuser.banktime;
   }
   if(!fwrite(&mdata, sizeof(mdata), 1, fp)){
      fclose(fp);
      report("write money.dat error.");
      unlink(buf);
      return;
   }
   fclose(fp);
   currentuser.money = 0;
   currentuser.medals = 0;
   currentuser.inbank = 0;
   currentuser.banktime = 0;
}

void check_downline(void)
{
   FILE *fp,*fpnew;
   struct tm *tm;
   struct stat st;
   struct downline tmp;
   char buf[STRLEN], new[STRLEN];
   time_t now = time(0);
   long int money = (long int) currentuser.money;

   tm = localtime(&now);
   if(tm->tm_mday!=6&&tm->tm_mday!=21) return;
   setuserfile(buf,"downline");
   setuserfile(new,"downline.new");
   if(stat(buf,&st)==-1||st.st_size==0) return;
   if(st.st_ctime/86400 >= now/86400)return;
   if(dashf(new)) unlink(new);
   fp = fopen(buf,"r");
   if(fp == NULL) return ;
   fpnew = fopen(new,"a+");
   if(fpnew == NULL) {
      fclose(fp);
      return;
   }
   #ifndef TIMECOUNTER
   getdatestring(now,NA);
   #else
   getnowdatestring();
   #endif
   while(fread(&tmp,sizeof(tmp),1,fp) > 0 ){
      if(tmp.status < 6 ){
         if(!strcasecmp(tmp.id,currentuser.userid)) continue;
	 tmp.num ++;
         if(tmp.status == 0) {
	    if(getuser(tmp.id)<=0) continue;
	    money += 200;
	    tmp.status = 1;
	    tmp.total = tmp.last = 200;
	    tmp.money = 1000;
	    strcpy(tmp.mode,"С");
         } else if (getuser(tmp.id) <= 0){
	    if(tmp.status == 1){
	       strcpy(tmp.mode,"ز");
	       money -= 300;
	       tmp.total -= 300;
	       tmp.last = -300;
	       tmp.status = 7;
	    } else  {
	       strcpy(tmp.mode,"");  
	       money += 100;
	       tmp.total += 100;
	       tmp.last = 100;
	       tmp.status = 8;
            } 
         } else {
	    int oldmoney = tmp.money;
	    int total = lookupuser.money+lookupuser.numposts*5
	               +lookupuser.numlogins*2+lookupuser.medals*1000;
	    tmp.money = total/20;
	    total -= oldmoney*20;
	    if(total < 0 ) total =0;
	    if(total > 200000) total = 200000;
	    total /= 20;
	    tmp.last = total;
	    money += total;
	    tmp.total += total; 
	    if(tmp.total < 2000){
	       tmp.status = 1;
	       strcpy(tmp.mode,"С");
	    } else if(tmp.total < 80000){
	       tmp.status = 2;
	       strcpy(tmp.mode,"");
	    } else if(tmp.total < 200000){
	       tmp.status = 3;
	       strcpy(tmp.mode,"");
	    } else if(tmp.total < 450000){
	       tmp.status = 4;
	       strcpy(tmp.mode,"׳");
	    } else if(tmp.total < 500000){
	       tmp.status = 5;
	       strcpy(tmp.mode,"");
	    } else {
	       tmp.status = 6;
	       strcpy(tmp.mode,"");
	    }
	    if(tmp.num>=99){
	       tmp.status = 6;
	       strcpy(tmp.mode,"");
	    }
	 }
      }
      if(!fwrite(&tmp, sizeof(tmp), 1, fpnew)){
         fclose(fp);
	 fclose(fpnew);
	 report("write downline error.");
	 return;
      }	 
   }   
   if(money<0) currentuser.money =0;
   else if(money>400000000)currentuser.money = 400000000 ;
   else currentuser.money = money;
   fclose(fp);
   fclose(fpnew);
   unlink(buf);
   rename(new,buf);
}
#endif
/* Added End. */

